(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/net/uri#uri-unreserved-chars
    '"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-._~")
  (define std/net/uri#uri-gendelim-chars '":/?#[]@")
  (define std/net/uri#uri-subdelim-chars '"!$&'()*+,;=")
  (define std/net/uri#make-uri-encoding-table__%
    (lambda (_self-chars114927_ _sub-chars114928_)
      (let ((_vt114930_ (make-vector '256 '#f))
            (_len114931_ (string-length _self-chars114927_)))
        (let _lp114933_ ((_n114935_ '0))
          (if (##fx< _n114935_ _len114931_)
              (let ((_char114937_ (##string-ref _self-chars114927_ _n114935_)))
                (vector-set!
                 _vt114930_
                 (char->integer _char114937_)
                 _char114937_)
                (_lp114933_ (##fx+ _n114935_ '1)))
              '#!void))
        (for-each
         (lambda (_e114938114940_)
           (let* ((_g114942114949_ _e114938114940_)
                  (_E114944114953_
                   (lambda () (error '"No clause matching" _g114942114949_)))
                  (_K114945114959_
                   (lambda (_sub114956_ _char114957_)
                     (vector-set!
                      _vt114930_
                      (char->integer _char114957_)
                      _sub114956_))))
             (if (##pair? _g114942114949_)
                 (let ((_hd114946114962_ (##car _g114942114949_))
                       (_tl114947114964_ (##cdr _g114942114949_)))
                   (let* ((_char114967_ _hd114946114962_)
                          (_sub114969_ _tl114947114964_))
                     (_K114945114959_ _sub114969_ _char114967_)))
                 (_E114944114953_))))
         _sub-chars114928_)
        _vt114930_)))
  (define std/net/uri#make-uri-encoding-table__0
    (lambda (_self-chars114974_)
      (let ((_sub-chars114976_ '()))
        (std/net/uri#make-uri-encoding-table__%
         _self-chars114974_
         _sub-chars114976_))))
  (define std/net/uri#make-uri-encoding-table
    (lambda _g115005_
      (let ((_g115004_ (length _g115005_)))
        (cond ((##fx= _g115004_ 1)
               (apply std/net/uri#make-uri-encoding-table__0 _g115005_))
              ((##fx= _g115004_ 2)
               (apply std/net/uri#make-uri-encoding-table__% _g115005_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/uri#make-uri-encoding-table
                _g115005_))))))
  (define std/net/uri#uri-encoding
    (std/net/uri#make-uri-encoding-table__0 std/net/uri#uri-unreserved-chars))
  (define std/net/uri#uri-space-encoding
    (std/net/uri#make-uri-encoding-table__%
     std/net/uri#uri-unreserved-chars
     '((#\space . #\+))))
  (define std/net/uri#uri-encode__%
    (lambda (_str114912_ _vt114913_)
      (if (and (vector? _vt114913_) (##fx= (vector-length _vt114913_) '256))
          '#!void
          (error '"Bad encoding table" _vt114913_))
      (with-output-to-string
       '()
       (lambda () (std/net/uri#write-uri-encoded _str114912_ _vt114913_)))))
  (define std/net/uri#uri-encode__0
    (lambda (_str114919_)
      (let ((_vt114921_ std/net/uri#uri-encoding))
        (std/net/uri#uri-encode__% _str114919_ _vt114921_))))
  (define std/net/uri#uri-encode
    (lambda _g115007_
      (let ((_g115006_ (length _g115007_)))
        (cond ((##fx= _g115006_ 1) (apply std/net/uri#uri-encode__0 _g115007_))
              ((##fx= _g115006_ 2) (apply std/net/uri#uri-encode__% _g115007_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/uri#uri-encode
                _g115007_))))))
  (define std/net/uri#form-url-encode__%
    (lambda (_fields114824_ _+space?114825_)
      (letrec* ((_encoding114827_
                 (if _+space?114825_
                     std/net/uri#uri-space-encoding
                     std/net/uri#uri-encoding))
                (_encode-field114828_
                 (lambda (_field114871_)
                   (let* ((_field114872114879_ _field114871_)
                          (_E114874114883_
                           (lambda ()
                             (error '"No clause matching"
                                    _field114872114879_)))
                          (_K114875114889_
                           (lambda (_val114886_ _key114887_)
                             (std/net/uri#write-uri-encoded
                              _key114887_
                              _encoding114827_)
                             (if _val114886_
                                 (begin
                                   (write-char '#\=)
                                   (std/net/uri#write-uri-encoded
                                    _val114886_
                                    _encoding114827_))
                                 '#!void))))
                     (if (##pair? _field114872114879_)
                         (let ((_hd114876114892_ (##car _field114872114879_))
                               (_tl114877114894_ (##cdr _field114872114879_)))
                           (let* ((_key114897_ _hd114876114892_)
                                  (_val114899_ _tl114877114894_))
                             (_K114875114889_ _val114899_ _key114897_)))
                         (_E114874114883_))))))
        (let* ((_fields114829114838_ _fields114824_)
               (_E114832114842_
                (lambda ()
                  (error '"No clause matching" _fields114829114838_))))
          (let ((_K114834114859_
                 (lambda (_rest114853_ _first114854_)
                   (with-output-to-string
                    '()
                    (lambda ()
                      (_encode-field114828_ _first114854_)
                      (for-each
                       (lambda (_field114857_)
                         (write-char '#\&)
                         (_encode-field114828_ _field114857_))
                       _rest114853_)))))
                (_K114833114847_ (lambda () '"")))
            (let ((_try-match114831114850_
                   (lambda ()
                     (if (##null? _fields114829114838_)
                         (_K114833114847_)
                         (_E114832114842_)))))
              (if (##pair? _fields114829114838_)
                  (let ((_tl114836114864_ (##cdr _fields114829114838_))
                        (_hd114835114862_ (##car _fields114829114838_)))
                    (let ((_first114867_ _hd114835114862_)
                          (_rest114869_ _tl114836114864_))
                      (_K114834114859_ _rest114869_ _first114867_)))
                  (_try-match114831114850_))))))))
  (define std/net/uri#form-url-encode__0
    (lambda (_fields114904_)
      (let ((_+space?114906_ '#t))
        (std/net/uri#form-url-encode__% _fields114904_ _+space?114906_))))
  (define std/net/uri#form-url-encode
    (lambda _g115009_
      (let ((_g115008_ (length _g115009_)))
        (cond ((##fx= _g115008_ 1)
               (apply std/net/uri#form-url-encode__0 _g115009_))
              ((##fx= _g115008_ 2)
               (apply std/net/uri#form-url-encode__% _g115009_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/uri#form-url-encode
                _g115009_))))))
  (define std/net/uri#write-uri-encoded
    (lambda (_str114802_ _encoding114803_)
      (letrec ((_write-hex114805_
                (lambda (_n114821_)
                  (write-char (##string-ref '"0123456789ABCDEF" _n114821_)))))
        (let* ((_utf8114807_ (std/text/utf8#string->utf8__0 _str114802_))
               (_len114809_ (u8vector-length _utf8114807_)))
          (let _lp114812_ ((_n114814_ '0))
            (if (##fx< _n114814_ _len114809_)
                (let ((_byte114816_ (##u8vector-ref _utf8114807_ _n114814_)))
                  (let ((_$e114818_
                         (##vector-ref _encoding114803_ _byte114816_)))
                    (if _$e114818_
                        (write-char _$e114818_)
                        (begin
                          (write-char '#\%)
                          (_write-hex114805_
                           (##fxand (##fxarithmetic-shift _byte114816_ '-4)
                                    '15))
                          (_write-hex114805_ (##fxand _byte114816_ '15)))))
                  (_lp114812_ (##fx+ _n114814_ '1)))
                '#!void))))))
  (define std/net/uri#hex-bytes
    (let ((_ht114796_ (make-table 'test: eq?)))
      (for-each
       (lambda (_n114798_)
         (let ((_char114800_ (##string-ref '"0123456789ABCDEF" _n114798_)))
           (table-set! _ht114796_ _char114800_ _n114798_)
           (table-set! _ht114796_ (char-downcase _char114800_) _n114798_)))
       (iota '16))
      _ht114796_))
  (define std/net/uri#uri-decode__%
    (lambda (_str114750_ _encoding114751_)
      (letrec ((_hex-byte114753_
                (lambda (_byte114779_)
                  (let* ((_char114781_ (integer->char _byte114779_))
                         (_$e114783_
                          (table-ref std/net/uri#hex-bytes _char114781_ '#f)))
                    (if _$e114783_
                        (values _$e114783_)
                        (error '"Malformed uri encoding" _char114781_))))))
        (if _encoding114751_
            (if (and (vector? _encoding114751_)
                     (##fx= (vector-length _encoding114751_) '256))
                '#!void
                (error '"Bad encoding table" _encoding114751_))
            '#!void)
        (let* ((_utf8114755_ (std/text/utf8#string->utf8__0 _str114750_))
               (_len114757_ (u8vector-length _utf8114755_))
               (_pct114759_ (char->integer '#\%)))
          (std/text/utf8#utf8->string__0
           (with-output-to-u8vector
            '()
            (lambda ()
              (let _lp114763_ ((_n114765_ '0))
                (if (##fx< _n114765_ _len114757_)
                    (let* ((_next114767_
                            (##u8vector-ref _utf8114755_ _n114765_))
                           (_$e114769_
                            (if _encoding114751_
                                (##vector-ref _encoding114751_ _next114767_)
                                '#f)))
                      (if _$e114769_
                          ((lambda (_char114772_)
                             (write-char _char114772_)
                             (_lp114763_ (##fx+ _n114765_ '1)))
                           _$e114769_)
                          (if (eq? _next114767_ _pct114759_)
                              (let ((_n114774_ (##fx+ _n114765_ '1)))
                                (if (##fx< (##fx+ _n114774_ '1) _len114757_)
                                    (let ((_hi114776_
                                           (##u8vector-ref
                                            _utf8114755_
                                            _n114774_))
                                          (_lo114777_
                                           (##u8vector-ref
                                            _utf8114755_
                                            (##fx+ _n114774_ '1))))
                                      (write-u8
                                       (##fxior (##fxarithmetic-shift
                                                 (_hex-byte114753_ _hi114776_)
                                                 '4)
                                                (_hex-byte114753_ _lo114777_)))
                                      (_lp114763_ (##fx+ _n114774_ '2)))
                                    (error '"Malformed uri component")))
                              (begin
                                (write-u8 _next114767_)
                                (_lp114763_ (##fx+ _n114765_ '1))))))
                    '#!void)))))))))
  (define std/net/uri#uri-decode__0
    (lambda (_str114789_)
      (let ((_encoding114791_ '#f))
        (std/net/uri#uri-decode__% _str114789_ _encoding114791_))))
  (define std/net/uri#uri-decode
    (lambda _g115011_
      (let ((_g115010_ (length _g115011_)))
        (cond ((##fx= _g115010_ 1) (apply std/net/uri#uri-decode__0 _g115011_))
              ((##fx= _g115010_ 2) (apply std/net/uri#uri-decode__% _g115011_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/uri#uri-decode
                _g115011_))))))
  (define std/net/uri#uri-space-decoding
    (std/net/uri#make-uri-encoding-table__% '"" '((#\+ . #\space))))
  (define std/net/uri#form-url-decode
    (lambda (_str114685_)
      (filter-map1
       (lambda (_part114687_)
         (if (not (string-empty? _part114687_))
             (let* ((_g114688114702_ (string-split _part114687_ '#\=))
                    (_else114691114710_
                     (lambda ()
                       (error '"Malformed form component" _part114687_))))
               (let ((_K114696114732_
                      (lambda (_val114729_ _key114730_)
                        (cons (std/net/uri#uri-decode__%
                               _key114730_
                               std/net/uri#uri-space-decoding)
                              (std/net/uri#uri-decode__%
                               _val114729_
                               std/net/uri#uri-space-decoding))))
                     (_K114693114716_
                      (lambda (_key114714_)
                        (cons (std/net/uri#uri-decode__%
                               _key114714_
                               std/net/uri#uri-space-decoding)
                              '#f))))
                 (if (##pair? _g114688114702_)
                     (let ((_tl114698114737_ (##cdr _g114688114702_))
                           (_hd114697114735_ (##car _g114688114702_)))
                       (if (##pair? _tl114698114737_)
                           (let ((_tl114700114744_ (##cdr _tl114698114737_))
                                 (_hd114699114742_ (##car _tl114698114737_)))
                             (if (##null? _tl114700114744_)
                                 (let ((_key114740_ _hd114697114735_)
                                       (_val114747_ _hd114699114742_))
                                   (_K114696114732_ _val114747_ _key114740_))
                                 (_else114691114710_)))
                           (if (##null? _tl114698114737_)
                               (let ((_key114724_ _hd114697114735_))
                                 (_K114693114716_ _key114724_))
                               (_else114691114710_))))
                     (_else114691114710_))))
             '#f))
       (string-split _str114685_ '#\&)))))
