(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/net/socket/basic-server#!io-state:::init!
    (lambda (_self149228_)
      (if (##fx< '3 (##vector-length _self149228_))
          (begin
            (##vector-set! _self149228_ '1 'blocked)
            (##vector-set! _self149228_ '2 (make-mutex))
            (##vector-set! _self149228_ '3 (make-condition-variable)))
          (error '"struct-instance-init!: too many arguments for struct"
                 _self149228_))))
  (bind-method!
   std/net/socket/base#!io-state::t
   ':init!
   std/net/socket/basic-server#!io-state:::init!
   '#f)
  (define std/net/socket/basic-server#server-poll
    (lambda (_server149094_ _io149095_)
      (let _lp149097_ ()
        (##wait-for-io! _io149095_ '#t)
        (let ((_token149100_ (##structure std/actor/proto#!token::t))
              (_dest149102_ _server149094_))
          (std/actor/message#send-message__%
           _dest149102_
           (##structure
            std/actor/proto#!call::t
            (##structure std/net/socket/base#socket-server.poll::t)
            _token149100_)
           '#f
           '#t)
          (std/actor/proto#!!call-recv _token149100_ _dest149102_))
        (_lp149097_))))
  (define std/net/socket/basic-server#server-loop
    (lambda (_poll-io148840_
             _do-poll148841_
             _add-socket148842_
             _close-socket148843_
             _shutdown!148844_)
      (letrec* ((_poll-thread148846_
                 (if _poll-io148840_
                     (gerbil/gambit/threads#spawn/name
                      'server-poll
                      std/net/socket/basic-server#server-poll
                      (current-thread)
                      _poll-io148840_)
                     '#f)))
        (with-unwind-protect
         (lambda ()
           (with-exception-catcher
            (lambda (_g148847148850_)
              (if '#t
                  (let ((_e148853_ _g148847148850_))
                    (std/logger#log-error '"socket-server error" _e148853_)
                    (_shutdown!148844_)
                    (raise _e148853_))
                  (raise _g148847148850_)))
            (lambda ()
              (let _loop148856_ ()
                (let _loop148858148860_ ()
                  (let ((_next148864_ (thread-mailbox-next)))
                    ((lambda (_$message148867_)
                       (let* ((_$message148869148879_ _$message148867_)
                              (_else148871148887_
                               (lambda () (_loop148858148860_)))
                              (_K148873149070_
                               (lambda (_$options148890_
                                        _$dest148892_
                                        _$source148894_
                                        _$value148896_)
                                 (let* ((_$value148918148943_ _$value148896_)
                                        (_else148924148951_
                                         (lambda () (_loop148858148860_))))
                                   (let ((_K148939149059_
                                          (lambda (_k149057_)
                                            (thread-mailbox-extract-and-rewind)
                                            (_do-poll148841_)
                                            (std/actor/message#send-message__%
                                             _$source148894_
                                             (##structure
                                              std/actor/proto#!value::t
                                              '#!void
                                              _k149057_)
                                             '#f
                                             '#f)
                                            (_loop148856_)))
                                         (_K148935149038_
                                          (lambda (_k149026_ _sock149027_)
                                            (thread-mailbox-extract-and-rewind)
                                            (with-exception-catcher
                                             (lambda (_g149028149030_)
                                               (if '#t
                                                   (let ((_e149033_
                                                          _g149028149030_))
                                                     (std/logger#log-error
                                                      '"socket-server.add"
                                                      _e149033_)
                                                     (std/actor/message#send-message__%
                                                      _$source148894_
                                                      (##structure
                                                       std/actor/proto#!error::t
                                                       _e149033_
                                                       _k149026_)
                                                      '#f
                                                      '#f))
                                                   (raise _g149028149030_)))
                                             (lambda ()
                                               (let ((_ssock149036_
                                                      (_add-socket148842_
                                                       _sock149027_)))
                                                 (std/actor/message#send-message__%
                                                  _$source148894_
                                                  (##structure
                                                   std/actor/proto#!value::t
                                                   _ssock149036_
                                                   _k149026_)
                                                  '#f
                                                  '#f))))
                                            (_loop148856_)))
                                         (_K148930149001_
                                          (lambda (_shutdown148990_
                                                   _dir148991_
                                                   _ssock148992_)
                                            (thread-mailbox-extract-and-rewind)
                                            (with-exception-catcher
                                             (lambda (_g148993148995_)
                                               (if '#t
                                                   (let ((_e148998_
                                                          _g148993148995_))
                                                     (std/logger#log-error
                                                      '"socket-server.close"
                                                      _e148998_))
                                                   (raise _g148993148995_)))
                                             (lambda ()
                                               (_close-socket148843_
                                                _ssock148992_
                                                _dir148991_
                                                _shutdown148990_)))
                                            (_loop148856_)))
                                         (_K148927148975_
                                          (lambda (_k148966_)
                                            (thread-mailbox-extract-and-rewind)
                                            (with-exception-catcher
                                             (lambda (_g148967148969_)
                                               (if '#t
                                                   (let ((_e148972_
                                                          _g148967148969_))
                                                     (std/logger#log-error
                                                      '"socket-server.shutdown!"
                                                      _e148972_)
                                                     (std/actor/message#send-message__%
                                                      _$source148894_
                                                      (##structure
                                                       std/actor/proto#!error::t
                                                       _e148972_
                                                       _k148966_)
                                                      '#f
                                                      '#f))
                                                   (raise _g148967148969_)))
                                             (lambda ()
                                               (_shutdown!148844_)
                                               (std/actor/message#send-message__%
                                                _$source148894_
                                                (##structure
                                                 std/actor/proto#!value::t
                                                 '#!void
                                                 _k148966_)
                                                '#f
                                                '#f)))))
                                         (_K148926148957_
                                          (lambda (_msg148955_)
                                            (thread-mailbox-extract-and-rewind)
                                            (std/logger#warning
                                             '"Unexpected message: ~a"
                                             _msg148955_)
                                            (_loop148856_))))
                                     (let ((_try-match148921149022_
                                            (lambda ()
                                              (if (##structure-direct-instance-of?
                                                   _$value148918148943_
                                                   'std/actor/proto#!event::t)
                                                  (let ((_e148931149004_
                                                         (##vector-ref
                                                          _$value148918148943_
                                                          '1)))
                                                    (if (##structure-direct-instance-of?
                                                         _e148931149004_
                                                         'std/net/socket/base#socket-server.close::t)
                                                        (let* ((_e148932149007_
                                                                (##vector-ref
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         _e148931149004_
                         '1))
                       (_e148933149012_ (##vector-ref _e148931149004_ '2))
                       (_e148934149017_ (##vector-ref _e148931149004_ '3)))
                  (let ((_ssock149010_ _e148932149007_)
                        (_dir149015_ _e148933149012_)
                        (_shutdown149020_ _e148934149017_))
                    (_K148930149001_
                     _shutdown149020_
                     _dir149015_
                     _ssock149010_)))
                (let ((_msg148960_ _$value148918148943_))
                  (_K148926148957_ _msg148960_))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                  (let ((_msg148960_
                                                         _$value148918148943_))
                                                    (_K148926148957_
                                                     _msg148960_))))))
                                       (if (##structure-direct-instance-of?
                                            _$value148918148943_
                                            'std/actor/proto#!call::t)
                                           (let ((_e148940149062_
                                                  (##vector-ref
                                                   _$value148918148943_
                                                   '1)))
                                             (if (##structure-direct-instance-of?
                                                  _e148940149062_
                                                  'std/net/socket/base#socket-server.poll::t)
                                                 (let* ((_e148941149065_
                                                         (##vector-ref
                                                          _$value148918148943_
                                                          '2))
                                                        (_k149068_
                                                         _e148941149065_))
                                                   (_K148939149059_ _k149068_))
                                                 (if (##structure-direct-instance-of?
                                                      _e148940149062_
                                                      'std/net/socket/base#socket-server.add::t)
                                                     (let* ((_e148938149044_
                                                             (##vector-ref
                                                              _e148940149062_
                                                              '1))
                                                            (_e148937149049_
                                                             (##vector-ref
                                                              _$value148918148943_
                                                              '2)))
                                                       (let ((_sock149047_
                                                              _e148938149044_)
                                                             (_k149052_
                                                              _e148937149049_))
                                                         (_K148935149038_
                                                          _k149052_
                                                          _sock149047_)))
                                                     (if (##structure-direct-instance-of?
                                                          _e148940149062_
                                                          'std/net/socket/base#socket-server.shutdown!::t)
                                                         (let* ((_e148929148981_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         (##vector-ref _$value148918148943_ '2))
                        (_k148984_ _e148929148981_))
                   (_K148927148975_ _k148984_))
                 (let ((_msg148960_ _$value148918148943_))
                   (_K148926148957_ _msg148960_))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                           (_try-match148921149022_))))))))
                         (if (##structure-direct-instance-of?
                              _$message148869148879_
                              'std/actor/message#message::t)
                             (let* ((_e148874149073_
                                     (##vector-ref _$message148869148879_ '1))
                                    (_$value149076_ _e148874149073_)
                                    (_e148875149078_
                                     (##vector-ref _$message148869148879_ '2))
                                    (_$source149081_ _e148875149078_)
                                    (_e148876149083_
                                     (##vector-ref _$message148869148879_ '3))
                                    (_$dest149086_ _e148876149083_)
                                    (_e148877149088_
                                     (##vector-ref _$message148869148879_ '4))
                                    (_$options149091_ _e148877149088_))
                               (_K148873149070_
                                _$options149091_
                                _$dest149086_
                                _$source149081_
                                _$value149076_))
                             (_loop148858148860_))))
                     _next148864_)))))))
         (lambda ()
           (if _poll-thread148846_
               (thread-terminate! _poll-thread148846_)
               '#!void))))))
  (define std/net/socket/basic-server#io-state-signal-ready!
    (lambda (_iostate148804_ _how148805_)
      (let* ((_iostate148806148814_ _iostate148804_)
             (_E148808148818_
              (lambda () (error '"No clause matching" _iostate148806148814_)))
             (_K148809148824_
              (lambda (_cv148821_ _mx148822_)
                (mutex-lock! _mx148822_)
                (##direct-structure-set!
                 _iostate148804_
                 _how148805_
                 '1
                 std/net/socket/base#!io-state::t
                 '#f)
                (condition-variable-broadcast! _cv148821_)
                (mutex-unlock! _mx148822_))))
        (if (##structure-direct-instance-of?
             _iostate148806148814_
             'std/net/socket/base#!io-state::t)
            (let* ((_e148810148827_ (##vector-ref _iostate148806148814_ '1))
                   (_e148811148830_ (##vector-ref _iostate148806148814_ '2))
                   (_mx148833_ _e148811148830_)
                   (_e148812148835_ (##vector-ref _iostate148806148814_ '3))
                   (_cv148838_ _e148812148835_))
              (_K148809148824_ _cv148838_ _mx148833_))
            (_E148808148818_)))))
  (define std/net/socket/basic-server#io-state-wait-io!
    (lambda (_iostate148758_ _timeo148759_ _how148760_)
      (let* ((_iostate148761148769_ _iostate148758_)
             (_E148763148773_
              (lambda () (error '"No clause matching" _iostate148761148769_)))
             (_K148764148788_
              (lambda (_cv148776_ _mx148777_)
                (let _lp148779_ ()
                  (mutex-lock! _mx148777_)
                  (let ((_$e148782_
                         (##direct-structure-ref
                          _iostate148758_
                          '1
                          std/net/socket/base#!io-state::t
                          '#f)))
                    (if (eq? 'closed _$e148782_)
                        (begin
                          (mutex-unlock! _mx148777_)
                          (error '"Socket direction has been closed"
                                 _how148760_))
                        (if (eq? 'ready _$e148782_)
                            (begin
                              (##direct-structure-set!
                               _iostate148758_
                               _how148760_
                               '1
                               std/net/socket/base#!io-state::t
                               '#f)
                              (mutex-unlock! _mx148777_)
                              '#!void)
                            (begin
                              (##direct-structure-set!
                               _iostate148758_
                               'blocked
                               '1
                               std/net/socket/base#!io-state::t
                               '#f)
                              (if (mutex-unlock!
                                   _mx148777_
                                   _cv148776_
                                   (or _timeo148759_ absent-obj))
                                  (_lp148779_)
                                  '#f)))))))))
        (if (##structure-direct-instance-of?
             _iostate148761148769_
             'std/net/socket/base#!io-state::t)
            (let* ((_e148765148791_ (##vector-ref _iostate148761148769_ '1))
                   (_e148766148794_ (##vector-ref _iostate148761148769_ '2))
                   (_mx148797_ _e148766148794_)
                   (_e148767148799_ (##vector-ref _iostate148761148769_ '3))
                   (_cv148802_ _e148767148799_))
              (_K148764148788_ _cv148802_ _mx148797_))
            (_E148763148773_)))))
  (define std/net/socket/basic-server#io-state-close-in!
    (lambda (_iostate148754_ _sock148755_ _shutdown148756_)
      (if _shutdown148756_
          (std/net/socket/basic-server#shutdown-socket!
           _sock148755_
           _shutdown148756_)
          (close-input-port _sock148755_))
      (std/net/socket/basic-server#io-state-signal-ready!
       _iostate148754_
       'closed)))
  (define std/net/socket/basic-server#io-state-close-out!
    (lambda (_iostate148750_ _sock148751_ _shutdown148752_)
      (if _shutdown148752_
          (std/net/socket/basic-server#shutdown-socket!
           _sock148751_
           _shutdown148752_)
          (close-output-port _sock148751_))
      (std/net/socket/basic-server#io-state-signal-ready!
       _iostate148750_
       'closed)))
  (define std/net/socket/basic-server#shutdown-socket!
    (lambda (_sock148740_ _how148741_)
      (with-exception-catcher
       (lambda (_g148742148744_)
         (if '#t
             (let ((_e148747_ _g148742148744_))
               (std/logger#log-error
                '"socket-server.shutdown-socket!"
                _e148747_))
             (raise _g148742148744_)))
       (lambda () (std/os/socket#socket-shutdown _sock148740_ _how148741_))))))
