/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.benchlab.har;

import edu.umass.cs.benchlab.har.HarDatabaseConfig;
import edu.umass.cs.benchlab.har.HarQueryParam;
import edu.umass.cs.benchlab.har.HarWarning;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class HarQueryString {
    private List<HarQueryParam> queryParams = new ArrayList<HarQueryParam>();

    public HarQueryString() {
    }

    public HarQueryString(JsonParser jp, List<HarWarning> warnings) throws JsonParseException, IOException {
        if (jp.nextToken() != JsonToken.START_ARRAY) {
            throw new JsonParseException("[ missing after \"queryString\" element " + jp.getCurrentName(), jp.getCurrentLocation());
        }
        while (jp.nextToken() != JsonToken.END_ARRAY) {
            this.addQueryParam(new HarQueryParam(jp, warnings));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HarQueryString(HarDatabaseConfig config, long requestId) throws SQLException {
        Connection c = config.getConnection();
        String tableName = config.getTablePrefix() + HarQueryParam.TABLE_NAME;
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = c.prepareStatement("SELECT id,name,value,comment FROM " + tableName + " WHERE request_id=?");
            ps.setLong(1, requestId);
            rs = ps.executeQuery();
            while (rs.next()) {
                this.addQueryParam(new HarQueryParam(config, rs.getLong(1), rs.getString(2), rs.getString(3), rs.getString(4)));
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            config.closeConnection(c);
        }
    }

    public void writeHar(JsonGenerator g) throws JsonGenerationException, IOException {
        g.writeArrayFieldStart("queryString");
        for (HarQueryParam queryParam : this.queryParams) {
            queryParam.writeHar(g);
        }
        g.writeEndArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJDBC(long requestId, HarDatabaseConfig config, long logId) throws SQLException {
        Connection c = config.getConnection();
        String tableName = config.getTablePrefix() + HarQueryParam.TABLE_NAME;
        if (!config.isCreatedTable(tableName)) {
            try {
                Statement s = c.createStatement();
                s.executeUpdate("CREATE TABLE " + tableName + " (id " + config.getDbAutoGeneratedId() + ",name " + config.getStringDbType() + ",value " + config.getStringDbType() + ",comment " + config.getStringDbType() + ",request_id " + config.getLongDbType() + ")");
                s.close();
                config.addCreatedTable(tableName);
            }
            catch (Exception s) {
                // empty catch block
            }
        }
        PreparedStatement queryPs = c.prepareStatement("INSERT INTO " + tableName + " (name,value,comment,request_id) VALUES (?,?,?,?)", 1);
        try {
            for (HarQueryParam queryParam : this.queryParams) {
                queryParam.writeJDBC(config, requestId, queryPs, logId);
            }
        }
        finally {
            try {
                if (queryPs != null) {
                    queryPs.close();
                }
            }
            catch (Exception exception) {}
            config.closeConnection(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFromJDBC(HarDatabaseConfig config, long logId) throws SQLException {
        String queryTableName = config.getTablePrefix() + HarQueryParam.TABLE_NAME;
        if (!config.isCreatedTable(queryTableName)) {
            return;
        }
        Connection c = config.getConnection();
        Statement ps = null;
        try {
            ps = c.prepareStatement("DELETE FROM " + queryTableName + " WHERE request_id IN (SELECT id FROM " + config.getTablePrefix() + "request WHERE entry_id IN (SELECT entry_id FROM " + config.getTablePrefix() + "entries WHERE log_id=?))");
            ps.setLong(1, logId);
            ps.executeUpdate();
            config.dropTableIfEmpty(c, queryTableName, config);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            config.closeConnection(c);
        }
    }

    public void addQueryParam(HarQueryParam queryParam) {
        this.queryParams.add(queryParam);
    }

    public List<HarQueryParam> getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(List<HarQueryParam> queryParams) {
        this.queryParams = queryParams;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("  \"queryString\": [");
        if (this.queryParams != null) {
            boolean first = true;
            for (HarQueryParam queryParam : this.queryParams) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(queryParam);
            }
        }
        sb.append("]\n");
        return sb.toString();
    }
}

