/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.model.VulnerabilitiesLoader;
import org.zaproxy.zap.model.Vulnerability;

public final class Vulnerabilities {
    private static final Logger LOGGER = Logger.getLogger(Vulnerabilities.class);
    private static List<Vulnerability> vulnerabilities;
    private static Map<String, Vulnerability> vulnerabilitiesMap;

    private Vulnerabilities() {
    }

    private static synchronized void init() {
        if (vulnerabilities == null) {
            VulnerabilitiesLoader loader = new VulnerabilitiesLoader(Paths.get(Constant.getZapInstall(), "lang"), "vulnerabilities", ".xml");
            List<Vulnerability> vulns = loader.load(Constant.getLocale());
            if (vulns.isEmpty()) {
                String path = "/org/zaproxy/zap/resources/vulnerabilities.xml";
                LOGGER.debug((Object)"Using bundled vulnerabilities file.");
                try (InputStream in = VulnerabilitiesLoader.class.getResourceAsStream(path);){
                    if (in == null) {
                        LOGGER.error((Object)("The vulnerabilities file was not bundled: " + path));
                    } else {
                        vulns = VulnerabilitiesLoader.loadVulnerabilities(in);
                        if (vulns == null) {
                            vulns = Collections.emptyList();
                            LOGGER.error((Object)"Failed to load vulnerabilities from bundled file.");
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Failed to read the bundled vulnerabilities file:", (Throwable)e);
                }
            }
            HashMap<String, Vulnerability> map = new HashMap<String, Vulnerability>();
            for (Vulnerability vulnerability : vulns) {
                map.put(vulnerability.getId(), vulnerability);
            }
            vulnerabilitiesMap = Collections.unmodifiableMap(map);
            vulnerabilities = vulns;
        }
    }

    public static List<Vulnerability> getAllVulnerabilities() {
        Vulnerabilities.initializeIfEmpty();
        return vulnerabilities;
    }

    public static Vulnerability getVulnerability(String id) {
        Vulnerabilities.initializeIfEmpty();
        return vulnerabilitiesMap.get(id);
    }

    private static void initializeIfEmpty() {
        if (vulnerabilities == null) {
            Vulnerabilities.init();
        }
    }

    public static String getDescription(Vulnerability vuln) {
        if (vuln != null) {
            return vuln.getDescription();
        }
        return "Failed to load vulnerability description from file";
    }

    public static String getSolution(Vulnerability vuln) {
        if (vuln != null) {
            return vuln.getSolution();
        }
        return "Failed to load vulnerability solution from file";
    }

    public static String getReference(Vulnerability vuln) {
        if (vuln != null) {
            StringBuilder sb = new StringBuilder();
            for (String ref : vuln.getReferences()) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(ref);
            }
            return sb.toString();
        }
        return "Failed to load vulnerability reference from file";
    }
}

