/*
 * Decompiled with CFR 0.152.
 */
package com.github.cereda.arara.utils;

import com.github.cereda.arara.controller.ConfigurationController;
import com.github.cereda.arara.controller.LanguageController;
import com.github.cereda.arara.model.AraraException;
import com.github.cereda.arara.model.Argument;
import com.github.cereda.arara.model.Command;
import com.github.cereda.arara.model.Conditional;
import com.github.cereda.arara.model.Messages;
import com.github.cereda.arara.model.Rule;
import com.github.cereda.arara.utils.CommonUtils;
import com.github.cereda.arara.utils.DisplayUtils;
import com.github.cereda.arara.utils.TeeOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.InvalidExitValueException;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.listener.ShutdownHookProcessDestroyer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpreterUtils {
    private static final LanguageController messages = LanguageController.getInstance();
    private static final Logger logger = LoggerFactory.getLogger(InterpreterUtils.class);

    public static List<String> getRuleArguments(Rule rule) {
        Collection<String> result = CollectionUtils.collect(rule.getArguments(), new Transformer<Argument, String>(){

            @Override
            public String transform(Argument input) {
                return input.getIdentifier();
            }
        });
        return new ArrayList<String>(result);
    }

    public static boolean runPriorEvaluation(Conditional conditional) {
        if (((Boolean)ConfigurationController.getInstance().get("execution.dryrun")).booleanValue()) {
            return false;
        }
        switch (conditional.getType()) {
            case IF: 
            case WHILE: 
            case UNLESS: {
                return true;
            }
        }
        return false;
    }

    public static int run(Object command) throws AraraException {
        TeeOutputStream tee;
        boolean verbose = (Boolean)ConfigurationController.getInstance().get("execution.verbose");
        boolean timeout = (Boolean)ConfigurationController.getInstance().get("execution.timeout");
        long value = (Long)ConfigurationController.getInstance().get("execution.timeout.value");
        TimeUnit unit = (TimeUnit)((Object)ConfigurationController.getInstance().get("execution.timeout.unit"));
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ProcessExecutor executor = new ProcessExecutor();
        if (CommonUtils.checkClass(Command.class, command)) {
            executor = executor.command(((Command)command).getElements());
            if (((Command)command).hasWorkingDirectory()) {
                executor = executor.directory(((Command)command).getWorkingDirectory());
            }
        } else {
            executor = executor.commandSplit((String)command);
        }
        if (timeout) {
            if (value == 0L) {
                throw new AraraException(messages.getMessage(Messages.ERROR_RUN_TIMEOUT_INVALID_RANGE));
            }
            executor = executor.timeout(value, unit);
        }
        if (verbose) {
            tee = new TeeOutputStream(System.out, buffer);
            executor = executor.redirectInput(System.in);
        } else {
            tee = new TeeOutputStream(buffer);
        }
        executor = executor.redirectOutput(tee).redirectError(tee);
        ShutdownHookProcessDestroyer hook = new ShutdownHookProcessDestroyer();
        executor = executor.addDestroyer(hook);
        try {
            int exit = executor.execute().getExitValue();
            logger.info(DisplayUtils.displayOutputSeparator(messages.getMessage(Messages.LOG_INFO_BEGIN_BUFFER)));
            logger.info(buffer.toString());
            logger.info(DisplayUtils.displayOutputSeparator(messages.getMessage(Messages.LOG_INFO_END_BUFFER)));
            return exit;
        }
        catch (IOException ioexception) {
            throw new AraraException(messages.getMessage(Messages.ERROR_RUN_IO_EXCEPTION), ioexception);
        }
        catch (InterruptedException iexception) {
            throw new AraraException(messages.getMessage(Messages.ERROR_RUN_INTERRUPTED_EXCEPTION), iexception);
        }
        catch (InvalidExitValueException ievexception) {
            throw new AraraException(messages.getMessage(Messages.ERROR_RUN_INVALID_EXIT_VALUE_EXCEPTION), ievexception);
        }
        catch (TimeoutException texception) {
            throw new AraraException(messages.getMessage(Messages.ERROR_RUN_TIMEOUT_EXCEPTION), texception);
        }
        catch (Exception exception) {
            throw new AraraException(messages.getMessage(Messages.ERROR_RUN_GENERIC_EXCEPTION), exception);
        }
    }

    public static File buildRulePath(String name) throws AraraException {
        List paths = (List)ConfigurationController.getInstance().get("execution.rule.paths");
        for (String path : paths) {
            File location = new File(InterpreterUtils.construct(path, name));
            if (!location.exists()) continue;
            return location;
        }
        return null;
    }

    public static String construct(String path, String name) throws AraraException {
        name = name.concat(".yaml");
        File location = new File(path);
        if (location.isAbsolute()) {
            return CommonUtils.buildPath(path, name);
        }
        File reference = (File)ConfigurationController.getInstance().get("execution.reference");
        String parent = CommonUtils.buildPath(CommonUtils.getParentCanonicalPath(reference), path);
        return CommonUtils.buildPath(parent, name);
    }
}

