/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.linguistic.lucene;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.th.ThaiTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.carrot2.text.analysis.ITokenizer;
import org.carrot2.text.util.MutableCharArray;
import org.carrot2.util.ExceptionUtils;

public final class ThaiTokenizerAdapter
implements ITokenizer {
    private CharTermAttribute term = null;
    private final MutableCharArray tempCharSequence = new MutableCharArray(new char[0]);
    private ThaiTokenizer tokenizer;

    public ThaiTokenizerAdapter() {
        if (!ThaiTokenizerAdapter.platformSupportsThai()) {
            throw new RuntimeException("Thai segmentation not supported on this platform.");
        }
    }

    @Override
    public short nextToken() throws IOException {
        boolean hasNextToken = this.tokenizer.incrementToken();
        if (hasNextToken) {
            char[] image = this.term.buffer();
            int length = this.term.length();
            this.tempCharSequence.reset(image, 0, length);
            return 1;
        }
        return -1;
    }

    @Override
    public void setTermBuffer(MutableCharArray array) {
        array.reset(this.term.buffer(), 0, this.term.length());
    }

    @Override
    public void reset(Reader input) throws IOException {
        assert (input != null);
        try {
            this.tokenizer = new ThaiTokenizer();
            this.tokenizer.setReader(input);
            this.term = (CharTermAttribute)this.tokenizer.addAttribute(CharTermAttribute.class);
            this.tokenizer.reset();
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsRuntimeException(e);
        }
    }

    public static boolean platformSupportsThai() {
        try {
            return ThaiTokenizer.DBBI_AVAILABLE;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

