/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix.factorization;

import org.carrot2.mahout.math.function.Functions;
import org.carrot2.mahout.math.function.Mult;
import org.carrot2.mahout.math.matrix.DoubleMatrix2D;
import org.carrot2.mahout.math.matrix.impl.DenseDoubleMatrix2D;
import org.carrot2.matrix.MatrixUtils;
import org.carrot2.matrix.factorization.IterativeMatrixFactorizationBase;

public class KMeansMatrixFactorization
extends IterativeMatrixFactorizationBase {
    public KMeansMatrixFactorization(DoubleMatrix2D A) {
        super(A);
    }

    @Override
    public void compute() {
        int n = this.A.columns();
        DenseDoubleMatrix2D D = new DenseDoubleMatrix2D(this.k, n);
        this.V = new DenseDoubleMatrix2D(n, this.k);
        this.U = new DenseDoubleMatrix2D(this.A.rows(), this.k);
        this.U.assign(this.A.viewPart(0, 0, this.A.rows(), this.k));
        int[] minIndices = new int[D.columns()];
        double[] minValues = new double[D.columns()];
        this.iterationsCompleted = 0;
        while (this.iterationsCompleted < this.maxIterations) {
            this.U.zMult(this.A, D, 1.0, 0.0, true, false);
            this.V.assign(0.0);
            this.U.assign(0.0);
            MatrixUtils.maxInColumns(D, minIndices, minValues);
            for (int i = 0; i < minIndices.length; ++i) {
                this.V.setQuick(i, minIndices[i], 1.0);
            }
            for (int c = 0; c < this.V.columns(); ++c) {
                int count = 0;
                for (int d = 0; d < this.V.rows(); ++d) {
                    if (this.V.getQuick(d, c) == 0.0) continue;
                    ++count;
                    this.U.viewColumn(c).assign(this.A.viewColumn(d), Functions.PLUS);
                }
                this.U.viewColumn(c).assign(Mult.div(count));
                MatrixUtils.normalizeColumnL2(this.U, null);
            }
            ++this.iterationsCompleted;
        }
    }

    public String toString() {
        return "KMMF";
    }
}

