/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.client.auth;

import java.security.NoSuchAlgorithmException;
import net.jradius.client.auth.RadiusAuthenticator;
import net.jradius.exception.RadiusException;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.util.MSCHAP;
import net.jradius.util.RadiusRandom;

public class MSCHAPv2Authenticator
extends RadiusAuthenticator {
    public static final String NAME = "mschapv2";

    public String getAuthName() {
        return NAME;
    }

    public void processRequest(RadiusPacket p) throws RadiusException, NoSuchAlgorithmException {
        if (this.password == null) {
            throw new RadiusException("Password required");
        }
        p.removeAttribute(this.password);
        byte[] authChallenge = RadiusRandom.getBytes(16);
        byte[] chapResponse = MSCHAP.doMSCHAPv2(this.username.getValue().getBytes(), this.password.getValue().getBytes(), authChallenge);
        RadiusAttribute attr = AttributeFactory.newAttribute("MS-CHAP-Challenge");
        p.addAttribute(attr);
        attr.setValue(authChallenge);
        attr = AttributeFactory.newAttribute("MS-CHAP2-Response");
        p.addAttribute(attr);
        attr.setValue(chapResponse);
    }
}

