"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableFactoryRenderer = void 0;

var _react = _interopRequireDefault(require("react"));

var _i18n = require("@kbn/i18n");

var _embeddable_root = require("./embeddable_root");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var EmbeddableFactoryRenderer =
/*#__PURE__*/
function (_React$Component) {
  _inherits(EmbeddableFactoryRenderer, _React$Component);

  function EmbeddableFactoryRenderer(props) {
    var _this;

    _classCallCheck(this, EmbeddableFactoryRenderer);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(EmbeddableFactoryRenderer).call(this, props));

    _defineProperty(_assertThisInitialized(_this), "embeddable", void 0);

    _this.state = {
      loading: true,
      error: undefined
    };
    return _this;
  }

  _createClass(EmbeddableFactoryRenderer, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;

      var factory = this.props.getEmbeddableFactory(this.props.type);

      if (factory === undefined) {
        this.setState({
          loading: false,
          error: _i18n.i18n.translate('embeddableApi.errors.factoryDoesNotExist', {
            defaultMessage: 'Embeddable factory of {type} does not exist. Ensure all neccessary plugins are installed and enabled.',
            values: {
              type: this.props.type
            }
          })
        });
        return;
      }

      factory.create(this.props.input).then(function (embeddable) {
        _this2.embeddable = embeddable;

        _this2.setState({
          loading: false
        });
      });
    }
  }, {
    key: "render",
    value: function render() {
      return _react.default.createElement(_embeddable_root.EmbeddableRoot, {
        embeddable: this.embeddable,
        loading: this.state.loading,
        error: this.state.error
      });
    }
  }]);

  return EmbeddableFactoryRenderer;
}(_react.default.Component);

exports.EmbeddableFactoryRenderer = EmbeddableFactoryRenderer;