"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var specs_1 = require("../utils/specs");
var annotation_utils_1 = require("./annotation_utils");
function computeRectAnnotationTooltipState(
/** the cursor position relative to the projection area */
cursorPosition, annotationRects, chartRotation, chartDimensions, renderTooltip) {
    var rotatedCursorPosition = annotation_utils_1.getRotatedCursor(cursorPosition, chartDimensions, chartRotation);
    var totalAnnotationRect = annotationRects.length;
    for (var i = 0; i < totalAnnotationRect; i++) {
        var rectProps = annotationRects[i];
        var rect = rectProps.rect, details = rectProps.details;
        var startX = rect.x;
        var endX = startX + rect.width;
        var startY = rect.y;
        var endY = startY + rect.height;
        var bounds = { startX: startX, endX: endX, startY: startY, endY: endY };
        var isWithinBounds = isWithinRectBounds(rotatedCursorPosition, bounds);
        if (isWithinBounds) {
            return __assign(__assign({ isVisible: true, annotationType: specs_1.AnnotationTypes.Rectangle, anchor: {
                    left: rotatedCursorPosition.x,
                    top: rotatedCursorPosition.y,
                } }, (details && { details: details })), (renderTooltip && { renderTooltip: renderTooltip }));
        }
    }
    return {
        isVisible: false,
    };
}
exports.computeRectAnnotationTooltipState = computeRectAnnotationTooltipState;
function isWithinRectBounds(_a, _b) {
    var x = _a.x, y = _a.y;
    var startX = _b.startX, endX = _b.endX, startY = _b.startY, endY = _b.endY;
    var withinXBounds = x >= startX && x <= endX;
    var withinYBounds = y >= startY && y <= endY;
    return withinXBounds && withinYBounds;
}
exports.isWithinRectBounds = isWithinRectBounds;
function computeRectAnnotationDimensions(annotationSpec, yScales, xScale, enableHistogramMode, barsPadding) {
    var dataValues = annotationSpec.dataValues;
    var groupId = annotationSpec.groupId;
    var yScale = yScales.get(groupId);
    if (!yScale) {
        return null;
    }
    var xDomain = xScale.domain;
    var yDomain = yScale.domain;
    var lastX = xDomain[xDomain.length - 1];
    var xMinInterval = xScale.minInterval;
    var rectsProps = [];
    dataValues.forEach(function (dataValue) {
        var _a = dataValue.coordinates, x0 = _a.x0, x1 = _a.x1, y0 = _a.y0, y1 = _a.y1;
        // if everything is null, return; otherwise we coerce the other coordinates
        if (x0 == null && x1 == null && y0 == null && y1 == null) {
            return;
        }
        if (x1 == null) {
            // if x1 is defined, we want the rect to draw to the end of the scale
            // if we're in histogram mode, extend domain end by min interval
            x1 = enableHistogramMode && !xScale.isSingleValue() ? lastX + xMinInterval : lastX;
        }
        if (x0 == null) {
            // if x0 is defined, we want the rect to draw to the start of the scale
            x0 = xDomain[0];
        }
        if (y0 == null) {
            // if y0 is defined, we want the rect to draw to the end of the scale
            y0 = yDomain[yDomain.length - 1];
        }
        if (y1 == null) {
            // if y1 is defined, we want the rect to draw to the start of the scale
            y1 = yDomain[0];
        }
        var alignWithTick = xScale.bandwidth > 0 && !enableHistogramMode;
        var x0Scaled = annotation_utils_1.scaleAndValidateDatum(x0, xScale, alignWithTick);
        var x1Scaled = annotation_utils_1.scaleAndValidateDatum(x1, xScale, alignWithTick);
        var y0Scaled = annotation_utils_1.scaleAndValidateDatum(y0, yScale, false);
        var y1Scaled = annotation_utils_1.scaleAndValidateDatum(y1, yScale, false);
        // TODO: surface this as a warning
        if (x0Scaled === null || x1Scaled === null || y0Scaled === null || y1Scaled === null) {
            return;
        }
        var xOffset = 0;
        if (xScale.bandwidth > 0) {
            var xBand = xScale.bandwidth / (1 - xScale.barsPadding);
            xOffset = enableHistogramMode ? (xBand - xScale.bandwidth) / 2 : barsPadding;
        }
        x0Scaled = x0Scaled - xOffset;
        x1Scaled = x1Scaled - xOffset;
        var minX = Math.min(x0Scaled, x1Scaled);
        var minY = Math.min(y0Scaled, y1Scaled);
        var deltaX = Math.abs(x0Scaled - x1Scaled);
        var deltaY = Math.abs(y0Scaled - y1Scaled);
        var xOrigin = minX;
        var yOrigin = minY;
        var width = deltaX;
        var height = deltaY;
        var rectDimensions = {
            x: xOrigin,
            y: yOrigin,
            width: width,
            height: height,
        };
        rectsProps.push({
            rect: rectDimensions,
            details: dataValue.details,
        });
    });
    return rectsProps;
}
exports.computeRectAnnotationDimensions = computeRectAnnotationDimensions;
//# sourceMappingURL=rect_annotation_tooltip.js.map