import { FOCUS_DISABLED, FOCUS_GROUP } from '../constants';
import { toArray } from './array';

var filterNested = function filterNested(nodes) {
  var l = nodes.length;
  var i = void 0;
  var j = void 0;
  for (i = 0; i < l; i += 1) {
    for (j = 0; j < l; j += 1) {
      if (i !== j) {
        if (nodes[i].contains(nodes[j])) {
          return filterNested(nodes.filter(function (x) {
            return x !== nodes[j];
          }));
        }
      }
    }
  }
  return nodes;
};

var getTopParent = function getTopParent(node) {
  return node.parentNode ? getTopParent(node.parentNode) : node;
};

var getAllAffectedNodes = function getAllAffectedNodes(node) {
  var group = node.getAttribute(FOCUS_GROUP);
  if (group) {
    return filterNested(toArray(getTopParent(node).querySelectorAll('[' + FOCUS_GROUP + '="' + group + '"]:not([' + FOCUS_DISABLED + '="disabled"])')));
  }
  return [node];
};

export default getAllAffectedNodes;