/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.SetBackedScalingCuckooFilter;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.terms.InternalMappedRareTerms;
import org.elasticsearch.search.aggregations.bucket.terms.InternalRareTerms;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class StringRareTerms
extends InternalMappedRareTerms<StringRareTerms, Bucket> {
    public static final String NAME = "srareterms";

    StringRareTerms(String name, BucketOrder order, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData, DocValueFormat format, List<Bucket> buckets, long maxDocCount, SetBackedScalingCuckooFilter filter) {
        super(name, order, pipelineAggregators, metaData, format, buckets, maxDocCount, filter);
    }

    public StringRareTerms(StreamInput in) throws IOException {
        super(in, Bucket::new);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public StringRareTerms create(List<Bucket> buckets) {
        return new StringRareTerms(this.name, this.order, this.pipelineAggregators(), (Map<String, Object>)this.metaData, this.format, buckets, this.maxDocCount, this.filter);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.termBytes, prototype.getDocCount(), aggregations, prototype.format);
    }

    @Override
    protected StringRareTerms createWithFilter(String name, List<Bucket> buckets, SetBackedScalingCuckooFilter filterFilter) {
        return new StringRareTerms(name, this.order, this.pipelineAggregators(), (Map<String, Object>)this.metaData, this.format, buckets, this.maxDocCount, filterFilter);
    }

    protected Bucket[] createBucketsArray(int size) {
        return new Bucket[size];
    }

    @Override
    public boolean containsTerm(SetBackedScalingCuckooFilter filter, Bucket bucket) {
        return filter.mightContain(bucket.termBytes);
    }

    @Override
    public void addToFilter(SetBackedScalingCuckooFilter filter, Bucket bucket) {
        filter.add(bucket.termBytes);
    }

    @Override
    Bucket createBucket(long docCount, InternalAggregations aggs, Bucket prototype) {
        return new Bucket(prototype.termBytes, docCount, aggs, this.format);
    }

    public static class Bucket
    extends InternalRareTerms.Bucket<Bucket> {
        BytesRef termBytes;

        public Bucket(BytesRef term, long docCount, InternalAggregations aggregations, DocValueFormat format) {
            super(docCount, aggregations, format);
            this.termBytes = term;
        }

        public Bucket(StreamInput in, DocValueFormat format) throws IOException {
            super(in, format);
            this.termBytes = in.readBytesRef();
        }

        @Override
        protected void writeTermTo(StreamOutput out) throws IOException {
            out.writeBytesRef(this.termBytes);
        }

        @Override
        public Object getKey() {
            return this.getKeyAsString();
        }

        @Override
        public Number getKeyAsNumber() {
            try {
                return Long.parseLong(this.termBytes.utf8ToString());
            }
            catch (NumberFormatException ignored) {
                return Double.parseDouble(this.termBytes.utf8ToString());
            }
        }

        @Override
        public String getKeyAsString() {
            return this.format.format(this.termBytes).toString();
        }

        @Override
        public int compareKey(Bucket other) {
            return this.termBytes.compareTo(other.termBytes);
        }

        @Override
        protected final XContentBuilder keyToXContent(XContentBuilder builder) throws IOException {
            return builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.getKeyAsString());
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && Objects.equals(this.termBytes, ((Bucket)obj).termBytes);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.termBytes);
        }
    }
}

