/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.NonceGenerator;
import org.eclipse.jgit.transport.PushCertificate;

public class HMACSHA1NonceGenerator
implements NonceGenerator {
    private Mac mac;
    private static final String HEX = "0123456789ABCDEF";

    public HMACSHA1NonceGenerator(String seed) throws IllegalStateException {
        try {
            byte[] keyBytes = seed.getBytes(StandardCharsets.ISO_8859_1);
            SecretKeySpec signingKey = new SecretKeySpec(keyBytes, "HmacSHA1");
            this.mac = Mac.getInstance("HmacSHA1");
            this.mac.init(signingKey);
        }
        catch (InvalidKeyException e2) {
            throw new IllegalStateException(e2);
        }
        catch (NoSuchAlgorithmException e3) {
            throw new IllegalStateException(e3);
        }
    }

    @Override
    public synchronized String createNonce(Repository repo, long timestamp) throws IllegalStateException {
        String path2;
        if (repo instanceof DfsRepository) {
            path2 = ((DfsRepository)repo).getDescription().getRepositoryName();
        } else {
            File directory = repo.getDirectory();
            if (directory != null) {
                path2 = directory.getPath();
            } else {
                throw new IllegalStateException();
            }
        }
        String input = path2 + ":" + String.valueOf(timestamp);
        byte[] rawHmac = this.mac.doFinal(input.getBytes(StandardCharsets.UTF_8));
        return Long.toString(timestamp) + "-" + HMACSHA1NonceGenerator.toHex(rawHmac);
    }

    @Override
    public PushCertificate.NonceStatus verify(String received, String sent, Repository db, boolean allowSlop, int slop) {
        long advertisedStamp;
        long signedStamp;
        if (received.isEmpty()) {
            return PushCertificate.NonceStatus.MISSING;
        }
        if (sent.isEmpty()) {
            return PushCertificate.NonceStatus.UNSOLICITED;
        }
        if (received.equals(sent)) {
            return PushCertificate.NonceStatus.OK;
        }
        if (!allowSlop) {
            return PushCertificate.NonceStatus.BAD;
        }
        int idxSent = sent.indexOf(45);
        int idxRecv = received.indexOf(45);
        if (idxSent == -1 || idxRecv == -1) {
            return PushCertificate.NonceStatus.BAD;
        }
        String signedStampStr = received.substring(0, idxRecv);
        String advertisedStampStr = sent.substring(0, idxSent);
        try {
            signedStamp = Long.parseLong(signedStampStr);
            advertisedStamp = Long.parseLong(advertisedStampStr);
        }
        catch (IllegalArgumentException e2) {
            return PushCertificate.NonceStatus.BAD;
        }
        String expect = this.createNonce(db, signedStamp);
        if (!expect.equals(received)) {
            return PushCertificate.NonceStatus.BAD;
        }
        long nonceStampSlop = Math.abs(advertisedStamp - signedStamp);
        if (nonceStampSlop <= (long)slop) {
            return PushCertificate.NonceStatus.OK;
        }
        return PushCertificate.NonceStatus.SLOP;
    }

    private static String toHex(byte[] bytes2) {
        StringBuilder builder = new StringBuilder(2 * bytes2.length);
        for (byte b : bytes2) {
            builder.append(HEX.charAt((b & 0xF0) >> 4));
            builder.append(HEX.charAt(b & 0xF));
        }
        return builder.toString();
    }
}

