/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.profile.internal;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.auth.profile.internal.AbstractProfilesConfigFileScanner;
import com.amazonaws.auth.profile.internal.AllProfiles;
import com.amazonaws.auth.profile.internal.BasicProfile;
import com.amazonaws.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
public class BasicProfileConfigLoader {
    private static final Log LOG = LogFactory.getLog(BasicProfileConfigLoader.class);
    public static final BasicProfileConfigLoader INSTANCE = new BasicProfileConfigLoader();

    private BasicProfileConfigLoader() {
    }

    public AllProfiles loadProfiles(File file2) {
        if (file2 == null) {
            throw new IllegalArgumentException("Unable to load AWS profiles: specified file is null.");
        }
        if (!file2.exists() || !file2.isFile()) {
            throw new IllegalArgumentException("AWS credential profiles file not found in the given path: " + file2.getAbsolutePath());
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file2);
            AllProfiles allProfiles = this.loadProfiles(fis);
            return allProfiles;
        }
        catch (IOException ioe) {
            throw new SdkClientException("Unable to load AWS credential profiles file at: " + file2.getAbsolutePath(), ioe);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private AllProfiles loadProfiles(InputStream is2) throws IOException {
        ProfilesConfigFileLoaderHelper helper = new ProfilesConfigFileLoaderHelper();
        Map<String, Map<String, String>> allProfileProperties = helper.parseProfileProperties(new Scanner(is2, StringUtils.UTF8.name()));
        LinkedHashMap<String, BasicProfile> profilesByName = new LinkedHashMap<String, BasicProfile>();
        for (Map.Entry<String, Map<String, String>> entry : allProfileProperties.entrySet()) {
            String profileName = entry.getKey();
            Map<String, String> properties = entry.getValue();
            if (profileName.startsWith("profile ")) {
                LOG.warn("The legacy profile format requires the 'profile ' prefix before the profile name. The latest code does not require such prefix, and will consider it as part of the profile name. Please remove the prefix if you are seeing this warning.");
            }
            this.assertParameterNotEmpty(profileName, "Unable to load properties from profile: Profile name is empty.");
            profilesByName.put(profileName, new BasicProfile(profileName, properties));
        }
        return new AllProfiles(profilesByName);
    }

    private void assertParameterNotEmpty(String parameterValue, String errorMessage) {
        if (StringUtils.isNullOrEmpty(parameterValue)) {
            throw new SdkClientException(errorMessage);
        }
    }

    private static class ProfilesConfigFileLoaderHelper
    extends AbstractProfilesConfigFileScanner {
        protected final Map<String, Map<String, String>> allProfileProperties = new LinkedHashMap<String, Map<String, String>>();

        private ProfilesConfigFileLoaderHelper() {
        }

        public Map<String, Map<String, String>> parseProfileProperties(Scanner scanner) {
            this.allProfileProperties.clear();
            this.run(scanner);
            return new LinkedHashMap<String, Map<String, String>>(this.allProfileProperties);
        }

        @Override
        protected void onEmptyOrCommentLine(String profileName, String line) {
        }

        @Override
        protected void onProfileStartingLine(String newProfileName, String line) {
            this.allProfileProperties.put(newProfileName, new HashMap());
        }

        @Override
        protected void onProfileEndingLine(String prevProfileName) {
        }

        @Override
        protected void onProfileProperty(String profileName, String propertyKey, String propertyValue, boolean isSupportedProperty, String line) {
            Map<String, String> properties = this.allProfileProperties.get(profileName);
            if (properties.containsKey(propertyKey)) {
                throw new IllegalArgumentException("Duplicate property values for [" + propertyKey + "].");
            }
            properties.put(propertyKey, propertyValue);
        }

        @Override
        protected void onEndOfFile() {
        }
    }
}

