/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util.filefilter;

import com.cloudhopper.commons.util.FileUtil;
import java.io.File;
import java.io.FileFilter;

public class FileExtensionFilter
implements FileFilter {
    private boolean caseSensitive;
    private String[] extensions;

    public FileExtensionFilter(String extension) throws IllegalArgumentException {
        this(extension, false);
    }

    public FileExtensionFilter(String[] extensions) throws IllegalArgumentException {
        this(extensions, false);
    }

    public FileExtensionFilter(String extension, boolean caseSensitive) throws IllegalArgumentException {
        this(new String[]{extension}, caseSensitive);
    }

    public FileExtensionFilter(String[] extensions, boolean caseSensitive) throws IllegalArgumentException {
        for (String ext : extensions) {
            if (FileUtil.isValidFileExtension(ext)) continue;
            throw new IllegalArgumentException("Invalid file extension '" + ext + "' cannot be matched");
        }
        this.caseSensitive = caseSensitive;
        this.extensions = extensions;
    }

    @Override
    public boolean accept(File file) {
        String fileExt = FileUtil.parseFileExtension(file.getName());
        if (fileExt == null) {
            return false;
        }
        for (String extension : this.extensions) {
            if (!(this.caseSensitive ? fileExt.equals(extension) : fileExt.equalsIgnoreCase(extension))) continue;
            return true;
        }
        return false;
    }
}

