/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import io.netty.channel.ChannelHandler;
import org.traccar.BaseDataHandler;
import org.traccar.database.IdentityManager;
import org.traccar.model.Position;

@ChannelHandler.Sharable
public class EngineHoursHandler
extends BaseDataHandler {
    private final IdentityManager identityManager;

    public EngineHoursHandler(IdentityManager identityManager) {
        this.identityManager = identityManager;
    }

    @Override
    protected Position handlePosition(Position position) {
        Position last;
        if (!position.getAttributes().containsKey("hours") && (last = this.identityManager.getLastPosition(position.getDeviceId())) != null) {
            long hours = last.getLong("hours");
            if (last.getBoolean("ignition") && position.getBoolean("ignition")) {
                hours += position.getFixTime().getTime() - last.getFixTime().getTime();
            }
            if (hours != 0L) {
                position.set("hours", hours);
            }
        }
        return position;
    }
}

