/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.util;

import com.cloudhopper.smpp.SmppSession;
import com.cloudhopper.smpp.pdu.GenericNack;
import com.cloudhopper.smpp.pdu.PduRequest;
import com.cloudhopper.smpp.pdu.PduResponse;
import com.cloudhopper.smpp.type.GenericNackException;
import com.cloudhopper.smpp.type.UnexpectedPduResponseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmppSessionUtil {
    private static final Logger logger = LoggerFactory.getLogger(SmppSessionUtil.class);

    public static void close(SmppSession session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (Throwable t) {
                logger.warn("Unable to cleanly close session: {}", t);
            }
        }
    }

    public static void assertExpectedResponse(PduRequest request, PduResponse response) throws GenericNackException, UnexpectedPduResponseException {
        if (request.getResponseClass().isInstance(response)) {
            return;
        }
        if (response instanceof GenericNack) {
            throw new GenericNackException((GenericNack)response);
        }
        throw new UnexpectedPduResponseException(response);
    }
}

