/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.core.xml;

import java.io.IOException;
import java.io.InputStream;
import liquibase.logging.LogService;
import liquibase.logging.Logger;
import liquibase.parser.core.xml.XsdStreamResolver;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StreamUtil;

public class ResourceAccessorXsdStreamResolver
extends XsdStreamResolver {
    private static final Logger LOGGER = LogService.getLog(ResourceAccessorXsdStreamResolver.class);
    private ResourceAccessor resourceAccessor;

    public ResourceAccessorXsdStreamResolver(ResourceAccessor resourceAccessor) {
        this.resourceAccessor = resourceAccessor;
    }

    @Override
    public InputStream getResourceAsStream(String xsdFile) {
        try {
            InputStream resourceAsStream = StreamUtil.singleInputStream(xsdFile, this.resourceAccessor);
            if (resourceAsStream == null) {
                LOGGER.debug("Could not load " + xsdFile + " with the standard resource accessor.");
                return this.getSuccessorValue(xsdFile);
            }
            return resourceAsStream;
        }
        catch (IOException e2) {
            LOGGER.debug("Could not load " + xsdFile + " with the standard resource accessor.");
            return this.getSuccessorValue(xsdFile);
        }
    }
}

