/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger;

import com.datical.liquibase.ext.storedlogic.AbstractMissingStoredLogicChangeGenerator;
import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import com.datical.liquibase.ext.storedlogic.trigger.change.CreateTriggerChange;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.StoredDatabaseLogic;

public class MissingTriggerChangeGenerator
extends AbstractMissingStoredLogicChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (Trigger.class.isAssignableFrom(clazz)) {
            return 101;
        }
        return -1;
    }

    @Override
    public Change[] fixMissing(DatabaseObject databaseObject, DiffOutputControl diffOutputControl, Database database, Database database2, ChangeGeneratorChain object) {
        object = (Trigger)databaseObject;
        CreateTriggerChange createTriggerChange = new CreateTriggerChange();
        createTriggerChange.setTriggerBody(((StoredDatabaseLogic)object).getBody());
        createTriggerChange.setTriggerName(((StoredDatabaseLogic)object).getName());
        if (database2 instanceof MSSQLDatabase && ((Trigger)databaseObject).getCatalog() != null) {
            createTriggerChange.setScope("CATALOG");
        }
        createTriggerChange.setTableName(((Trigger)object).getTableName());
        createTriggerChange.setDisabled(((Trigger)object).isDisabled());
        if (diffOutputControl.getIncludeCatalog()) {
            if (((Trigger)databaseObject).getCatalog() == null) {
                createTriggerChange.setCatalogName(databaseObject.getSchema().getCatalogName());
            } else {
                createTriggerChange.setCatalogName(((Trigger)databaseObject).getCatalog().getName());
            }
        }
        if (diffOutputControl.getIncludeSchema() && databaseObject.getSchema() != null) {
            createTriggerChange.setSchemaName(((StoredDatabaseLogic)object).getSchema().getName());
        }
        if (database instanceof MSSQLDatabase && !createTriggerChange.getTriggerBody().toUpperCase().contains("AS EXTERNAL NAME")) {
            createTriggerChange.setReplaceIfExists(Boolean.TRUE);
        }
        return MissingTriggerChangeGenerator.wrapWithQuotedIdentifier(databaseObject, database, new Change[]{createTriggerChange});
    }
}

