/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.databasepackage;

import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackage;
import com.datical.liquibase.ext.storedlogic.databasepackage.MissingPackageChangeGenerator;
import com.datical.liquibase.ext.storedlogic.databasepackage.change.CreatePackageChange;
import com.datical.liquibase.ext.util.ObjectSqlFileUtil;
import liquibase.change.Change;
import liquibase.change.core.CreateProcedureChange;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.servicelocator.LiquibaseService;
import liquibase.structure.DatabaseObject;

@LiquibaseService
public class MissingPackageExternalFileChangeGenerator
extends MissingPackageChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (!LiquibaseConfiguration.getInstance().getConfiguration(LiquibaseProConfiguration.class).getInlineSql() && DatabasePackage.class.isAssignableFrom(clazz)) {
            return super.getPriority(clazz, database) + 100;
        }
        return -1;
    }

    @Override
    public Change[] fixMissing(DatabaseObject databaseObject, DiffOutputControl changeArray, Database object, Database database, ChangeGeneratorChain changeGeneratorChain) {
        changeArray = super.fixMissing(databaseObject, (DiffOutputControl)changeArray, (Database)object, database, changeGeneratorChain);
        object = (CreatePackageChange)changeArray[0];
        ((CreateProcedureChange)object).setRelativeToChangelogFile(Boolean.TRUE);
        ((CreateProcedureChange)object).setPath(ObjectSqlFileUtil.writeObjectSql((DatabasePackage)databaseObject));
        ((CreatePackageChange)object).setPackageText(null);
        return changeArray;
    }
}

