/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.synonym.change;

import com.datical.liquibase.ext.appdba.synonym.change.CreateSynonymStatement;
import com.datical.liquibase.ext.appdba.synonym.change.DropSynonymChange;
import com.datical.liquibase.ext.license.LicenseValidationChange;
import com.datical.liquibase.ext.util.RefactoringUtils;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createSynonym", description="Creates a synonym", priority=101, appliesTo={"synonym"})
public class CreateSynonymChange
extends LicenseValidationChange {
    private String objectCatalogName;
    private String objectSchemaName;
    private String objectName;
    private String objectType;
    private Boolean isPrivate;
    private Boolean replaceIfExists;
    private String synonymCatalogName;
    private String synonymSchemaName;
    private String synonymName;

    @Override
    public ValidationErrors validate(Database database) {
        if (database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof AbstractDb2Database || database instanceof PostgresDatabase) {
            return super.validate(database);
        }
        return RefactoringUtils.createValidationErrors(database, this);
    }

    public String getObjectCatalogName() {
        return this.objectCatalogName;
    }

    public void setObjectCatalogName(String string) {
        this.objectCatalogName = string;
    }

    public String getObjectSchemaName() {
        return this.objectSchemaName;
    }

    public void setObjectSchemaName(String string) {
        this.objectSchemaName = string;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String string) {
        this.objectName = string;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String string) {
        this.objectType = string;
    }

    public Boolean isPrivate() {
        return this.isPrivate;
    }

    public void setPrivate(Boolean bl2) {
        this.isPrivate = bl2;
    }

    public Boolean getReplaceIfExists() {
        return this.replaceIfExists;
    }

    public void setReplaceIfExists(Boolean bl2) {
        this.replaceIfExists = bl2;
    }

    public String getSynonymCatalogName() {
        return this.synonymCatalogName;
    }

    public void setSynonymCatalogName(String string) {
        this.synonymCatalogName = string;
    }

    public String getSynonymSchemaName() {
        return this.synonymSchemaName;
    }

    public void setSynonymSchemaName(String string) {
        this.synonymSchemaName = string;
    }

    public String getSynonymName() {
        return this.synonymName;
    }

    public void setSynonymName(String string) {
        this.synonymName = string;
    }

    @Override
    public String getConfirmationMessage() {
        return "Synonym " + this.getSynonymName() + " created";
    }

    @Override
    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new CreateSynonymStatement(this.getSynonymCatalogName(), this.getSynonymSchemaName(), this.getSynonymName(), this.getObjectCatalogName(), this.getObjectSchemaName(), this.getObjectName()).setPrivate(this.isPrivate()).setReplaceIfExists(this.getReplaceIfExists()).setObjectType(this.getObjectType())};
    }

    @Override
    protected Change[] createInverses() {
        DropSynonymChange dropSynonymChange = new DropSynonymChange();
        dropSynonymChange.setSynonymCatalogName(this.getSynonymCatalogName());
        dropSynonymChange.setSynonymSchemaName(this.getSynonymSchemaName());
        dropSynonymChange.setSynonymName(this.getSynonymName());
        dropSynonymChange.setPrivate(this.isPrivate());
        dropSynonymChange.setObjectType(this.getObjectType());
        return new Change[]{dropSynonymChange};
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }
}

