/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class SimpleRefGroup
implements RefGroup {
    @NotNull
    private final String myName;
    @NotNull
    private final List<VcsRef> myRefs;
    private final boolean myExpanded;

    public SimpleRefGroup(@NotNull String name, @NotNull List<VcsRef> refs) {
        if (name == null) {
            SimpleRefGroup.$$$reportNull$$$0(0);
        }
        if (refs == null) {
            SimpleRefGroup.$$$reportNull$$$0(1);
        }
        this(name, refs, false);
    }

    public SimpleRefGroup(@NotNull String name, @NotNull List<VcsRef> refs, boolean expanded) {
        if (name == null) {
            SimpleRefGroup.$$$reportNull$$$0(2);
        }
        if (refs == null) {
            SimpleRefGroup.$$$reportNull$$$0(3);
        }
        this.myName = name;
        this.myRefs = refs;
        this.myExpanded = expanded;
    }

    public boolean isExpanded() {
        return this.myExpanded;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            SimpleRefGroup.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public List<VcsRef> getRefs() {
        List<VcsRef> list = this.myRefs;
        if (list == null) {
            SimpleRefGroup.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<Color> getColors() {
        return SimpleRefGroup.getColors(this.myRefs);
    }

    @NotNull
    public static List<Color> getColors(@NotNull Collection<? extends VcsRef> refs) {
        MultiMap referencesByType;
        if (refs == null) {
            SimpleRefGroup.$$$reportNull$$$0(6);
        }
        if ((referencesByType = ContainerUtil.groupBy(refs, VcsRef::getType)).size() == 1) {
            Map.Entry firstItem = (Map.Entry)Objects.requireNonNull(ContainerUtil.getFirstItem((Collection)referencesByType.entrySet()));
            boolean multiple = ((Collection)firstItem.getValue()).size() > 1;
            Color color = ((VcsRefType)firstItem.getKey()).getBackgroundColor();
            List<Color> list = multiple ? Arrays.asList(color, color) : Collections.singletonList(color);
            if (list == null) {
                SimpleRefGroup.$$$reportNull$$$0(7);
            }
            return list;
        }
        ArrayList<Color> colorsList = new ArrayList<Color>();
        for (VcsRefType type : referencesByType.keySet()) {
            if (referencesByType.get((Object)type).size() > 1) {
                colorsList.add(type.getBackgroundColor());
            }
            colorsList.add(type.getBackgroundColor());
        }
        ArrayList<Color> arrayList = colorsList;
        if (arrayList == null) {
            SimpleRefGroup.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public static void buildGroups(@NotNull MultiMap<VcsRefType, VcsRef> groupedRefs, boolean compact, boolean showTagNames, @NotNull List<RefGroup> result2) {
        if (groupedRefs == null) {
            SimpleRefGroup.$$$reportNull$$$0(9);
        }
        if (result2 == null) {
            SimpleRefGroup.$$$reportNull$$$0(10);
        }
        if (groupedRefs.isEmpty()) {
            return;
        }
        if (compact) {
            VcsRef firstRef = (VcsRef)Objects.requireNonNull(ContainerUtil.getFirstItem((Collection)groupedRefs.values()));
            RefGroup group = (RefGroup)ContainerUtil.getFirstItem(result2);
            if (group == null) {
                result2.add(new SimpleRefGroup(firstRef.getType().isBranch() || showTagNames ? firstRef.getName() : "", new ArrayList<VcsRef>(groupedRefs.values())));
            } else {
                group.getRefs().addAll(groupedRefs.values());
            }
        } else {
            for (Map.Entry entry : groupedRefs.entrySet()) {
                if (((VcsRefType)entry.getKey()).isBranch()) {
                    for (VcsRef ref : (Collection)entry.getValue()) {
                        result2.add(new SimpleRefGroup(ref.getName(), ContainerUtil.newArrayList((Object[])new VcsRef[]{ref})));
                    }
                    continue;
                }
                result2.add(new SimpleRefGroup(showTagNames ? ((VcsRef)Objects.requireNonNull(ContainerUtil.getFirstItem((Collection)((Collection)entry.getValue())))).getName() : "", new ArrayList<VcsRef>((Collection)entry.getValue())));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/SimpleRefGroup";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupedRefs";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/SimpleRefGroup";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefs";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getColors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getColors";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildGroups";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

