/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.diff.DiffManager;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.MessageDiffRequest;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffAction;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffContext;
import com.intellij.openapi.vcs.changes.ui.SimpleChangesBrowser;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsDiffUtil {
    public static void showDiffFor(@NotNull Project project, @NotNull Collection<? extends Change> changes, @NotNull String revNumTitle1, @NotNull String revNumTitle2, @NotNull FilePath filePath) {
        if (project == null) {
            VcsDiffUtil.$$$reportNull$$$0(0);
        }
        if (changes == null) {
            VcsDiffUtil.$$$reportNull$$$0(1);
        }
        if (revNumTitle1 == null) {
            VcsDiffUtil.$$$reportNull$$$0(2);
        }
        if (revNumTitle2 == null) {
            VcsDiffUtil.$$$reportNull$$$0(3);
        }
        if (filePath == null) {
            VcsDiffUtil.$$$reportNull$$$0(4);
        }
        if (filePath.isDirectory()) {
            VcsDiffUtil.showChangesDialog(project, VcsDiffUtil.getDialogTitle(filePath, revNumTitle1, revNumTitle2), new ArrayList<Change>(changes));
        } else if (changes.isEmpty()) {
            DiffManager.getInstance().showDiff(project, (DiffRequest)new MessageDiffRequest("No Changes Found"));
        } else {
            final HashMap<Key, String> revTitlesMap = new HashMap<Key, String>(2);
            revTitlesMap.put(DiffUserDataKeysEx.VCS_DIFF_LEFT_CONTENT_TITLE, revNumTitle1);
            revTitlesMap.put(DiffUserDataKeysEx.VCS_DIFF_RIGHT_CONTENT_TITLE, revNumTitle2);
            ShowDiffContext showDiffContext = new ShowDiffContext(){

                @Override
                @NotNull
                public Map<Key, Object> getChangeContext(@NotNull Change change) {
                    if (change == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    HashMap hashMap = revTitlesMap;
                    if (hashMap == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return hashMap;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "change";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/vcs/history/VcsDiffUtil$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/vcs/history/VcsDiffUtil$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getChangeContext";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getChangeContext";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            ShowDiffAction.showDiffForChange(project, changes, 0, showDiffContext);
        }
    }

    @NotNull
    private static String getDialogTitle(@NotNull FilePath filePath, @NotNull String revNumTitle1, @NotNull String revNumTitle2) {
        if (filePath == null) {
            VcsDiffUtil.$$$reportNull$$$0(5);
        }
        if (revNumTitle1 == null) {
            VcsDiffUtil.$$$reportNull$$$0(6);
        }
        if (revNumTitle2 == null) {
            VcsDiffUtil.$$$reportNull$$$0(7);
        }
        String string = String.format("Difference between %s and %s versions in %s", revNumTitle1, revNumTitle2, filePath.getName());
        if (string == null) {
            VcsDiffUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String getRevisionTitle(@NotNull String revision, boolean localMark) {
        if (revision == null) {
            VcsDiffUtil.$$$reportNull$$$0(9);
        }
        String string = revision + (localMark ? " (" + VcsBundle.message((String)"diff.title.local", (Object[])new Object[0]) + ")" : "");
        if (string == null) {
            VcsDiffUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    public static void showChangesDialog(@NotNull Project project, @NotNull String title2, @NotNull List<? extends Change> changes) {
        if (project == null) {
            VcsDiffUtil.$$$reportNull$$$0(11);
        }
        if (title2 == null) {
            VcsDiffUtil.$$$reportNull$$$0(12);
        }
        if (changes == null) {
            VcsDiffUtil.$$$reportNull$$$0(13);
        }
        DialogBuilder dialogBuilder = new DialogBuilder(project);
        dialogBuilder.setTitle(title2);
        dialogBuilder.setActionDescriptors(new DialogBuilder.ActionDescriptor[]{new DialogBuilder.CloseDialogAction()});
        SimpleChangesBrowser changesBrowser2 = new SimpleChangesBrowser(project, false, true);
        changesBrowser2.setChangesToDisplay(changes);
        dialogBuilder.setCenterPanel((JComponent)changesBrowser2);
        dialogBuilder.setPreferredFocusComponent(changesBrowser2.getPreferredFocusedComponent());
        dialogBuilder.setDimensionServiceKey("VcsDiffUtil.ChangesDialog");
        dialogBuilder.showNotModal();
    }

    @NotNull
    public static List<Change> createChangesWithCurrentContentForFile(@NotNull FilePath filePath, @Nullable ContentRevision beforeContentRevision) {
        if (filePath == null) {
            VcsDiffUtil.$$$reportNull$$$0(14);
        }
        List<Change> list = Collections.singletonList(new Change(beforeContentRevision, CurrentContentRevision.create((FilePath)filePath)));
        if (list == null) {
            VcsDiffUtil.$$$reportNull$$$0(15);
        }
        return list;
    }

    public static void showChangesWithWorkingDirLater(final @NotNull Project project, final @NotNull VirtualFile file, final @NotNull VcsRevisionNumber targetRevNumber, final @NotNull DiffProvider provider) {
        if (project == null) {
            VcsDiffUtil.$$$reportNull$$$0(16);
        }
        if (file == null) {
            VcsDiffUtil.$$$reportNull$$$0(17);
        }
        if (targetRevNumber == null) {
            VcsDiffUtil.$$$reportNull$$$0(18);
        }
        if (provider == null) {
            VcsDiffUtil.$$$reportNull$$$0(19);
        }
        final BackgroundableActionLock lock = BackgroundableActionLock.getLock(project, new Object[]{VcsBackgroundableActions.COMPARE_WITH, file});
        Task.Backgroundable task2 = new Task.Backgroundable(project, VcsBundle.message((String)"file.history.diff.with.local.process", (Object[])new Object[0]), true){
            private Collection<Change> changes;
            private VcsRevisionNumber currentRevNumber;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                try {
                    this.changes = provider.compareWithWorkingDir(file, targetRevNumber);
                    this.currentRevNumber = provider.getCurrentRevision(file);
                }
                catch (VcsException e) {
                    String title2 = String.format("Compare with %s failed", VcsUtil.getShortRevisionString((VcsRevisionNumber)targetRevNumber));
                    String message = String.format("Couldn't compare %s with revision [%s];\n %s", file, VcsUtil.getShortRevisionString((VcsRevisionNumber)targetRevNumber), e.getMessage());
                    VcsNotifier.getInstance(project).notifyError(title2, message);
                }
            }

            public void onSuccess() {
                if (this.changes != null) {
                    String currentRevTitle = this.currentRevNumber != null ? VcsDiffUtil.getRevisionTitle(VcsUtil.getShortRevisionString((VcsRevisionNumber)this.currentRevNumber), true) : VcsBundle.message((String)"diff.title.local", (Object[])new Object[0]);
                    VcsDiffUtil.showDiffFor(project, this.changes, VcsDiffUtil.getRevisionTitle(VcsUtil.getShortRevisionString((VcsRevisionNumber)targetRevNumber), false), currentRevTitle, VcsUtil.getFilePath((VirtualFile)file));
                }
            }

            public void onFinished() {
                lock.unlock();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/history/VcsDiffUtil$2", "run"));
            }
        };
        lock.lock();
        ProgressManager.getInstance().run((Task)task2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revNumTitle1";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revNumTitle2";
                break;
            }
            case 4: 
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 8: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/history/VcsDiffUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRevNumber";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/history/VcsDiffUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialogTitle";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionTitle";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createChangesWithCurrentContentForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showDiffFor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDialogTitle";
                break;
            }
            case 8: 
            case 10: 
            case 15: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRevisionTitle";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showChangesDialog";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createChangesWithCurrentContentForFile";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "showChangesWithWorkingDirLater";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

