/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.IgnoredViewDialog;
import com.intellij.openapi.vcs.changes.VcsIgnoreManagerImpl;
import com.intellij.openapi.vcs.changes.ignore.actions.IgnoreFileActionGroup;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreFileType;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserSpecificFilePathsNode;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J(\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bH\u0016J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserIgnoredFilesNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserSpecificFilePathsNode;", "project", "Lcom/intellij/openapi/project/Project;", "files", "", "Lcom/intellij/openapi/vcs/FilePath;", "myUpdatingMode", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Z)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "acceptDrop", "", "dragOwner", "Lcom/intellij/openapi/vcs/changes/ChangeListOwner;", "dragBean", "Lcom/intellij/openapi/vcs/changes/ui/ChangeListDragBean;", "canAcceptDrop", "getSortWeight", "", "render", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "selected", "expanded", "hasFocus", "getVcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "intellij.platform.vcs.impl"})
public final class ChangesBrowserIgnoredFilesNode
extends ChangesBrowserSpecificFilePathsNode {
    @NotNull
    private final Project project;
    private final boolean myUpdatingMode;

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)renderer), (String)"renderer");
        super.render(renderer, selected, expanded, hasFocus);
        if (this.myUpdatingMode) {
            this.appendUpdatingState(renderer);
        }
    }

    @Override
    public boolean canAcceptDrop(@NotNull ChangeListDragBean dragBean) {
        Intrinsics.checkParameterIsNotNull((Object)dragBean, (String)"dragBean");
        List<FilePath> list = dragBean.getUnversionedFiles();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"dragBean.unversionedFiles");
        Collection collection = list;
        boolean bl = false;
        return !collection.isEmpty();
    }

    @Override
    public void acceptDrop(@NotNull ChangeListOwner dragOwner, @NotNull ChangeListDragBean dragBean) {
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)dragOwner, (String)"dragOwner");
            Intrinsics.checkParameterIsNotNull((Object)dragBean, (String)"dragBean");
            JComponent jComponent = dragBean.getSourceComponent();
            if (!(jComponent instanceof Tree)) {
                jComponent = null;
            }
            Tree tree = (Tree)jComponent;
            if (tree == null) {
                return;
            }
            Tree tree2 = tree;
            List<FilePath> list = dragBean.getUnversionedFiles();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"dragBean.unversionedFiles");
            AbstractVcs abstractVcs = this.getVcs(list);
            if (abstractVcs == null) {
                return;
            }
            AbstractVcs vcs = abstractVcs;
            IgnoreFileType ignoreFileType = VcsIgnoreManagerImpl.Companion.getInstanceImpl(this.project).findIgnoreFileType(vcs);
            if (ignoreFileType == null) {
                return;
            }
            IgnoreFileType ignoreFileType2 = ignoreFileType;
            IgnoreFileActionGroup ignoreGroup = new IgnoreFileActionGroup(ignoreFileType2);
            ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)ignoreGroup, DataManager.getInstance().getDataContext((Component)dragBean.getSourceComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
            Intrinsics.checkExpressionValueIsNotNull((Object)listPopup, (String)"JBPopupFactory.getInstan\u2026onAid.SPEEDSEARCH, false)");
            ListPopup popup = listPopup;
            ChangesBrowserNode changesBrowserNode = dragBean.getTargetNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)changesBrowserNode, (String)"dragBean.targetNode");
            Rectangle rectangle = tree2.getPathBounds(new TreePath(changesBrowserNode.getPath()));
            if (rectangle == null) break block4;
            Rectangle rectangle2 = rectangle;
            boolean bl = false;
            boolean bl2 = false;
            Rectangle dropBounds = rectangle2;
            boolean bl3 = false;
            popup.show(new RelativePoint((Component)dragBean.getSourceComponent(), dropBounds.getLocation()));
        }
    }

    @Override
    public int getSortWeight() {
        return 11;
    }

    /*
     * WARNING - void declaration
     */
    private final AbstractVcs getVcs(@NotNull List<? extends FilePath> $this$getVcs) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = $this$getVcs;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            AbstractVcs abstractVcs;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            FilePath file = (FilePath)element$iv$iv;
            boolean bl2 = false;
            if (VcsUtil.getVcsFor((Project)this.project, (FilePath)file) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            AbstractVcs it$iv$iv = abstractVcs;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (AbstractVcs)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public ChangesBrowserIgnoredFilesNode(final @NotNull Project project, @NotNull List<? extends FilePath> files, boolean myUpdatingMode) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        super(ChangesBrowserNode.IGNORED_FILES_TAG, files, new Runnable(){

            @Override
            public final void run() {
                if (!project.isDisposed()) {
                    new IgnoredViewDialog(project).show();
                }
            }
        });
        this.project = project;
        this.myUpdatingMode = myUpdatingMode;
    }
}

