/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserModuleNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesBrowserFilePathNode
extends ChangesBrowserNode<FilePath> {
    @Nullable
    private FileStatus status;

    public ChangesBrowserFilePathNode(@NotNull FilePath userObject, @Nullable FileStatus status) {
        if (userObject == null) {
            ChangesBrowserFilePathNode.$$$reportNull$$$0(0);
        }
        this(userObject);
        this.status = status;
    }

    public ChangesBrowserFilePathNode(FilePath userObject) {
        super(userObject);
    }

    @Override
    protected boolean isFile() {
        return !((FilePath)this.getUserObject()).isDirectory();
    }

    @Override
    protected boolean isDirectory() {
        return ((FilePath)this.getUserObject()).isDirectory() && this.isLeaf();
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        if (renderer == null) {
            ChangesBrowserFilePathNode.$$$reportNull$$$0(1);
        }
        FilePath path2 = (FilePath)this.userObject;
        if (renderer.isShowFlatten() && this.isLeaf()) {
            renderer.append(path2.getName(), this.getTextAttributes());
            this.appendParentPath(renderer, path2.getParentPath());
        } else {
            renderer.append(this.getRelativePath(path2), this.getTextAttributes());
        }
        if (!this.isLeaf()) {
            this.appendCount(renderer);
        }
        renderer.setIcon(path2, path2.isDirectory() || !this.isLeaf());
    }

    @NotNull
    private SimpleTextAttributes getTextAttributes() {
        SimpleTextAttributes simpleTextAttributes = this.status != null ? new SimpleTextAttributes(0, this.status.getColor()) : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        if (simpleTextAttributes == null) {
            ChangesBrowserFilePathNode.$$$reportNull$$$0(2);
        }
        return simpleTextAttributes;
    }

    @NotNull
    protected String getRelativePath(FilePath path2) {
        return ChangesBrowserFilePathNode.getRelativePath(ChangesBrowserFilePathNode.safeCastToFilePath((ChangesBrowserNode)this.getParent()), path2);
    }

    @Override
    public String getTextPresentation() {
        return this.getRelativePath((FilePath)this.getUserObject());
    }

    @Override
    public String toString() {
        return FileUtil.toSystemDependentName((String)((FilePath)this.getUserObject()).getPath());
    }

    @Nullable
    public static FilePath safeCastToFilePath(ChangesBrowserNode node) {
        if (node instanceof ChangesBrowserModuleNode) {
            return ((ChangesBrowserModuleNode)node).getModuleRoot();
        }
        Object o = node.getUserObject();
        if (o instanceof FilePath) {
            return (FilePath)o;
        }
        if (o instanceof Change) {
            return ChangesUtil.getAfterPath((Change)((Change)o));
        }
        return null;
    }

    @NotNull
    public static String getRelativePath(@Nullable FilePath parent, @NotNull FilePath child) {
        if (child == null) {
            ChangesBrowserFilePathNode.$$$reportNull$$$0(3);
        }
        boolean isLocal = !child.isNonLocal();
        boolean caseSensitive = isLocal && SystemInfo.isFileSystemCaseSensitive;
        String result2 = parent != null ? FileUtil.getRelativePath((String)parent.getPath(), (String)child.getPath(), (char)'/', (boolean)caseSensitive) : null;
        result2 = result2 == null ? child.getPath() : result2;
        String string = isLocal ? FileUtil.toSystemDependentName((String)result2) : result2;
        if (string == null) {
            ChangesBrowserFilePathNode.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public int getSortWeight() {
        if (((FilePath)this.userObject).isDirectory()) {
            return 5;
        }
        return 6;
    }

    @Override
    public int compareUserObjects(FilePath o2) {
        return ChangesBrowserFilePathNode.compareFilePaths((FilePath)this.getUserObject(), o2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userObject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserFilePathNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserFilePathNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextAttributes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

