/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.google.common.collect.Lists;
import com.intellij.concurrency.JobScheduler;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.UnifiedDiffWriter;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.NonLazySchemeProcessor;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeListUtil;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.patch.PatchFileType;
import com.intellij.openapi.vcs.changes.shelf.ShelfFileProcessorUtil;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFilePatch;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.RollbackChangesDialog;
import com.intellij.openapi.vcs.changes.ui.RollbackWorker;
import com.intellij.openapi.vcs.changes.ui.ShelvedChangeListDragBean;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.project.ProjectKt;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcsUtil.FilesProgress;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ShelveChangesManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class ShelveChangesManager
implements PersistentStateComponent<Element>,
ProjectComponent {
    private static final Logger LOG = Logger.getInstance(ShelveChangesManager.class);
    @NonNls
    private static final String ELEMENT_CHANGELIST = "changelist";
    @NonNls
    private static final String ELEMENT_RECYCLED_CHANGELIST = "recycled_changelist";
    @NonNls
    private static final String DEFAULT_PATCH_NAME = "shelved";
    private static final String SHELVE_MANAGER_DIR_PATH = "shelf";
    public static final String DEFAULT_PROJECT_PRESENTATION_PATH = "<Project>/shelf";
    private static final Element EMPTY_ELEMENT = new Element("state");
    private State myState = new State();
    @NotNull
    private final PathMacroManager myPathMacroSubstitutor;
    @NotNull
    private SchemeManager<ShelvedChangeList> mySchemeManager;
    private ScheduledFuture<?> myCleaningFuture;
    private final ReentrantReadWriteLock SHELVED_FILES_LOCK = new ReentrantReadWriteLock(true);
    @Nullable
    private Set<VirtualFile> myShelvingFiles;
    private final Project myProject;
    private final MessageBus myBus;
    public static final Topic<ChangeListener> SHELF_TOPIC = new Topic("shelf updates", ChangeListener.class);

    public static ShelveChangesManager getInstance(@NotNull Project project) {
        if (project == null) {
            ShelveChangesManager.$$$reportNull$$$0(0);
        }
        return (ShelveChangesManager)project.getComponent(ShelveChangesManager.class);
    }

    @NotNull
    public Element getState() {
        Element element = (Element)ObjectUtils.chooseNotNull((Object)XmlSerializer.serialize((Object)this.myState), (Object)EMPTY_ELEMENT);
        if (element == null) {
            ShelveChangesManager.$$$reportNull$$$0(1);
        }
        return element;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            ShelveChangesManager.$$$reportNull$$$0(2);
        }
        this.myState = (State)XmlSerializer.deserialize((Element)state, State.class);
        this.migrateOldShelfInfo(state, false);
        this.migrateOldShelfInfo(state, true);
    }

    @NotNull
    public static String getDefaultShelfPath(@NotNull Project project) {
        if (project == null) {
            ShelveChangesManager.$$$reportNull$$$0(3);
        }
        IProjectStore store = ProjectKt.getStateStore((Project)project);
        String string = store.getDirectoryStorePath(true) + "/" + (ProjectKt.isDirectoryBased((Project)project) ? SHELVE_MANAGER_DIR_PATH : ".shelf");
        if (string == null) {
            ShelveChangesManager.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String getShelfPath(@NotNull Project project) {
        if (project == null) {
            ShelveChangesManager.$$$reportNull$$$0(5);
        }
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)project);
        if (vcsConfiguration.USE_CUSTOM_SHELF_PATH) {
            String string = Objects.requireNonNull(vcsConfiguration.CUSTOM_SHELF_PATH);
            if (string == null) {
                ShelveChangesManager.$$$reportNull$$$0(6);
            }
            return string;
        }
        return ShelveChangesManager.getDefaultShelfPath(project);
    }

    public ShelveChangesManager(Project project, MessageBus bus) {
        this.myPathMacroSubstitutor = PathMacroManager.getInstance((ComponentManager)project);
        this.myProject = project;
        this.myBus = bus;
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)project);
        this.mySchemeManager = this.createShelveSchemeManager(project, vcsConfiguration.USE_CUSTOM_SHELF_PATH ? vcsConfiguration.CUSTOM_SHELF_PATH : null);
        this.myCleaningFuture = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> this.cleanDeletedOlderOneWeek(), 1L, 1L, TimeUnit.DAYS);
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                ShelveChangesManager.this.stopCleanScheduler();
            }
        });
    }

    private void stopCleanScheduler() {
        if (this.myCleaningFuture != null) {
            this.myCleaningFuture.cancel(false);
            this.myCleaningFuture = null;
        }
    }

    @NotNull
    private SchemeManager<ShelvedChangeList> createShelveSchemeManager(@NotNull Project project, @Nullable String customPath) {
        if (project == null) {
            ShelveChangesManager.$$$reportNull$$$0(7);
        }
        FilePath customShelfFilePath = customPath != null ? VcsUtil.getFilePath((String)this.myPathMacroSubstitutor.expandPath(customPath)) : null;
        final boolean shouldCollapsePath = !VcsConfiguration.getInstance((Project)this.myProject).USE_CUSTOM_SHELF_PATH;
        SchemeManager schemeManager = SchemeManagerFactory.getInstance((Project)project).create(customShelfFilePath != null ? customShelfFilePath.getName() : SHELVE_MANAGER_DIR_PATH, (SchemeProcessor)new NonLazySchemeProcessor<ShelvedChangeList, ShelvedChangeList>(){

            @NotNull
            public ShelvedChangeList readScheme(@NotNull Element element, boolean duringLoad) throws InvalidDataException {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                ShelvedChangeList shelvedChangeList = ShelveChangesManager.this.readOneShelvedChangeList(element);
                if (shelvedChangeList == null) {
                    2.$$$reportNull$$$0(1);
                }
                return shelvedChangeList;
            }

            @NotNull
            public Parent writeScheme(@NotNull ShelvedChangeList scheme) throws WriteExternalException {
                if (scheme == null) {
                    2.$$$reportNull$$$0(2);
                }
                Element child = new Element(ShelveChangesManager.ELEMENT_CHANGELIST);
                scheme.writeExternal(child);
                if (shouldCollapsePath) {
                    ShelveChangesManager.this.myPathMacroSubstitutor.collapsePaths(child);
                }
                Element element = child;
                if (element == null) {
                    2.$$$reportNull$$$0(3);
                }
                return element;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager$2";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scheme";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "readScheme";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "writeScheme";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "readScheme";
                        break;
                    }
                    case 1: 
                    case 3: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "writeScheme";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, null, customPath != null ? Paths.get(customPath, new String[0]) : null);
        if (schemeManager == null) {
            ShelveChangesManager.$$$reportNull$$$0(8);
        }
        return schemeManager;
    }

    public void projectOpened() {
        try {
            this.mySchemeManager.loadSchemes();
            this.filterNonValidShelvedChangeLists();
            this.markDeletedSystemUnshelved();
            this.cleanDeletedOlderOneWeek();
        }
        catch (Exception e) {
            LOG.error("Couldn't read shelf information", (Throwable)e);
        }
    }

    private void filterNonValidShelvedChangeLists() {
        ArrayList allSchemes = new ArrayList(this.mySchemeManager.getAllSchemes());
        ContainerUtil.process(allSchemes, shelvedChangeList -> {
            if (!shelvedChangeList.isValid()) {
                this.mySchemeManager.removeScheme(shelvedChangeList);
            }
            return true;
        });
    }

    public void checkAndMigrateUnderProgress(final @NotNull File fromFile, final @NotNull File toFile, final boolean wasCustom) {
        if (fromFile == null) {
            ShelveChangesManager.$$$reportNull$$$0(9);
        }
        if (toFile == null) {
            ShelveChangesManager.$$$reportNull$$$0(10);
        }
        final SchemeManager<ShelvedChangeList> newSchemeManager = this.createShelveSchemeManager(this.myProject, VcsUtil.getFilePath((File)toFile).getPath());
        newSchemeManager.loadSchemes();
        if (VcsConfiguration.getInstance((Project)this.myProject).MOVE_SHELVES && fromFile.exists()) {
            new Task.Modal(this.myProject, VcsBundle.message((String)"shelve.copying.shelves.to.progress", (Object[])new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    for (ShelvedChangeList list : ShelveChangesManager.this.mySchemeManager.getAllSchemes()) {
                        if (!list.isValid()) continue;
                        try {
                            File newTargetDirectory = ShelveChangesManager.suggestPatchName(this.myProject, list.DESCRIPTION, toFile, "");
                            ShelvedChangeList migratedList = ShelveChangesManager.this.createChangelistCopyWithChanges(list, newTargetDirectory);
                            newSchemeManager.addScheme((Object)migratedList, false);
                            indicator.checkCanceled();
                        }
                        catch (IOException e) {
                            LOG.error("Can't copy patch file: " + list.PATH);
                        }
                    }
                    ShelveChangesManager.this.clearShelvedLists(ShelveChangesManager.this.mySchemeManager.getAllSchemes(), false);
                }

                public void onSuccess() {
                    super.onSuccess();
                    ShelveChangesManager.this.updateShelveSchemaManager((SchemeManager<ShelvedChangeList>)newSchemeManager);
                }

                public void onCancel() {
                    super.onCancel();
                    this.suggestToCancelMigrationOrRevertPathToPrevious();
                }

                private void suggestToCancelMigrationOrRevertPathToPrevious() {
                    if (Messages.showOkCancelDialog((Project)this.myProject, (String)VcsBundle.message((String)"shelve.moving.failed.prompt", (Object[])new Object[0]), (String)VcsBundle.message((String)"shelve.error.title", (Object[])new Object[0]), (String)VcsBundle.message((String)"shelve.use.new.directory.button", (Object[])new Object[0]), (String)VcsBundle.message((String)"shelve.revert.moving.button", (Object[])new Object[0]), (Icon)UIUtil.getWarningIcon()) == 0) {
                        ShelveChangesManager.this.updateShelveSchemaManager((SchemeManager<ShelvedChangeList>)newSchemeManager);
                    } else {
                        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
                        vcsConfiguration.USE_CUSTOM_SHELF_PATH = wasCustom;
                        if (wasCustom) {
                            vcsConfiguration.CUSTOM_SHELF_PATH = FileUtil.toSystemIndependentName((String)fromFile.getPath());
                        }
                    }
                }

                public void onThrowable(@NotNull Throwable error) {
                    if (error == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    super.onThrowable(error);
                    this.suggestToCancelMigrationOrRevertPathToPrevious();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "error";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "run";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onThrowable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }.queue();
        } else {
            this.updateShelveSchemaManager(newSchemeManager);
        }
    }

    private void updateShelveSchemaManager(SchemeManager<ShelvedChangeList> newSchemeManager) {
        this.myProject.save();
        ApplicationManager.getApplication().saveSettings();
        SchemeManagerFactory.getInstance((Project)this.myProject).dispose(this.mySchemeManager);
        this.mySchemeManager = newSchemeManager;
        this.notifyStateChanged();
    }

    @NotNull
    public File getShelfResourcesDirectory() {
        File file = this.mySchemeManager.getRootDirectory();
        if (file == null) {
            ShelveChangesManager.$$$reportNull$$$0(11);
        }
        return file;
    }

    @NotNull
    private ShelvedChangeList readOneShelvedChangeList(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            ShelveChangesManager.$$$reportNull$$$0(12);
        }
        ShelvedChangeList data = new ShelvedChangeList();
        this.myPathMacroSubstitutor.expandPaths(element);
        data.readExternal(element);
        ShelvedChangeList shelvedChangeList = data;
        if (shelvedChangeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(13);
        }
        return shelvedChangeList;
    }

    private void migrateOldShelfInfo(@NotNull Element element, boolean recycled) throws InvalidDataException {
        Element changeSetElement;
        ShelvedChangeList list;
        if (element == null) {
            ShelveChangesManager.$$$reportNull$$$0(14);
        }
        Iterator iterator = element.getChildren(recycled ? ELEMENT_RECYCLED_CHANGELIST : ELEMENT_CHANGELIST).iterator();
        while (iterator.hasNext() && (list = this.readOneShelvedChangeList(changeSetElement = (Element)iterator.next())).isValid()) {
            File uniqueDir = this.generateUniqueSchemePatchDir(list.DESCRIPTION, false);
            list.setName(uniqueDir.getName());
            list.setRecycled(recycled);
            this.mySchemeManager.addScheme((Object)list, false);
        }
    }

    @NotNull
    private static List<ShelvedBinaryFile> copyBinaryFiles(@NotNull ShelvedChangeList list, @NotNull File targetDirectory) {
        if (list == null) {
            ShelveChangesManager.$$$reportNull$$$0(15);
        }
        if (targetDirectory == null) {
            ShelveChangesManager.$$$reportNull$$$0(16);
        }
        ArrayList<ShelvedBinaryFile> copied = new ArrayList<ShelvedBinaryFile>();
        for (ShelvedBinaryFile file : list.getBinaryFiles()) {
            if (file.SHELVED_PATH == null) continue;
            File shelvedFile = new File(file.SHELVED_PATH);
            if (StringUtil.isEmptyOrSpaces((String)file.AFTER_PATH) || !shelvedFile.exists()) continue;
            File newShelvedFile = new File(targetDirectory, PathUtil.getFileName((String)file.AFTER_PATH));
            try {
                FileUtil.copy((File)shelvedFile, (File)newShelvedFile);
                copied.add(new ShelvedBinaryFile(file.BEFORE_PATH, file.AFTER_PATH, FileUtil.toSystemIndependentName((String)newShelvedFile.getPath())));
            }
            catch (IOException e) {
                LOG.error("Can't copy binary file: " + list.PATH);
            }
        }
        ArrayList<ShelvedBinaryFile> arrayList = copied;
        if (arrayList == null) {
            ShelveChangesManager.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NotNull
    public List<ShelvedChangeList> getShelvedChangeLists() {
        return this.getRecycled(false);
    }

    @NotNull
    private List<ShelvedChangeList> getRecycled(boolean recycled) {
        List list2 = ContainerUtil.newUnmodifiableList((List)ContainerUtil.filter((Collection)this.mySchemeManager.getAllSchemes(), list -> recycled == list.isRecycled() && !list.isDeleted()));
        if (list2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(18);
        }
        return list2;
    }

    @NotNull
    public List<ShelvedChangeList> getAllLists() {
        List list = ContainerUtil.newUnmodifiableList((List)this.mySchemeManager.getAllSchemes());
        if (list == null) {
            ShelveChangesManager.$$$reportNull$$$0(19);
        }
        return list;
    }

    public ShelvedChangeList shelveChanges(Collection<? extends Change> changes, String commitMessage2, boolean rollback) throws IOException, VcsException {
        return this.shelveChanges(changes, commitMessage2, rollback, false);
    }

    public ShelvedChangeList shelveChanges(Collection<? extends Change> changes, String commitMessage2, boolean rollback, boolean markToBeDeleted) throws IOException, VcsException {
        return this.shelveChanges(changes, commitMessage2, rollback, markToBeDeleted, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShelvedChangeList shelveChanges(Collection<? extends Change> changes, String commitMessage2, boolean rollback, boolean markToBeDeleted, boolean honorExcludedFromCommit) throws IOException, VcsException {
        ShelvedChangeList shelveList;
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.setText(VcsBundle.message((String)"shelve.changes.progress.text", (Object[])new Object[0]));
        }
        try {
            this.SHELVED_FILES_LOCK.writeLock().lock();
            this.rememberShelvingFiles(changes);
            shelveList = this.createShelfFromChanges(changes, commitMessage2, markToBeDeleted, honorExcludedFromCommit);
        }
        finally {
            this.cleanShelvingFiles();
            this.SHELVED_FILES_LOCK.writeLock().unlock();
            this.notifyStateChanged();
        }
        if (rollback) {
            this.rollbackChangesAfterShelve(changes, honorExcludedFromCommit);
        }
        return shelveList;
    }

    @NotNull
    private ShelvedChangeList createShelfFromChanges(@NotNull Collection<? extends Change> changes, String commitMessage2, boolean markToBeDeleted, boolean honorExcludedFromCommit) throws IOException, VcsException {
        if (changes == null) {
            ShelveChangesManager.$$$reportNull$$$0(20);
        }
        LOG.debug("Shelving of " + changes.size() + " changes...");
        StopWatch totalSW = StopWatch.start("Total shelving");
        File schemePatchDir = this.generateUniqueSchemePatchDir(commitMessage2, true);
        ArrayList<Change> textChanges = new ArrayList<Change>();
        ArrayList<ShelvedBinaryFile> binaryFiles = new ArrayList<ShelvedBinaryFile>();
        for (Change change : changes) {
            if (ChangesUtil.getFilePath((Change)change).isDirectory()) continue;
            if (change.getBeforeRevision() instanceof BinaryContentRevision || change.getAfterRevision() instanceof BinaryContentRevision) {
                binaryFiles.add(this.shelveBinaryFile(schemePatchDir, change));
                continue;
            }
            textChanges.add(change);
        }
        File patchFile = ShelveChangesManager.getPatchFileInConfigDir(schemePatchDir);
        ArrayList<FilePatch> arrayList = new ArrayList<FilePatch>(this.buildAndSavePatchInBatches(patchFile, textChanges, honorExcludedFromCommit));
        ShelvedChangeList changeList = new ShelvedChangeList(patchFile.toString(), commitMessage2.replace('\n', ' '), binaryFiles, ShelvedChangeList.createShelvedChangesFromFilePatches(this.myProject, patchFile.toString(), arrayList));
        changeList.markToDelete(markToBeDeleted);
        changeList.setName(schemePatchDir.getName());
        ProgressManager.checkCanceled();
        this.mySchemeManager.addScheme((Object)changeList, false);
        totalSW.report(LOG);
        ShelvedChangeList shelvedChangeList = changeList;
        if (shelvedChangeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(21);
        }
        return shelvedChangeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FilePatch> buildAndSavePatchInBatches(@NotNull File patchFile, @NotNull List<Change> textChanges, boolean honorExcludedFromCommit) throws VcsException, IOException {
        if (patchFile == null) {
            ShelveChangesManager.$$$reportNull$$$0(22);
        }
        if (textChanges == null) {
            ShelveChangesManager.$$$reportNull$$$0(23);
        }
        ArrayList<FilePatch> patches = new ArrayList<FilePatch>();
        if (textChanges.isEmpty()) {
            ShelfFileProcessorUtil.savePatchFile(this.myProject, patchFile, patches, null, new CommitContext());
            return patches;
        }
        int batchIndex = 0;
        int baseContentsPreloadSize = Registry.intValue((String)"git.shelve.load.base.in.batches", (int)-1);
        int partitionSize = baseContentsPreloadSize > 0 ? baseContentsPreloadSize : textChanges.size();
        List partition = Lists.partition(textChanges, (int)partitionSize);
        for (List list : partition) {
            String inbatch = partition.size() > 1 ? " in batch #" + ++batchIndex : "";
            StopWatch totalSw = StopWatch.start("Total shelving" + inbatch);
            try {
                StopWatch iterSw;
                if (baseContentsPreloadSize > 0) {
                    iterSw = StopWatch.start("Preloading base revisions for " + list.size() + " changes");
                    this.preloadBaseRevisions(list);
                    iterSw.report(LOG);
                }
                ProgressManager.checkCanceled();
                iterSw = StopWatch.start("Building patches" + inbatch);
                patches.addAll(IdeaTextPatchBuilder.buildPatch(this.myProject, list, PathUtil.toSystemDependentName((String)this.myProject.getBasePath()), false, honorExcludedFromCommit));
                iterSw.report(LOG);
                ProgressManager.checkCanceled();
                iterSw = StopWatch.start("Storing base revisions" + inbatch);
                CommitContext commitContext = new CommitContext();
                this.baseRevisionsOfDvcsIntoContext(list, commitContext);
                iterSw.report(LOG);
                iterSw = StopWatch.start("Saving patch file" + inbatch);
                ShelfFileProcessorUtil.savePatchFile(this.myProject, patchFile, patches, null, commitContext);
                iterSw.report(LOG);
            }
            finally {
                ProjectLevelVcsManager.getInstance((Project)this.myProject).getContentRevisionCache().clearConstantCache();
                totalSw.report(LOG);
            }
        }
        return patches;
    }

    private void preloadBaseRevisions(@NotNull List<Change> textChanges) {
        if (textChanges == null) {
            ShelveChangesManager.$$$reportNull$$$0(24);
        }
        MultiMap changesGroupedByRoot = MultiMap.create();
        for (Change change : textChanges) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            if (beforeRevision == null) continue;
            FilePath file = beforeRevision.getFile();
            VcsRoot vcsRoot = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsRootObjectFor(file);
            if (vcsRoot == null || vcsRoot.getVcs() == null) {
                LOG.error(file + " is not under VCS");
                continue;
            }
            changesGroupedByRoot.putValue((Object)vcsRoot, (Object)change);
        }
        for (VcsRoot vcsRoot : changesGroupedByRoot.keySet()) {
            AbstractVcs vcs = Objects.requireNonNull(vcsRoot.getVcs());
            if (vcs.getDiffProvider() == null) continue;
            vcs.getDiffProvider().preloadBaseRevisions(Objects.requireNonNull(vcsRoot.getPath()), changesGroupedByRoot.get((Object)vcsRoot));
        }
    }

    private void rollbackChangesAfterShelve(@NotNull Collection<? extends Change> changes, boolean honorExcludedFromCommit) {
        if (changes == null) {
            ShelveChangesManager.$$$reportNull$$$0(25);
        }
        String operationName = UIUtil.removeMnemonic((String)RollbackChangesDialog.operationNameByChanges(this.myProject, changes));
        boolean modalContext = ApplicationManager.getApplication().isDispatchThread() && LaterInvocator.isInModalContext();
        StopWatch sw = StopWatch.start("Rollback after shelve");
        new RollbackWorker(this.myProject, operationName, modalContext).doRollback(changes, true, null, VcsBundle.message((String)"shelve.changes.action", (Object[])new Object[0]), honorExcludedFromCommit);
        sw.report(LOG);
    }

    @NotNull
    private static File getPatchFileInConfigDir(@NotNull File schemePatchDir) {
        if (schemePatchDir == null) {
            ShelveChangesManager.$$$reportNull$$$0(26);
        }
        return new File(schemePatchDir, "shelved.patch");
    }

    private void baseRevisionsOfDvcsIntoContext(List<? extends Change> textChanges, CommitContext commitContext) {
        ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        if (this.dvcsUsedInProject() && VcsConfiguration.getInstance((Project)this.myProject).INCLUDE_TEXT_INTO_SHELF) {
            HashMap<FilePath, ContentRevision> toKeep = new HashMap<FilePath, ContentRevision>();
            for (Change change : textChanges) {
                FilePath filePath;
                AbstractVcs vcs;
                if (change.getBeforeRevision() == null || change.getAfterRevision() == null || ShelveChangesManager.isBig(change) || (vcs = vcsManager2.getVcsFor(filePath = change.getBeforeRevision().getFile())) == null || !VcsType.distributed.equals((Object)vcs.getType())) continue;
                toKeep.put(filePath, change.getBeforeRevision());
            }
            commitContext.putUserData(BaseRevisionTextPatchEP.ourPutBaseRevisionTextKey, (Object)true);
            commitContext.putUserData(BaseRevisionTextPatchEP.ourBaseRevisions, toKeep);
        }
    }

    private static boolean isBig(@NotNull Change change) {
        VirtualFile vf;
        if (change == null) {
            ShelveChangesManager.$$$reportNull$$$0(27);
        }
        if ((vf = change.getVirtualFile()) != null) {
            return ShelveChangesManager.isBig(vf.getLength());
        }
        ContentRevision beforeRevision = change.getBeforeRevision();
        if (beforeRevision != null) {
            try {
                String content2 = beforeRevision.getContent();
                if (content2 != null && ShelveChangesManager.isBig(content2.length())) {
                    return true;
                }
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
            }
        }
        return false;
    }

    private static boolean isBig(long contentLength) {
        return contentLength > 500000L;
    }

    private boolean dvcsUsedInProject() {
        return Arrays.stream(ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss()).anyMatch(vcs -> VcsType.distributed.equals((Object)vcs.getType()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShelvedChangeList importFilePatches(String fileName, List<? extends FilePatch> patches, List<PatchEP> patchTransitExtensions) throws IOException {
        try {
            File schemePatchDir = this.generateUniqueSchemePatchDir(fileName, true);
            File patchFile = ShelveChangesManager.getPatchFileInConfigDir(schemePatchDir);
            ShelfFileProcessorUtil.savePatchFile(this.myProject, patchFile, patches, patchTransitExtensions, new CommitContext());
            ShelvedChangeList changeList = new ShelvedChangeList(patchFile.toString(), fileName.replace('\n', ' '), (List<ShelvedBinaryFile>)new SmartList(), ShelvedChangeList.createShelvedChangesFromFilePatches(this.myProject, patchFile.getPath(), patches));
            changeList.setName(schemePatchDir.getName());
            this.mySchemeManager.addScheme((Object)changeList, false);
            ShelvedChangeList shelvedChangeList = changeList;
            return shelvedChangeList;
        }
        finally {
            this.notifyStateChanged();
        }
    }

    public List<VirtualFile> gatherPatchFiles(Collection<? extends VirtualFile> files) {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        LinkedList<? extends VirtualFile> filesQueue = new LinkedList<VirtualFile>(files);
        while (!filesQueue.isEmpty()) {
            ProgressManager.checkCanceled();
            VirtualFile file = filesQueue.removeFirst();
            if (file.isDirectory()) {
                filesQueue.addAll(Arrays.asList(file.getChildren()));
                continue;
            }
            if (!PatchFileType.isPatchFile(file)) continue;
            result2.add(file);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShelvedChangeList> importChangeLists(Collection<? extends VirtualFile> files, Consumer<? super VcsException> exceptionConsumer) {
        ArrayList<ShelvedChangeList> result2 = new ArrayList<ShelvedChangeList>(files.size());
        try {
            FilesProgress filesProgress = new FilesProgress(files.size(), VcsBundle.message((String)"shelve.import.to.progress", (Object[])new Object[0]));
            for (VirtualFile virtualFile : files) {
                filesProgress.updateIndicator(virtualFile);
                String description = virtualFile.getNameWithoutExtension().replace('_', ' ');
                File schemeNameDir = this.generateUniqueSchemePatchDir(description, true);
                File patchFile = ShelveChangesManager.getPatchFileInConfigDir(schemeNameDir);
                String patchPath = patchFile.getPath();
                try {
                    List<? extends FilePatch> filePatches = ShelveChangesManager.loadPatchesWithoutContent(this.myProject, virtualFile.getPath(), new CommitContext());
                    if (filePatches.isEmpty()) continue;
                    FileUtil.copy((File)new File(virtualFile.getPath()), (File)patchFile);
                    ShelvedChangeList list = new ShelvedChangeList(patchPath, description, (List<ShelvedBinaryFile>)new SmartList(), ShelvedChangeList.createShelvedChangesFromFilePatches(this.myProject, patchPath, filePatches), virtualFile.getTimeStamp());
                    list.setName(schemeNameDir.getName());
                    this.mySchemeManager.addScheme((Object)list, false);
                    result2.add(list);
                }
                catch (Exception e) {
                    exceptionConsumer.consume((Object)new VcsException((Throwable)e));
                }
            }
        }
        finally {
            this.notifyStateChanged();
        }
        return result2;
    }

    private ShelvedBinaryFile shelveBinaryFile(@NotNull File schemePatchDir, Change change) throws IOException {
        if (schemePatchDir == null) {
            ShelveChangesManager.$$$reportNull$$$0(28);
        }
        ContentRevision beforeRevision = change.getBeforeRevision();
        ContentRevision afterRevision = change.getAfterRevision();
        File beforeFile = beforeRevision == null ? null : beforeRevision.getFile().getIOFile();
        File afterFile = afterRevision == null ? null : afterRevision.getFile().getIOFile();
        String shelvedPath = null;
        if (afterFile != null) {
            String shelvedFileName = afterFile.getName();
            String name = FileUtilRt.getNameWithoutExtension((String)shelvedFileName);
            String extension = FileUtilRt.getExtension((String)shelvedFileName);
            File shelvedFile = FileUtil.findSequentNonexistentFile((File)schemePatchDir, (String)name, (String)extension);
            FileUtil.copy((File)afterRevision.getFile().getIOFile(), (File)shelvedFile);
            shelvedPath = shelvedFile.getPath();
        }
        String beforePath = ChangesUtil.getProjectRelativePath((Project)this.myProject, (File)beforeFile);
        String afterPath = ChangesUtil.getProjectRelativePath((Project)this.myProject, (File)afterFile);
        return new ShelvedBinaryFile(beforePath, afterPath, shelvedPath);
    }

    private void notifyStateChanged() {
        if (!this.myProject.isDisposed()) {
            ((ChangeListener)this.myBus.syncPublisher(SHELF_TOPIC)).stateChanged(new ChangeEvent(this));
        }
    }

    @NotNull
    private File generateUniqueSchemePatchDir(@Nullable String defaultName, boolean createResourceDirectory) {
        File shelfResourcesDirectory = this.getShelfResourcesDirectory();
        File dir = ShelveChangesManager.suggestPatchName(this.myProject, defaultName, shelfResourcesDirectory, "");
        if (createResourceDirectory && !dir.exists()) {
            dir.mkdirs();
        }
        File file = dir;
        if (file == null) {
            ShelveChangesManager.$$$reportNull$$$0(29);
        }
        return file;
    }

    @NotNull
    public static File suggestPatchName(Project project, @Nullable String commitMessage2, File file, String extension) {
        File nonexistentFile;
        String defaultPath = ShelveChangesManager.shortenAndSanitize(commitMessage2);
        while ((nonexistentFile = FileUtil.findSequentNonexistentFile((File)file, (String)defaultPath, (String)(extension == null ? VcsConfiguration.getInstance((Project)project).getPatchFileExtension() : extension))).getName().length() >= 100) {
            defaultPath = defaultPath.substring(0, defaultPath.length() - 1);
        }
        File file2 = nonexistentFile;
        if (file2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(30);
        }
        return file2;
    }

    @NotNull
    private static String shortenAndSanitize(@Nullable String commitMessage2) {
        String defaultPath = PathUtil.suggestFileName((String)StringUtil.notNullize((String)commitMessage2));
        if (defaultPath.isEmpty()) {
            defaultPath = "unnamed";
        }
        if (defaultPath.length() > 90) {
            defaultPath = defaultPath.substring(0, 90);
        }
        String string = defaultPath;
        if (string == null) {
            ShelveChangesManager.$$$reportNull$$$0(31);
        }
        return string;
    }

    public void unshelveChangeList(ShelvedChangeList changeList, @Nullable List<? extends ShelvedChange> changes, @Nullable List<? extends ShelvedBinaryFile> binaryFiles, @Nullable LocalChangeList targetChangeList, boolean showSuccessNotification) {
        this.unshelveChangeList(changeList, changes, binaryFiles, targetChangeList, showSuccessNotification, this.isRemoveFilesFromShelf());
    }

    private void unshelveChangeList(ShelvedChangeList changeList, @Nullable List<? extends ShelvedChange> changes, @Nullable List<? extends ShelvedBinaryFile> binaryFiles, @Nullable LocalChangeList targetChangeList, boolean showSuccessNotification, boolean removeFilesFromShelf) {
        this.unshelveChangeList(changeList, changes, binaryFiles, targetChangeList, showSuccessNotification, false, false, null, null, removeFilesFromShelf);
    }

    public void unshelveChangeList(ShelvedChangeList changeList, @Nullable List<? extends ShelvedChange> changes, @Nullable List<? extends ShelvedBinaryFile> binaryFiles, @Nullable LocalChangeList targetChangeList, boolean showSuccessNotification, boolean systemOperation, boolean reverse, String leftConflictTitle, String rightConflictTitle, boolean removeFilesFromShelf) {
        List<TextFilePatch> textFilePatches;
        ArrayList<FilePatch> remainingPatches = new ArrayList<FilePatch>();
        CommitContext commitContext = new CommitContext();
        try {
            textFilePatches = ShelveChangesManager.loadTextPatches(this.myProject, changeList, changes, remainingPatches, commitContext);
        }
        catch (PatchSyntaxException | IOException e) {
            LOG.info((Throwable)e);
            PatchApplier.showError(this.myProject, VcsBundle.message((String)"unshelve.loading.patch.error", (Object[])new Object[]{e.getMessage()}));
            return;
        }
        ArrayList<TextFilePatch> patches = new ArrayList<TextFilePatch>(textFilePatches);
        ArrayList remainingBinaries = new ArrayList();
        List<ShelvedBinaryFile> binaryFilesToUnshelve = ShelveChangesManager.getBinaryFilesToUnshelve(changeList, binaryFiles, remainingBinaries);
        for (ShelvedBinaryFile shelvedBinaryFile : binaryFilesToUnshelve) {
            patches.add((TextFilePatch)new ShelvedBinaryFilePatch(shelvedBinaryFile));
        }
        PatchApplier patchApplier = new PatchApplier(this.myProject, this.myProject.getBaseDir(), patches, targetChangeList, commitContext, reverse, leftConflictTitle, rightConflictTitle);
        patchApplier.execute(showSuccessNotification, systemOperation);
        if (removeFilesFromShelf) {
            remainingPatches.addAll(patchApplier.getRemainingPatches());
            GuiUtils.invokeLaterIfNeeded(() -> this.updateListAfterUnshelve(changeList, remainingPatches, remainingBinaries, commitContext), (ModalityState)ModalityState.NON_MODAL, (Condition)this.myProject.getDisposed());
        }
    }

    @NotNull
    Map<ShelvedChangeList, Date> deleteShelves(@NotNull List<? extends ShelvedChangeList> shelvedListsToDelete, @NotNull List<? extends ShelvedChangeList> shelvedListsFromChanges, @NotNull List<? extends ShelvedChange> changesToDelete, @NotNull List<? extends ShelvedBinaryFile> binariesToDelete) {
        Date originalDate;
        if (shelvedListsToDelete == null) {
            ShelveChangesManager.$$$reportNull$$$0(32);
        }
        if (shelvedListsFromChanges == null) {
            ShelveChangesManager.$$$reportNull$$$0(33);
        }
        if (changesToDelete == null) {
            ShelveChangesManager.$$$reportNull$$$0(34);
        }
        if (binariesToDelete == null) {
            ShelveChangesManager.$$$reportNull$$$0(35);
        }
        ArrayList<? extends ShelvedChangeList> shelvedListsFromChangesToDelete = new ArrayList<ShelvedChangeList>(shelvedListsFromChanges);
        shelvedListsFromChangesToDelete.removeAll(shelvedListsToDelete);
        if (shelvedListsFromChangesToDelete.size() + binariesToDelete.size() == 0 && shelvedListsToDelete.isEmpty()) {
            Map<ShelvedChangeList, Date> map2 = Collections.emptyMap();
            if (map2 == null) {
                ShelveChangesManager.$$$reportNull$$$0(36);
            }
            return map2;
        }
        HashMap<ShelvedChangeList, Date> deletedListsWithOriginalDate = new HashMap<ShelvedChangeList, Date>();
        for (ShelvedChangeList shelvedChangeList : shelvedListsToDelete) {
            originalDate = shelvedChangeList.DATE;
            if (shelvedChangeList.isDeleted()) {
                this.deleteChangeListCompletely(shelvedChangeList);
                continue;
            }
            this.markChangeListAsDeleted(shelvedChangeList);
            deletedListsWithOriginalDate.put(shelvedChangeList, originalDate);
        }
        for (ShelvedChangeList shelvedChangeList : shelvedListsFromChangesToDelete) {
            ShelvedChangeList shelvedChangeList2;
            originalDate = shelvedChangeList.DATE;
            boolean wasDeleted = shelvedChangeList.isDeleted();
            ShelvedChangeList newListWithDeletedChanges = this.removeChangesFromChangeList(shelvedChangeList, changesToDelete, binariesToDelete);
            if (newListWithDeletedChanges != null) {
                deletedListsWithOriginalDate.put(newListWithDeletedChanges, originalDate);
                continue;
            }
            if (wasDeleted || (shelvedChangeList2 = (ShelvedChangeList)this.mySchemeManager.findSchemeByName(shelvedChangeList.getName())) == null || !shelvedChangeList2.isDeleted()) continue;
            deletedListsWithOriginalDate.put(shelvedChangeList2, originalDate);
        }
        HashMap<ShelvedChangeList, Date> hashMap = deletedListsWithOriginalDate;
        if (hashMap == null) {
            ShelveChangesManager.$$$reportNull$$$0(37);
        }
        return hashMap;
    }

    @Nullable
    private ShelvedChangeList removeChangesFromChangeList(@NotNull ShelvedChangeList list, @NotNull List<? extends ShelvedChange> changes, @NotNull List<? extends ShelvedBinaryFile> binaryFiles) {
        if (list == null) {
            ShelveChangesManager.$$$reportNull$$$0(38);
        }
        if (changes == null) {
            ShelveChangesManager.$$$reportNull$$$0(39);
        }
        if (binaryFiles == null) {
            ShelveChangesManager.$$$reportNull$$$0(40);
        }
        ArrayList<ShelvedBinaryFile> remainingBinaries = new ArrayList<ShelvedBinaryFile>(list.getBinaryFiles());
        remainingBinaries.removeAll(binaryFiles);
        CommitContext commitContext = new CommitContext();
        ArrayList remainingPatches = new ArrayList();
        try {
            ShelveChangesManager.loadTextPatches(this.myProject, list, changes, remainingPatches, commitContext);
        }
        catch (PatchSyntaxException | IOException e) {
            LOG.info((Throwable)e);
            VcsImplUtil.showErrorMessage(this.myProject, e.getMessage(), VcsBundle.message((String)"shelve.delete.files.from.changelist.error", (Object[])new Object[]{list.DESCRIPTION}));
            return null;
        }
        return this.saveRemainingPatchesIfNeeded(list, remainingPatches, remainingBinaries, commitContext, true);
    }

    static List<TextFilePatch> loadTextPatches(Project project, ShelvedChangeList changeList, List<? extends ShelvedChange> changes, List<? super FilePatch> remainingPatches, CommitContext commitContext) throws IOException, PatchSyntaxException {
        List<TextFilePatch> textFilePatches = ShelveChangesManager.loadPatches(project, changeList.PATH, commitContext);
        if (changes != null) {
            Iterator<TextFilePatch> iterator = textFilePatches.iterator();
            while (iterator.hasNext()) {
                TextFilePatch patch = iterator.next();
                if (ShelveChangesManager.needUnshelve((FilePatch)patch, changes)) continue;
                remainingPatches.add((FilePatch)patch);
                iterator.remove();
            }
        }
        return textFilePatches;
    }

    public void setRemoveFilesFromShelf(boolean removeFilesFromShelf) {
        this.myState.myRemoveFilesFromShelf = removeFilesFromShelf;
    }

    public boolean isRemoveFilesFromShelf() {
        return this.myState.myRemoveFilesFromShelf;
    }

    private void markDeletedSystemUnshelved() {
        List systemUnshelved = ContainerUtil.filter((Collection)this.mySchemeManager.getAllSchemes(), list -> list.isRecycled() && list.isMarkedToDelete());
        for (ShelvedChangeList list2 : systemUnshelved) {
            list2.setDeleted(true);
            list2.markToDelete(false);
        }
    }

    private void cleanDeletedOlderOneWeek() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -7);
        this.clean((Condition<? super ShelvedChangeList>)((Condition)list -> list.isDeleted() && list.DATE.before(new Date(cal.getTimeInMillis()))));
    }

    public void cleanUnshelved(long timeBefore) {
        Date limitDate = new Date(timeBefore);
        this.clean((Condition<? super ShelvedChangeList>)((Condition)l -> l.isRecycled() && l.DATE.before(limitDate)));
    }

    private void clean(@NotNull Condition<? super ShelvedChangeList> condition) {
        if (condition == null) {
            ShelveChangesManager.$$$reportNull$$$0(41);
        }
        List toDelete = ContainerUtil.filter((Collection)this.mySchemeManager.getAllSchemes(), condition);
        this.clearShelvedLists(toDelete, true);
    }

    public void shelveSilentlyUnderProgress(final @NotNull List<? extends Change> changes) {
        if (changes == null) {
            ShelveChangesManager.$$$reportNull$$$0(42);
        }
        final ArrayList result2 = new ArrayList();
        new Task.Backgroundable(this.myProject, VcsBundle.getString((String)"shelve.changes.progress.title"), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                result2.addAll(ShelveChangesManager.this.shelveChangesInSeparatedLists(changes));
            }

            public void onSuccess() {
                VcsNotifier.getInstance(this.myProject).notifySuccess(VcsBundle.message((String)"shelve.successful.message", (Object[])new Object[0]));
                if (result2.size() == 1 && ShelveChangesManager.this.isShelfContentActive()) {
                    ShelvedChangesViewManager.getInstance(this.myProject).startEditing((ShelvedChangeList)result2.get(0));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager$4", "run"));
            }
        }.queue();
    }

    private void rememberShelvingFiles(@NotNull Collection<? extends Change> changes) {
        if (changes == null) {
            ShelveChangesManager.$$$reportNull$$$0(43);
        }
        HashSet<VirtualFile> fileSet = new HashSet<VirtualFile>();
        fileSet.addAll(ContainerUtil.map2SetNotNull(changes, Change::getVirtualFile));
        this.myShelvingFiles = fileSet;
    }

    private void cleanShelvingFiles() {
        this.myShelvingFiles = null;
    }

    private boolean isShelfContentActive() {
        ToolWindow window = ChangesViewContentManager.getToolWindowFor(this.myProject, "Shelf");
        return window != null && window.isVisible() && ((ChangesViewContentManager)ChangesViewContentManager.getInstance(this.myProject)).isContentSelected("Shelf");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<ShelvedChangeList> shelveChangesInSeparatedLists(@NotNull Collection<? extends Change> changes) {
        if (changes == null) {
            ShelveChangesManager.$$$reportNull$$$0(44);
        }
        ArrayList<String> failedChangeLists = new ArrayList<String>();
        ArrayList<ShelvedChangeList> result2 = new ArrayList<ShelvedChangeList>();
        ArrayList shelvedChanges = new ArrayList();
        try {
            this.SHELVED_FILES_LOCK.writeLock().lock();
            this.rememberShelvingFiles(changes);
            List changeLists = ChangeListManager.getInstance((Project)this.myProject).getChangeLists();
            for (LocalChangeList list : changeLists) {
                HashSet changeSet = new HashSet(list.getChanges());
                ArrayList<Change> changesForChangelist = new ArrayList<Change>();
                for (Change change : changes) {
                    boolean inChangelist = change instanceof ChangeListChange ? ((ChangeListChange)change).getChangeListId().equals(list.getId()) : changeSet.contains(change);
                    if (!inChangelist) continue;
                    changesForChangelist.add(change);
                }
                if (changesForChangelist.isEmpty()) continue;
                try {
                    result2.add(this.createShelfFromChanges(changesForChangelist, list.getName(), false, false));
                    shelvedChanges.addAll(changesForChangelist);
                }
                catch (Exception e) {
                    ProgressManager.checkCanceled();
                    LOG.warn((Throwable)e);
                    failedChangeLists.add(list.getName());
                }
            }
        }
        finally {
            this.cleanShelvingFiles();
            this.SHELVED_FILES_LOCK.writeLock().unlock();
            this.notifyStateChanged();
        }
        this.rollbackChangesAfterShelve(shelvedChanges, false);
        if (!failedChangeLists.isEmpty()) {
            VcsNotifier.getInstance(this.myProject).notifyError(VcsBundle.message((String)"shelve.failed.title", (Object[])new Object[0]), VcsBundle.message((String)"shelve.failed.message", (Object[])new Object[]{failedChangeLists.size(), StringUtil.join(failedChangeLists, (String)",")}));
        }
        ArrayList<ShelvedChangeList> arrayList = result2;
        if (arrayList == null) {
            ShelveChangesManager.$$$reportNull$$$0(45);
        }
        return arrayList;
    }

    public static void unshelveSilentlyWithDnd(@NotNull Project project, @NotNull ShelvedChangeListDragBean shelvedChangeListDragBean, @Nullable ChangesBrowserNode dropRootNode, boolean removeFilesFromShelf) {
        if (project == null) {
            ShelveChangesManager.$$$reportNull$$$0(46);
        }
        if (shelvedChangeListDragBean == null) {
            ShelveChangesManager.$$$reportNull$$$0(47);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        LocalChangeList predefinedChangeList = dropRootNode != null ? (LocalChangeList)ObjectUtils.tryCast(dropRootNode.getUserObject(), LocalChangeList.class) : null;
        ShelveChangesManager.getInstance(project).unshelveSilentlyAsynchronously(project, shelvedChangeListDragBean.getShelvedChangelists(), shelvedChangeListDragBean.getChanges(), shelvedChangeListDragBean.getBinaryFiles(), predefinedChangeList, removeFilesFromShelf);
    }

    public void unshelveSilentlyAsynchronously(@NotNull Project project, @NotNull List<? extends ShelvedChangeList> selectedChangeLists, @NotNull List<? extends ShelvedChange> selectedChanges, @NotNull List<? extends ShelvedBinaryFile> selectedBinaryChanges, @Nullable LocalChangeList forcePredefinedOneChangelist) {
        if (project == null) {
            ShelveChangesManager.$$$reportNull$$$0(48);
        }
        if (selectedChangeLists == null) {
            ShelveChangesManager.$$$reportNull$$$0(49);
        }
        if (selectedChanges == null) {
            ShelveChangesManager.$$$reportNull$$$0(50);
        }
        if (selectedBinaryChanges == null) {
            ShelveChangesManager.$$$reportNull$$$0(51);
        }
        this.unshelveSilentlyAsynchronously(project, selectedChangeLists, selectedChanges, selectedBinaryChanges, forcePredefinedOneChangelist, this.isRemoveFilesFromShelf());
    }

    private void unshelveSilentlyAsynchronously(@NotNull Project project, final @NotNull List<? extends ShelvedChangeList> selectedChangeLists, final @NotNull List<? extends ShelvedChange> selectedChanges, final @NotNull List<? extends ShelvedBinaryFile> selectedBinaryChanges, final @Nullable LocalChangeList forcePredefinedOneChangelist, final boolean removeFilesFromShelf) {
        if (project == null) {
            ShelveChangesManager.$$$reportNull$$$0(52);
        }
        if (selectedChangeLists == null) {
            ShelveChangesManager.$$$reportNull$$$0(53);
        }
        if (selectedChanges == null) {
            ShelveChangesManager.$$$reportNull$$$0(54);
        }
        if (selectedBinaryChanges == null) {
            ShelveChangesManager.$$$reportNull$$$0(55);
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, VcsBundle.getString((String)"unshelve.changes.progress.title"), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                for (ShelvedChangeList changeList : selectedChangeLists) {
                    ArrayList changesForChangelist = new ArrayList(ContainerUtil.intersection((Collection)Objects.requireNonNull(changeList.getChanges()), (Collection)selectedChanges));
                    ArrayList binariesForChangelist = new ArrayList(ContainerUtil.intersection(changeList.getBinaryFiles(), (Collection)selectedBinaryChanges));
                    boolean shouldUnshelveAllList = changesForChangelist.isEmpty() && binariesForChangelist.isEmpty();
                    ShelveChangesManager.this.unshelveChangeList(changeList, shouldUnshelveAllList ? null : changesForChangelist, shouldUnshelveAllList ? null : binariesForChangelist, forcePredefinedOneChangelist != null ? forcePredefinedOneChangelist : ShelveChangesManager.this.getChangeListUnshelveTo(changeList), true, removeFilesFromShelf);
                    ChangeListManagerImpl.getInstanceImpl(this.myProject).waitForUpdate(VcsBundle.getString((String)"unshelve.changes.progress.title"));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager$5", "run"));
            }
        });
    }

    @NotNull
    private LocalChangeList getChangeListUnshelveTo(@NotNull ShelvedChangeList list) {
        ChangeListManager manager;
        LocalChangeList localChangeList;
        if (list == null) {
            ShelveChangesManager.$$$reportNull$$$0(56);
        }
        LocalChangeList localChangeList2 = (localChangeList = ChangeListUtil.getPredefinedChangeList(list, manager = ChangeListManager.getInstance((Project)this.myProject))) != null ? localChangeList : manager.addChangeList(ChangeListUtil.getChangeListNameForUnshelve(list), "");
        if (localChangeList2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(57);
        }
        return localChangeList2;
    }

    private static List<ShelvedBinaryFile> getBinaryFilesToUnshelve(ShelvedChangeList changeList, List<? extends ShelvedBinaryFile> binaryFiles, List<? super ShelvedBinaryFile> remainingBinaries) {
        if (binaryFiles == null) {
            return new ArrayList<ShelvedBinaryFile>(changeList.getBinaryFiles());
        }
        ArrayList<ShelvedBinaryFile> result2 = new ArrayList<ShelvedBinaryFile>();
        for (ShelvedBinaryFile file : changeList.getBinaryFiles()) {
            if (binaryFiles.contains(file)) {
                result2.add(file);
                continue;
            }
            remainingBinaries.add(file);
        }
        return result2;
    }

    private static boolean needUnshelve(FilePatch patch, List<? extends ShelvedChange> changes) {
        for (ShelvedChange shelvedChange : changes) {
            if (!Comparing.equal((String)patch.getBeforeName(), (String)shelvedChange.getBeforePath())) continue;
            return true;
        }
        return false;
    }

    private static void writePatchesToFile(Project project, String path2, List<? extends FilePatch> remainingPatches, CommitContext commitContext) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(path2), StandardCharsets.UTF_8);){
            UnifiedDiffWriter.write(project, remainingPatches, writer, "\n", commitContext);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public void updateListAfterUnshelve(@NotNull ShelvedChangeList listToUpdate, @NotNull List<? extends FilePatch> patches, @NotNull List<? extends ShelvedBinaryFile> binaries, @NotNull CommitContext commitContext) {
        if (listToUpdate == null) {
            ShelveChangesManager.$$$reportNull$$$0(58);
        }
        if (patches == null) {
            ShelveChangesManager.$$$reportNull$$$0(59);
        }
        if (binaries == null) {
            ShelveChangesManager.$$$reportNull$$$0(60);
        }
        if (commitContext == null) {
            ShelveChangesManager.$$$reportNull$$$0(61);
        }
        this.saveRemainingPatchesIfNeeded(listToUpdate, patches, binaries, commitContext, false);
    }

    @Nullable
    private ShelvedChangeList saveRemainingPatchesIfNeeded(ShelvedChangeList changeList, List<? extends FilePatch> remainingPatches, List<? extends ShelvedBinaryFile> remainingBinaries, CommitContext commitContext, boolean delete) {
        if (remainingPatches.isEmpty() && remainingBinaries.isEmpty()) {
            if (!delete) {
                this.recycleChangeList(changeList);
            } else if (changeList.isDeleted()) {
                this.deleteChangeListCompletely(changeList);
            } else {
                this.markChangeListAsDeleted(changeList);
            }
            return null;
        }
        if (!delete && changeList.isRecycled()) {
            return null;
        }
        ShelvedChangeList newlyCreatedList = null;
        if (delete && changeList.isDeleted()) {
            this.saveRemainingChangesInList(changeList, remainingPatches, remainingBinaries, commitContext);
        } else {
            newlyCreatedList = this.saveRemainingAndRecycleOthers(changeList, remainingPatches, remainingBinaries, commitContext, delete);
        }
        this.notifyStateChanged();
        return newlyCreatedList;
    }

    @Nullable
    private ShelvedChangeList saveRemainingAndRecycleOthers(@NotNull ShelvedChangeList changeList, List<? extends FilePatch> remainingPatches, List<? extends ShelvedBinaryFile> remainingBinaries, CommitContext commitContext, boolean delete) {
        if (changeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(62);
        }
        try {
            ShelvedChangeList listCopy = this.createChangelistCopyWithChanges(changeList, this.generateUniqueSchemePatchDir(changeList.DESCRIPTION, true));
            listCopy.updateDate();
            this.saveRemainingChangesInList(changeList, remainingPatches, remainingBinaries, commitContext);
            this.removeFromListWithChanges(listCopy, Objects.requireNonNull(changeList.getChanges()), changeList.getBinaryFiles());
            if (delete) {
                this.markChangeListAsDeleted(listCopy);
            } else {
                this.recycleChangeList(listCopy);
            }
            this.saveListAsScheme(listCopy);
            return listCopy;
        }
        catch (IOException e) {
            return null;
        }
    }

    private void saveRemainingChangesInList(@NotNull ShelvedChangeList changeList, List<? extends FilePatch> remainingPatches, List<? extends ShelvedBinaryFile> remainingBinaries, CommitContext commitContext) {
        if (changeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(63);
        }
        ShelveChangesManager.writePatchesToFile(this.myProject, changeList.PATH, remainingPatches, commitContext);
        changeList.getBinaryFiles().retainAll(remainingBinaries);
        changeList.setChanges(ShelvedChangeList.createShelvedChangesFromFilePatches(this.myProject, changeList.PATH, remainingPatches));
    }

    void saveListAsScheme(@NotNull ShelvedChangeList list) {
        if (list == null) {
            ShelveChangesManager.$$$reportNull$$$0(64);
        }
        if (!list.getBinaryFiles().isEmpty() || !ContainerUtil.isEmpty(list.getChanges())) {
            this.mySchemeManager.addScheme((Object)list, false);
        }
    }

    @NotNull
    ShelvedChangeList createChangelistCopyWithChanges(@NotNull ShelvedChangeList changeList, @NotNull File targetDir) throws IOException {
        if (changeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(65);
        }
        if (targetDir == null) {
            ShelveChangesManager.$$$reportNull$$$0(66);
        }
        File newPath = ShelveChangesManager.getPatchFileInConfigDir(targetDir);
        FileUtil.copy((File)new File(changeList.PATH), (File)newPath);
        changeList.loadChangesIfNeeded(this.myProject);
        ShelvedChangeList listCopy = new ShelvedChangeList(newPath.getAbsolutePath(), changeList.DESCRIPTION, ShelveChangesManager.copyBinaryFiles(changeList, targetDir), new ArrayList<ShelvedChange>((Collection)Objects.requireNonNull(changeList.getChanges())), changeList.DATE.getTime());
        listCopy.markToDelete(changeList.isMarkedToDelete());
        listCopy.setRecycled(changeList.isRecycled());
        listCopy.setDeleted(changeList.isDeleted());
        listCopy.setName(targetDir.getName());
        ShelvedChangeList shelvedChangeList = listCopy;
        if (shelvedChangeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(67);
        }
        return shelvedChangeList;
    }

    public void restoreList(@NotNull ShelvedChangeList shelvedChangeList, @NotNull Date restoreDate) {
        ShelvedChangeList list;
        if (shelvedChangeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(68);
        }
        if (restoreDate == null) {
            ShelveChangesManager.$$$reportNull$$$0(69);
        }
        if ((list = (ShelvedChangeList)this.mySchemeManager.findSchemeByName(shelvedChangeList.getName())) == null) {
            return;
        }
        list.setDeleted(false);
        list.DATE = restoreDate;
        this.notifyStateChanged();
    }

    @NotNull
    public List<ShelvedChangeList> getRecycledShelvedChangeLists() {
        return this.getRecycled(true);
    }

    public List<ShelvedChangeList> getDeletedLists() {
        return ContainerUtil.newUnmodifiableList((List)ContainerUtil.filter((Collection)this.mySchemeManager.getAllSchemes(), ShelvedChangeList::isDeleted));
    }

    public void clearRecycled() {
        this.clearShelvedLists(this.getRecycledShelvedChangeLists(), true);
    }

    void clearShelvedLists(@NotNull List<? extends ShelvedChangeList> shelvedLists, boolean updateView) {
        if (shelvedLists == null) {
            ShelveChangesManager.$$$reportNull$$$0(70);
        }
        if (shelvedLists.isEmpty()) {
            return;
        }
        for (ShelvedChangeList shelvedChangeList : shelvedLists) {
            this.deleteResources(shelvedChangeList);
            this.mySchemeManager.removeScheme((Object)shelvedChangeList);
        }
        if (updateView) {
            this.notifyStateChanged();
        }
    }

    @NotNull
    public Collection<VirtualFile> getShelvingFiles() {
        return new HashSet<VirtualFile>(ContainerUtil.notNullize(this.myShelvingFiles));
    }

    private void removeFromListWithChanges(@NotNull ShelvedChangeList listCopy, @NotNull List<? extends ShelvedChange> shelvedChanges, @NotNull List<? extends ShelvedBinaryFile> shelvedBinaryChanges) {
        if (listCopy == null) {
            ShelveChangesManager.$$$reportNull$$$0(71);
        }
        if (shelvedChanges == null) {
            ShelveChangesManager.$$$reportNull$$$0(72);
        }
        if (shelvedBinaryChanges == null) {
            ShelveChangesManager.$$$reportNull$$$0(73);
        }
        ShelveChangesManager.removeBinaries(listCopy, shelvedBinaryChanges);
        ShelveChangesManager.removeChanges(listCopy, shelvedChanges);
        try {
            CommitContext commitContext = new CommitContext();
            ArrayList<Object> patches = new ArrayList<Object>();
            List<TextFilePatch> filePatches = ShelveChangesManager.loadPatches(this.myProject, listCopy.PATH, commitContext);
            for (ShelvedChange change : Objects.requireNonNull(listCopy.getChanges())) {
                patches.add(ContainerUtil.find(filePatches, patch -> change.getBeforePath().equals(patch.getBeforeName())));
            }
            ShelveChangesManager.writePatchesToFile(this.myProject, listCopy.PATH, patches, commitContext);
        }
        catch (PatchSyntaxException | IOException e) {
            LOG.info((Throwable)e);
        }
    }

    private static void removeChanges(@NotNull ShelvedChangeList list, @NotNull List<? extends ShelvedChange> shelvedChanges) {
        if (list == null) {
            ShelveChangesManager.$$$reportNull$$$0(74);
        }
        if (shelvedChanges == null) {
            ShelveChangesManager.$$$reportNull$$$0(75);
        }
        Iterator<ShelvedChange> iterator = Objects.requireNonNull(list.getChanges()).iterator();
        while (iterator.hasNext()) {
            ShelvedChange change = iterator.next();
            for (ShelvedChange shelvedChange : shelvedChanges) {
                if (!Comparing.equal((String)change.getBeforePath(), (String)shelvedChange.getBeforePath()) || !Comparing.equal((String)change.getAfterPath(), (String)shelvedChange.getAfterPath())) continue;
                iterator.remove();
            }
        }
    }

    private static void removeBinaries(@NotNull ShelvedChangeList list, @NotNull List<? extends ShelvedBinaryFile> binaryFiles) {
        if (list == null) {
            ShelveChangesManager.$$$reportNull$$$0(76);
        }
        if (binaryFiles == null) {
            ShelveChangesManager.$$$reportNull$$$0(77);
        }
        Iterator<ShelvedBinaryFile> shelvedChangeListIterator = list.getBinaryFiles().iterator();
        while (shelvedChangeListIterator.hasNext()) {
            ShelvedBinaryFile binaryFile = shelvedChangeListIterator.next();
            for (ShelvedBinaryFile shelvedBinaryFile : binaryFiles) {
                if (!Comparing.equal((String)shelvedBinaryFile.BEFORE_PATH, (String)binaryFile.BEFORE_PATH) || !Comparing.equal((String)shelvedBinaryFile.AFTER_PATH, (String)binaryFile.AFTER_PATH)) continue;
                shelvedChangeListIterator.remove();
            }
        }
    }

    private void recycleChangeList(@NotNull ShelvedChangeList changeList) {
        if (changeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(78);
        }
        changeList.setRecycled(true);
        changeList.updateDate();
        if (changeList.isMarkedToDelete()) {
            changeList.markToDelete(false);
            changeList.setDeleted(true);
        }
        this.notifyStateChanged();
    }

    private void deleteChangeListCompletely(@NotNull ShelvedChangeList changeList) {
        if (changeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(79);
        }
        this.deleteResources(changeList);
        this.mySchemeManager.removeScheme((Object)changeList);
        this.notifyStateChanged();
    }

    void markChangeListAsDeleted(@NotNull ShelvedChangeList changeList) {
        if (changeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(80);
        }
        changeList.setDeleted(true);
        changeList.updateDate();
        this.notifyStateChanged();
    }

    private void deleteResources(@NotNull ShelvedChangeList changeList) {
        if (changeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(81);
        }
        FileUtil.delete((File)new File(changeList.PATH));
        for (ShelvedBinaryFile binaryFile : changeList.getBinaryFiles()) {
            String path2 = binaryFile.SHELVED_PATH;
            if (path2 == null) continue;
            FileUtil.delete((File)new File(path2));
        }
        File schemaDir = new File(this.getShelfResourcesDirectory(), changeList.getName());
        if (schemaDir.exists() && ArrayUtil.isEmpty((Object[])schemaDir.list())) {
            FileUtil.delete((File)schemaDir);
        }
    }

    public void renameChangeList(ShelvedChangeList changeList, String newName) {
        changeList.DESCRIPTION = newName;
        this.notifyStateChanged();
    }

    @NotNull
    public static List<TextFilePatch> loadPatches(Project project, String patchPath, @Nullable CommitContext commitContext) throws IOException, PatchSyntaxException {
        List<TextFilePatch> list = ShelveChangesManager.loadPatches(project, patchPath, commitContext, true);
        if (list == null) {
            ShelveChangesManager.$$$reportNull$$$0(82);
        }
        return list;
    }

    @NotNull
    static List<? extends FilePatch> loadPatchesWithoutContent(Project project, String patchPath, @Nullable CommitContext commitContext) throws IOException, PatchSyntaxException {
        List<TextFilePatch> list = ShelveChangesManager.loadPatches(project, patchPath, commitContext, false);
        if (list == null) {
            ShelveChangesManager.$$$reportNull$$$0(83);
        }
        return list;
    }

    private static List<TextFilePatch> loadPatches(Project project, String patchPath, @Nullable CommitContext commitContext, boolean loadContent) throws IOException, PatchSyntaxException {
        char[] text2 = FileUtil.loadFileText((File)new File(patchPath), (String)"UTF-8");
        PatchReader reader = new PatchReader((CharSequence)new CharArrayCharSequence(text2), loadContent);
        List<TextFilePatch> textFilePatches = reader.readTextPatches();
        ApplyPatchDefaultExecutor.applyAdditionalInfoBefore(project, reader.getAdditionalInfo(null), commitContext);
        return textFilePatches;
    }

    public boolean isShowRecycled() {
        return this.myState.myShowRecycled;
    }

    public void setShowRecycled(boolean showRecycled) {
        this.myState.myShowRecycled = showRecycled;
    }

    @NotNull
    public Set<String> getGrouping() {
        Set<String> set = this.myState.groupingKeys;
        if (set == null) {
            ShelveChangesManager.$$$reportNull$$$0(84);
        }
        return set;
    }

    public void setGrouping(@NotNull Set<String> grouping2) {
        if (grouping2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(85);
        }
        this.myState.groupingKeys = grouping2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 29: 
            case 30: 
            case 31: 
            case 36: 
            case 37: 
            case 45: 
            case 57: 
            case 67: 
            case 82: 
            case 83: 
            case 84: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 29: 
            case 30: 
            case 31: 
            case 36: 
            case 37: 
            case 45: 
            case 57: 
            case 67: 
            case 82: 
            case 83: 
            case 84: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 29: 
            case 30: 
            case 31: 
            case 36: 
            case 37: 
            case 45: 
            case 57: 
            case 67: 
            case 82: 
            case 83: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFile";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: 
            case 38: 
            case 56: 
            case 64: 
            case 74: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirectory";
                break;
            }
            case 20: 
            case 25: 
            case 39: 
            case 42: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchFile";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textChanges";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemePatchDir";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedListsToDelete";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedListsFromChanges";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changesToDelete";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binariesToDelete";
                break;
            }
            case 40: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryFiles";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChangeListDragBean";
                break;
            }
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedChangeLists";
                break;
            }
            case 50: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedChanges";
                break;
            }
            case 51: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedBinaryChanges";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listToUpdate";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patches";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaries";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitContext";
                break;
            }
            case 62: 
            case 63: 
            case 65: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChangeList";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restoreDate";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedLists";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listCopy";
                break;
            }
            case 72: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChanges";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedBinaryChanges";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultShelfPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getShelfPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createShelveSchemeManager";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getShelfResourcesDirectory";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "readOneShelvedChangeList";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "copyBinaryFiles";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecycled";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLists";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createShelfFromChanges";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "generateUniqueSchemePatchDir";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestPatchName";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenAndSanitize";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "deleteShelves";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "shelveChangesInSeparatedLists";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeListUnshelveTo";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "createChangelistCopyWithChanges";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPatches";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPatchesWithoutContent";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getGrouping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 29: 
            case 30: 
            case 31: 
            case 36: 
            case 37: 
            case 45: 
            case 57: 
            case 67: 
            case 82: 
            case 83: 
            case 84: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultShelfPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getShelfPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createShelveSchemeManager";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkAndMigrateUnderProgress";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readOneShelvedChangeList";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "migrateOldShelfInfo";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "copyBinaryFiles";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createShelfFromChanges";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "buildAndSavePatchInBatches";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "preloadBaseRevisions";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "rollbackChangesAfterShelve";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getPatchFileInConfigDir";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isBig";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "shelveBinaryFile";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "deleteShelves";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "removeChangesFromChangeList";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "clean";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "shelveSilentlyUnderProgress";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "rememberShelvingFiles";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "shelveChangesInSeparatedLists";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "unshelveSilentlyWithDnd";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "unshelveSilentlyAsynchronously";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getChangeListUnshelveTo";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "updateListAfterUnshelve";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "saveRemainingAndRecycleOthers";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "saveRemainingChangesInList";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "saveListAsScheme";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "createChangelistCopyWithChanges";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "restoreList";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "clearShelvedLists";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "removeFromListWithChanges";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "removeChanges";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "removeBinaries";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "recycleChangeList";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "deleteChangeListCompletely";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "markChangeListAsDeleted";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "deleteResources";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "setGrouping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 29: 
            case 30: 
            case 31: 
            case 36: 
            case 37: 
            case 45: 
            case 57: 
            case 67: 
            case 82: 
            case 83: 
            case 84: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class State {
        @OptionTag(value="remove_strategy")
        public boolean myRemoveFilesFromShelf;
        @Attribute(value="show_recycled")
        public boolean myShowRecycled;
        @XCollection
        public Set<String> groupingKeys = new HashSet<String>();
    }
}

