/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vcs.changes.VirtualFileHolder;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class LogicallyLockedHolder
implements FileHolder {
    private final Map<VirtualFile, LogicalLock> myMap;
    private final Project myProject;

    public LogicallyLockedHolder(Project project) {
        this.myProject = project;
        this.myMap = new HashMap<VirtualFile, LogicalLock>();
    }

    @Override
    public void cleanAll() {
        this.myMap.clear();
    }

    public void add(VirtualFile file, LogicalLock lock) {
        this.myMap.put(file, lock);
    }

    @Override
    public void cleanAndAdjustScope(@NotNull VcsModifiableDirtyScope scope) {
        if (scope == null) {
            LogicallyLockedHolder.$$$reportNull$$$0(0);
        }
        VirtualFileHolder.Companion.cleanScope(this.myMap.keySet(), scope);
    }

    @Override
    public LogicallyLockedHolder copy() {
        LogicallyLockedHolder result2 = new LogicallyLockedHolder(this.myProject);
        result2.myMap.putAll(this.myMap);
        return result2;
    }

    public boolean containsKey(VirtualFile vf) {
        return this.myMap.containsKey(vf);
    }

    public Map<VirtualFile, LogicalLock> getMap() {
        return Collections.unmodifiableMap(this.myMap);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogicallyLockedHolder that = (LogicallyLockedHolder)o;
        return this.myMap.equals(that.myMap);
    }

    public int hashCode() {
        return this.myMap.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/vcs/changes/LogicallyLockedHolder", "cleanAndAdjustScope"));
    }
}

