/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AbstractShowDiffAction;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.diff.DiffMixin;
import com.intellij.openapi.vcs.history.VcsRevisionDescription;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Date;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class ShowBaseRevisionAction
extends AbstractVcsAction {
    @Override
    protected void actionPerformed(@NotNull VcsContext vcsContext) {
        if (vcsContext == null) {
            ShowBaseRevisionAction.$$$reportNull$$$0(0);
        }
        Project project = Objects.requireNonNull(vcsContext.getProject());
        VirtualFile file = vcsContext.getSelectedFiles()[0];
        AbstractVcs vcs = Objects.requireNonNull(ChangesUtil.getVcsForFile((VirtualFile)file, (Project)project));
        ProgressManager.getInstance().run((Task)new MyTask(file, vcs, vcsContext));
    }

    private static String createMessage(@NotNull Project project, @NotNull VcsRevisionDescription description, @NotNull VirtualFile vf) {
        if (project == null) {
            ShowBaseRevisionAction.$$$reportNull$$$0(1);
        }
        if (description == null) {
            ShowBaseRevisionAction.$$$reportNull$$$0(2);
        }
        if (vf == null) {
            ShowBaseRevisionAction.$$$reportNull$$$0(3);
        }
        String commitMessage2 = IssueLinkHtmlRenderer.formatTextWithLinks(project, StringUtil.notNullize((String)description.getCommitMessage()));
        String message = VcsBundle.message((String)"current.version.text", (Object[])new Object[]{description.getAuthor(), DateFormatUtil.formatPrettyDateTime((Date)description.getRevisionDate()), commitMessage2, description.getRevisionNumber().asString(), vf.getName()});
        return "<html><head>" + UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont()) + "</head><body>" + message + "</body></html>";
    }

    @Override
    protected void update(@NotNull VcsContext vcsContext, @NotNull Presentation presentation) {
        if (vcsContext == null) {
            ShowBaseRevisionAction.$$$reportNull$$$0(4);
        }
        if (presentation == null) {
            ShowBaseRevisionAction.$$$reportNull$$$0(5);
        }
        presentation.setEnabled(AbstractShowDiffAction.isEnabled(vcsContext, false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/actions/ShowBaseRevisionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createMessage";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class NotificationPanel
    extends JPanel {
        protected final JEditorPane myLabel = new JEditorPane("text/html", "");

        NotificationPanel() {
            super(new BorderLayout());
            this.myLabel.setEditable(false);
            this.myLabel.setFont(UIUtil.getToolTipFont());
            this.myLabel.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
            this.setBorder((Border)JBUI.Borders.empty((int)1, (int)15));
            this.add((Component)this.myLabel, "Center");
            this.myLabel.setBackground(this.getBackground());
        }

        public void setText(String text2) {
            this.myLabel.setText(text2);
        }

        public JEditorPane getLabel() {
            return this.myLabel;
        }

        @Override
        public Color getBackground() {
            Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.NOTIFICATION_BACKGROUND);
            return color == null ? new Color(0xFFFFCC) : color;
        }
    }

    private static class MyTask
    extends Task.Backgroundable {
        private final AbstractVcs vcs;
        private final VirtualFile selectedFile;
        private VcsRevisionDescription myDescription;
        private final VcsContext vcsContext;

        private MyTask(VirtualFile selectedFile, AbstractVcs vcs, VcsContext vcsContext) {
            super(vcsContext.getProject(), "Loading Current Revision...", true);
            this.selectedFile = selectedFile;
            this.vcs = vcs;
            this.vcsContext = vcsContext;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MyTask.$$$reportNull$$$0(0);
            }
            this.myDescription = Objects.requireNonNull((DiffMixin)this.vcs.getDiffProvider()).getCurrentRevisionDescription(this.selectedFile);
        }

        public void onSuccess() {
            if (this.myProject.isDisposed() || !this.myProject.isOpen()) {
                return;
            }
            if (this.myDescription != null) {
                NotificationPanel panel2 = new NotificationPanel();
                panel2.setText(ShowBaseRevisionAction.createMessage(this.myProject, this.myDescription, this.selectedFile));
                JBPopup message = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel2, (JComponent)panel2.getLabel()).createPopup();
                if (this.vcsContext.getEditor() != null) {
                    message.showInBestPositionFor(this.vcsContext.getEditor());
                } else {
                    message.showCenteredInCurrentWindow(this.myProject);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/actions/ShowBaseRevisionAction$MyTask", "run"));
        }
    }
}

