/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class VcsAwareFormatChangedTextUtil
extends FormatChangedTextUtil {
    VcsAwareFormatChangedTextUtil() {
    }

    @NotNull
    public List<TextRange> getChangedTextRanges(@NotNull Project project, @NotNull PsiFile file) {
        ChangedRangesInfo helper;
        if (project == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(1);
        }
        return (helper = this.getChangedRangesInfo(file)) != null ? helper.allChangedRanges : new ArrayList();
    }

    @Nullable
    public ChangedRangesInfo getChangedRangesInfo(@NotNull PsiFile file) {
        CharSequence testContent;
        Project project;
        Document document;
        if (file == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(2);
        }
        if ((document = PsiDocumentManager.getInstance((Project)(project = file.getProject())).getDocument(file)) == null) {
            return null;
        }
        ChangedRangesInfo cachedChangedTextHelper = VcsAwareFormatChangedTextUtil.getCachedChangedLines(project, document);
        if (cachedChangedTextHelper != null) {
            return cachedChangedTextHelper;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && (testContent = (CharSequence)file.getUserData(TEST_REVISION_CONTENT)) != null) {
            return VcsAwareFormatChangedTextUtil.calculateChangedRangesInfo(document, testContent);
        }
        Change change = ChangeListManager.getInstance((Project)project).getChange(file.getVirtualFile());
        if (change == null) {
            return null;
        }
        if (change.getType() == Change.Type.NEW) {
            TextRange fileRange = file.getTextRange();
            return new ChangedRangesInfo((List)ContainerUtil.newArrayList((Object[])new TextRange[]{fileRange}), null);
        }
        String contentFromVcs = VcsAwareFormatChangedTextUtil.getRevisionedContentFrom(change);
        return contentFromVcs != null ? VcsAwareFormatChangedTextUtil.calculateChangedRangesInfo(document, contentFromVcs) : null;
    }

    @NotNull
    public <T extends PsiElement> List<T> getChangedElements(@NotNull Project project, Change @NotNull [] changes, @NotNull Function<? super VirtualFile, ? extends List<T>> elementsConvertor) {
        if (project == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(3);
        }
        if (elementsConvertor == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(4);
        }
        if (changes == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(5);
        }
        SmartList result2 = new SmartList();
        for (Change change : changes) {
            List elements;
            Document document;
            VirtualFile file;
            if (change.getType() == Change.Type.DELETED || !(change.getAfterRevision() instanceof CurrentContentRevision) || (file = ((CurrentContentRevision)change.getAfterRevision()).getVirtualFile()) == null || (document = FileDocumentManager.getInstance().getDocument(file)) == null) continue;
            List<T> apply2 = elementsConvertor.apply((VirtualFile)file);
            List list = elements = apply2 == null ? null : ContainerUtil.skipNulls(apply2);
            if (ContainerUtil.isEmpty((Collection)elements)) continue;
            BitSet changedLines = VcsAwareFormatChangedTextUtil.getChangedLines(project, document, change);
            if (changedLines != null) {
                for (PsiElement element : elements) {
                    if (!VcsAwareFormatChangedTextUtil.isElementChanged(element, document, changedLines)) continue;
                    result2.add(element);
                }
                continue;
            }
            result2.addAll(elements);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(6);
        }
        return smartList;
    }

    @Nullable
    private static BitSet getChangedLines(@NotNull Project project, @NotNull Document document, @NotNull Change change) {
        if (project == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(7);
        }
        if (document == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(8);
        }
        if (change == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(9);
        }
        if (change.getType() == Change.Type.NEW) {
            return null;
        }
        List<? extends Range> ranges = VcsAwareFormatChangedTextUtil.getChangedRanges(project, document, change);
        if (ranges == null) {
            return null;
        }
        BitSet changedLines = new BitSet();
        for (Range range : ranges) {
            if (range.getType() == 3) {
                changedLines.set(Math.max(0, range.getLine1() - 1), range.getLine1() + 1);
                continue;
            }
            changedLines.set(range.getLine1(), range.getLine2());
        }
        return changedLines;
    }

    @Nullable
    private static List<? extends Range> getChangedRanges(@NotNull Project project, @NotNull Document document, @NotNull Change change) {
        LineStatusTracker<?> tracker;
        if (project == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(10);
        }
        if (document == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(11);
        }
        if (change == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(12);
        }
        if ((tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(document)) != null) {
            if (change instanceof ChangeListChange && tracker instanceof PartialLocalLineStatusTracker) {
                String changeListId = ((ChangeListChange)change).getChangeListId();
                List ranges = ((PartialLocalLineStatusTracker)tracker).getRanges();
                if (ranges != null) {
                    return ContainerUtil.filter((Collection)ranges, range -> range.getChangelistId().equals(changeListId));
                }
                return null;
            }
            return tracker.getRanges();
        }
        String contentFromVcs = VcsAwareFormatChangedTextUtil.getRevisionedContentFrom(change);
        if (contentFromVcs != null) {
            return VcsAwareFormatChangedTextUtil.getRanges(document, contentFromVcs);
        }
        return null;
    }

    private static boolean isElementChanged(@NotNull PsiElement element, @NotNull Document document, @NotNull BitSet changedLines) {
        if (element == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(13);
        }
        if (document == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(14);
        }
        if (changedLines == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(15);
        }
        TextRange textRange = element.getTextRange();
        int startLine = document.getLineNumber(textRange.getStartOffset());
        int endLine = textRange.isEmpty() ? startLine + 1 : document.getLineNumber(textRange.getEndOffset() - 1) + 1;
        int nextSetBit = changedLines.nextSetBit(startLine);
        return nextSetBit != -1 && nextSetBit < endLine;
    }

    @Nullable
    private static String getRevisionedContentFrom(@NotNull Change change) {
        ContentRevision revision;
        if (change == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(16);
        }
        if ((revision = change.getBeforeRevision()) == null) {
            return null;
        }
        try {
            return revision.getContent();
        }
        catch (VcsException e) {
            LOG.error("Can't get content for: " + change.getVirtualFile(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static ChangedRangesInfo getCachedChangedLines(@NotNull Project project, @NotNull Document document) {
        List ranges;
        LineStatusTracker<?> tracker;
        if (project == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(17);
        }
        if (document == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(18);
        }
        if ((tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(document)) != null && (ranges = tracker.getRanges()) != null) {
            return VcsAwareFormatChangedTextUtil.getChangedTextRanges(document, ranges);
        }
        return null;
    }

    @NotNull
    private static ChangedRangesInfo calculateChangedRangesInfo(@NotNull Document document, @NotNull CharSequence contentFromVcs) {
        if (document == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(19);
        }
        if (contentFromVcs == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(20);
        }
        return VcsAwareFormatChangedTextUtil.getChangedTextRanges(document, VcsAwareFormatChangedTextUtil.getRanges(document, contentFromVcs));
    }

    @NotNull
    private static List<Range> getRanges(@NotNull Document document, @NotNull CharSequence contentFromVcs) {
        if (document == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(21);
        }
        if (contentFromVcs == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(22);
        }
        List list = RangesBuilder.createRanges((CharSequence)document.getImmutableCharSequence(), (CharSequence)StringUtilRt.convertLineSeparators((CharSequence)contentFromVcs, (String)"\n"));
        if (list == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(23);
        }
        return list;
    }

    public int calculateChangedLinesNumber(@NotNull Document document, @NotNull CharSequence contentFromVcs) {
        if (document == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(24);
        }
        if (contentFromVcs == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(25);
        }
        List<Range> changedRanges = VcsAwareFormatChangedTextUtil.getRanges(document, contentFromVcs);
        int linesChanges = 0;
        for (Range range : changedRanges) {
            int inserted = range.getLine2() - range.getLine1();
            int deleted = range.getVcsLine2() - range.getVcsLine1();
            linesChanges += Math.max(inserted, deleted);
        }
        return linesChanges;
    }

    @NotNull
    private static ChangedRangesInfo getChangedTextRanges(@NotNull Document document, @NotNull List<? extends Range> changedRanges) {
        if (document == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(26);
        }
        if (changedRanges == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(27);
        }
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        ArrayList<TextRange> insertedRanges = new ArrayList<TextRange>();
        for (Range range : changedRanges) {
            if (range.getType() == 3) continue;
            int changeStartLine = range.getLine1();
            int changeEndLine = range.getLine2();
            int lineStartOffset = document.getLineStartOffset(changeStartLine);
            int lineEndOffset = document.getLineEndOffset(changeEndLine - 1);
            TextRange changedTextRange = new TextRange(lineStartOffset, lineEndOffset);
            ranges.add(changedTextRange);
            if (range.getType() != 2) continue;
            insertedRanges.add(changedTextRange);
        }
        return new ChangedRangesInfo(ranges, insertedRanges);
    }

    public boolean isChangeNotTrackedForFile(@NotNull Project project, @NotNull PsiFile file) {
        boolean isUnderVcs;
        if (project == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(28);
        }
        if (file == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(29);
        }
        if (!(isUnderVcs = VcsUtil.isFileUnderVcs((Project)project, (FilePath)VcsUtil.getFilePath((VirtualFile)file.getVirtualFile())))) {
            return true;
        }
        ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(project);
        List<VirtualFile> unversionedFiles = changeListManager.getUnversionedFiles();
        return unversionedFiles.contains(file.getVirtualFile());
    }

    public void runHeavyModificationTask(@NotNull Project project, @NotNull Document document, @NotNull Runnable o) {
        LineStatusTracker<?> tracker;
        if (project == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(30);
        }
        if (document == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(31);
        }
        if (o == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(32);
        }
        if ((tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(document)) != null) {
            tracker.doFrozen(o);
        } else {
            o.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConvertor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 6: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil";
                break;
            }
            case 8: 
            case 11: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 24: 
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 9: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedLines";
                break;
            }
            case 20: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentFromVcs";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedRanges";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedElements";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChangedTextRanges";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChangedRangesInfo";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getChangedElements";
                break;
            }
            case 6: 
            case 23: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getChangedLines";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getChangedRanges";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isElementChanged";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getRevisionedContentFrom";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCachedChangedLines";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "calculateChangedRangesInfo";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getRanges";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "calculateChangedLinesNumber";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isChangeNotTrackedForFile";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "runHeavyModificationTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

