/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.BytecodeTransformer;
import com.intellij.idea.Main;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.lang.UrlClassLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BootstrapClassLoaderUtil {
    public static final String CLASSPATH_ORDER_FILE = "classpath-order.txt";
    private static final String PROPERTY_IGNORE_CLASSPATH = "ignore.classpath";
    private static final String PROPERTY_ALLOW_BOOTSTRAP_RESOURCES = "idea.allow.bootstrap.resources";
    private static final String PROPERTY_ADDITIONAL_CLASSPATH = "idea.additional.classpath";
    private static final String MARKETPLACE_PLUGIN_DIR = "marketplace";

    private BootstrapClassLoaderUtil() {
    }

    private static Logger getLogger() {
        return Logger.getInstance(BootstrapClassLoaderUtil.class);
    }

    @NotNull
    public static ClassLoader initClassLoader() throws MalformedURLException {
        File marketplaceImpl;
        List<String> jarOrder = BootstrapClassLoaderUtil.loadJarOrder();
        LinkedHashSet<URL> classpath = new LinkedHashSet<URL>();
        BootstrapClassLoaderUtil.addParentClasspath(classpath, false);
        BootstrapClassLoaderUtil.addIdeaLibraries(classpath, jarOrder);
        BootstrapClassLoaderUtil.addAdditionalClassPath(classpath);
        BootstrapClassLoaderUtil.addParentClasspath(classpath, true);
        File mpBoot = new File(PathManager.getPluginsPath(), "marketplace/lib/boot/marketplace-bootstrap.jar");
        boolean installMarketplace = mpBoot.exists();
        if (installMarketplace && (marketplaceImpl = new File(PathManager.getPluginsPath(), "marketplace/lib/boot/marketplace-impl.jar")).exists()) {
            classpath.add(marketplaceImpl.toURI().toURL());
        }
        UrlClassLoader.Builder builder = UrlClassLoader.build().urls(BootstrapClassLoaderUtil.filterClassPath(new ArrayList<URL>(classpath))).allowLock().usePersistentClasspathIndexForLocalClassDirectories().logJarAccess(Boolean.getBoolean("idea.log.classpath.info")).autoAssignUrlsWithProtectionDomain().useCache();
        if (Boolean.parseBoolean(System.getProperty(PROPERTY_ALLOW_BOOTSTRAP_RESOURCES, "true"))) {
            builder.allowBootstrapResources();
        }
        ClassLoaderUtil.addPlatformLoaderParentIfOnJdk9((UrlClassLoader.Builder)builder);
        if (installMarketplace) {
            try {
                ArrayList<BytecodeTransformer> transformers = new ArrayList<BytecodeTransformer>();
                UrlClassLoader spiLoader = UrlClassLoader.build().urls(new URL[]{mpBoot.toURI().toURL()}).parent(BootstrapClassLoaderUtil.class.getClassLoader()).get();
                for (BytecodeTransformer transformer : ServiceLoader.load(BytecodeTransformer.class, (ClassLoader)spiLoader)) {
                    transformers.add(transformer);
                }
                if (!transformers.isEmpty()) {
                    return new TransformingLoader(builder, transformers);
                }
            }
            catch (Throwable e) {
                String path = new File(PathManager.getPluginsPath(), MARKETPLACE_PLUGIN_DIR).getAbsolutePath();
                String message = "As a workaround, you may uninstall or update JetBrains Marketplace Support plugin at " + path;
                Main.showMessage("JetBrains Marketplace boot failure", new Exception(message, e));
            }
        }
        UrlClassLoader urlClassLoader = builder.get();
        if (urlClassLoader == null) {
            BootstrapClassLoaderUtil.$$$reportNull$$$0(0);
        }
        return urlClassLoader;
    }

    private static void addParentClasspath(@NotNull Collection<? super URL> classpath, boolean ext) throws MalformedURLException {
        if (classpath == null) {
            BootstrapClassLoaderUtil.$$$reportNull$$$0(1);
        }
        if (SystemInfoRt.IS_AT_LEAST_JAVA9) {
            if (!ext) {
                BootstrapClassLoaderUtil.parseClassPathString(System.getProperty("java.class.path"), classpath);
            }
        } else {
            String[] extDirs = System.getProperty("java.ext.dirs", "").split(File.pathSeparator);
            if (ext && extDirs.length == 0) {
                return;
            }
            ArrayList<URLClassLoader> loaders = new ArrayList<URLClassLoader>(2);
            for (ClassLoader loader = BootstrapClassLoaderUtil.class.getClassLoader(); loader != null; loader = loader.getParent()) {
                if (loader instanceof URLClassLoader) {
                    loaders.add(0, (URLClassLoader)loader);
                    continue;
                }
                BootstrapClassLoaderUtil.getLogger().warn("Unknown class loader: " + loader.getClass().getName());
            }
            String libPath = PathManager.getLibPath();
            for (URLClassLoader loader : loaders) {
                URL[] urls;
                for (URL url : urls = loader.getURLs()) {
                    String path = BootstrapClassLoaderUtil.urlToPath(url);
                    if (path.startsWith(libPath)) continue;
                    boolean isExt = false;
                    for (String extDir : extDirs) {
                        if (!path.startsWith(extDir) || path.length() <= extDir.length() || path.charAt(extDir.length()) != File.separatorChar) continue;
                        isExt = true;
                        break;
                    }
                    if (isExt != ext) continue;
                    classpath.add(url);
                }
            }
        }
    }

    private static String urlToPath(URL url) throws MalformedURLException {
        try {
            return new File(url.toURI().getSchemeSpecificPart()).getPath();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(url.toString());
        }
    }

    private static void addIdeaLibraries(@NotNull Collection<? super URL> classpath, @NotNull Collection<String> jarOrder) throws MalformedURLException {
        if (classpath == null) {
            BootstrapClassLoaderUtil.$$$reportNull$$$0(2);
        }
        if (jarOrder == null) {
            BootstrapClassLoaderUtil.$$$reportNull$$$0(3);
        }
        Class<BootstrapClassLoaderUtil> aClass = BootstrapClassLoaderUtil.class;
        String selfRoot = PathManager.getResourceRoot(aClass, (String)("/" + aClass.getName().replace('.', '/') + ".class"));
        assert (selfRoot != null);
        URL selfRootUrl = new File(selfRoot).getAbsoluteFile().toURI().toURL();
        File libFolder = new File(PathManager.getLibPath());
        for (String jarName : jarOrder) {
            File jarFile;
            if (jarName == null || jarName.isEmpty() || !(jarFile = new File(libFolder, jarName)).exists()) continue;
            classpath.add(jarFile.toURI().toURL());
        }
        classpath.add(selfRootUrl);
        BootstrapClassLoaderUtil.addLibraries(classpath, libFolder, selfRootUrl);
        BootstrapClassLoaderUtil.addLibraries(classpath, new File(libFolder, "ext"), selfRootUrl);
        BootstrapClassLoaderUtil.addLibraries(classpath, new File(libFolder, "ant/lib"), selfRootUrl);
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static List<String> loadJarOrder() {
        List list;
        Throwable throwable;
        BufferedReader stream;
        block16: {
            block17: {
                stream = new BufferedReader(new InputStreamReader(BootstrapClassLoaderUtil.class.getResourceAsStream(CLASSPATH_ORDER_FILE), StandardCharsets.UTF_8));
                throwable = null;
                list = FileUtilRt.loadLines((BufferedReader)stream);
                if (stream == null) break block16;
                if (throwable == null) break block17;
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block16;
            }
            stream.close();
        }
        List list2 = list;
        if (list2 == null) {
            BootstrapClassLoaderUtil.$$$reportNull$$$0(4);
        }
        return list2;
        {
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (stream != null) {
                            if (throwable != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                stream.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception exception) {
                    List<String> list3 = Collections.emptyList();
                    if (list3 == null) {
                        BootstrapClassLoaderUtil.$$$reportNull$$$0(5);
                    }
                    return list3;
                }
            }
        }
    }

    private static void addLibraries(Collection<? super URL> classPath, File fromDir, URL selfRootUrl) throws MalformedURLException {
        File[] files = fromDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            URL url;
            if (!FileUtilRt.isJarOrZip((File)file) || selfRootUrl.equals(url = file.toURI().toURL())) continue;
            classPath.add(url);
        }
    }

    private static void addAdditionalClassPath(Collection<? super URL> classpath) {
        BootstrapClassLoaderUtil.parseClassPathString(System.getProperty(PROPERTY_ADDITIONAL_CLASSPATH), classpath);
    }

    private static void parseClassPathString(String pathString, Collection<? super URL> classpath) {
        if (pathString == null || pathString.isEmpty()) {
            return;
        }
        try {
            String libPath = PathManager.getLibPath();
            StringTokenizer tokenizer = new StringTokenizer(pathString, File.pathSeparator + ',', false);
            while (tokenizer.hasMoreTokens()) {
                String pathItem = tokenizer.nextToken();
                if (pathItem.startsWith(libPath)) continue;
                classpath.add(new File(pathItem).toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            BootstrapClassLoaderUtil.getLogger().error((Throwable)e);
        }
    }

    private static List<URL> filterClassPath(List<URL> classpath) {
        String ignoreProperty = System.getProperty(PROPERTY_IGNORE_CLASSPATH);
        if (ignoreProperty != null) {
            Pattern pattern = Pattern.compile(ignoreProperty);
            Iterator<URL> i = classpath.iterator();
            while (i.hasNext()) {
                String url = i.next().toExternalForm();
                if (!pattern.matcher(url).matches()) continue;
                i.remove();
            }
        }
        return classpath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/BootstrapClassLoaderUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classpath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarOrder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "initClassLoader";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/BootstrapClassLoaderUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadJarOrder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addParentClasspath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addIdeaLibraries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TransformingLoader
    extends UrlClassLoader {
        private final List<BytecodeTransformer> myTransformers;

        TransformingLoader(@NotNull UrlClassLoader.Builder builder, List<BytecodeTransformer> transformers) {
            if (builder == null) {
                TransformingLoader.$$$reportNull$$$0(0);
            }
            super(builder);
            this.myTransformers = Collections.unmodifiableList(transformers);
        }

        protected Class<?> _defineClass(String name, byte[] b) {
            return super._defineClass(name, this.doTransform(name, null, b));
        }

        protected Class<?> _defineClass(String name, byte[] b, @Nullable ProtectionDomain protectionDomain) {
            return super._defineClass(name, this.doTransform(name, protectionDomain, b), protectionDomain);
        }

        private byte[] doTransform(String name, ProtectionDomain protectionDomain, byte[] bytes) {
            byte[] b = bytes;
            for (BytecodeTransformer transformer : this.myTransformers) {
                byte[] result = transformer.transform((ClassLoader)((Object)this), name, protectionDomain, b);
                if (result == null) continue;
                b = result;
            }
            return b;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/ide/BootstrapClassLoaderUtil$TransformingLoader", "<init>"));
        }
    }
}

