/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.editor;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import java.util.Collections;
import org.editorconfig.configmanagement.editor.EditorConfigPreviewManager;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.EditorConfigElementTypes;
import org.editorconfig.language.psi.EditorConfigHeader;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigPreviewMarkerProvider
extends LineMarkerProviderDescriptor {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable(value="null means disabled")
    public @Nls(capitalization=Nls.Capitalization.Sentence) @Nullable(value="null means disabled") String getName() {
        return EditorConfigBundle.message("line.marker.name.code.preview");
    }

    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            EditorConfigPreviewMarkerProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof EditorConfigHeader) {
            ActionGroup actionGroup = EditorConfigPreviewMarkerProvider.createActions((EditorConfigHeader)element);
            PsiElement child = element.getFirstChild();
            if (child != null && child.getNode().getElementType() == EditorConfigElementTypes.L_BRACKET) {
                return new SectionLineMarkerInfo(actionGroup, child, element.getTextRange(), null);
            }
        }
        return null;
    }

    @NotNull
    private static ActionGroup createActions(@NotNull EditorConfigHeader header) {
        if (header == null) {
            EditorConfigPreviewMarkerProvider.$$$reportNull$$$0(1);
        }
        return new DefaultActionGroup(Collections.singletonList(new ChooseFileAction(header)));
    }

    private static String getPattern(@NotNull String header) {
        if (header == null) {
            EditorConfigPreviewMarkerProvider.$$$reportNull$$$0(2);
        }
        return StringUtil.trimEnd((String)StringUtil.trimStart((String)header, (String)"["), (String)"]");
    }

    @Nullable
    private static VirtualFile choosePreviewFile(@NotNull Project project, final @NotNull VirtualFile rootDir, final @NotNull String pattern) {
        if (project == null) {
            EditorConfigPreviewMarkerProvider.$$$reportNull$$$0(3);
        }
        if (rootDir == null) {
            EditorConfigPreviewMarkerProvider.$$$reportNull$$$0(4);
        }
        if (pattern == null) {
            EditorConfigPreviewMarkerProvider.$$$reportNull$$$0(5);
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return (showHiddenFiles || !FileElement.isFileHidden((VirtualFile)file)) && !".editorconfig".equals(file.getName()) && file.getLength() <= 10000L && EditorConfigPreviewMarkerProvider.matchesPattern(rootDir, pattern, file.getPath()) || file.isDirectory();
            }

            public boolean isFileSelectable(VirtualFile file) {
                return !file.isDirectory();
            }
        }.withRoots(new VirtualFile[]{rootDir});
        descriptor.setForcedToUseIdeaFileChooser(true);
        FileChooserDialog fileChooser = FileChooserFactory.getInstance().createFileChooser(descriptor, project, null);
        VirtualFile[] virtualFiles = fileChooser.choose(project, VirtualFile.EMPTY_ARRAY);
        return virtualFiles.length > 0 ? virtualFiles[0] : null;
    }

    private static boolean matchesPattern(@NotNull VirtualFile rootDir, @NotNull String pattern, @NotNull String filePath) {
        if (rootDir == null) {
            EditorConfigPreviewMarkerProvider.$$$reportNull$$$0(6);
        }
        if (pattern == null) {
            EditorConfigPreviewMarkerProvider.$$$reportNull$$$0(7);
        }
        if (filePath == null) {
            EditorConfigPreviewMarkerProvider.$$$reportNull$$$0(8);
        }
        return EditorConfig.filenameMatches((String)rootDir.getPath(), (String)pattern, (String)filePath);
    }

    @NotNull
    private static VirtualFile getRootDir(@NotNull EditorConfigHeader header) {
        if (header == null) {
            EditorConfigPreviewMarkerProvider.$$$reportNull$$$0(9);
        }
        PsiFile psiFile = header.getContainingFile();
        VirtualFile virtualFile = psiFile.getVirtualFile().getParent();
        if (virtualFile == null) {
            EditorConfigPreviewMarkerProvider.$$$reportNull$$$0(10);
        }
        return virtualFile;
    }

    private static void openPreview(@NotNull Project project, @NotNull VirtualFile editorConfigFile, @NotNull VirtualFile previewFile) {
        if (project == null) {
            EditorConfigPreviewMarkerProvider.$$$reportNull$$$0(11);
        }
        if (editorConfigFile == null) {
            EditorConfigPreviewMarkerProvider.$$$reportNull$$$0(12);
        }
        if (previewFile == null) {
            EditorConfigPreviewMarkerProvider.$$$reportNull$$$0(13);
        }
        FileEditorManager.getInstance((Project)project).closeFile(editorConfigFile);
        EditorConfigPreviewManager.getInstance(project).associateWithPreviewFile(editorConfigFile, previewFile);
        FileEditorManager.getInstance((Project)project).openFile(editorConfigFile, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDir";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/editorconfig/configmanagement/editor/EditorConfigPreviewMarkerProvider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorConfigFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/editorconfig/configmanagement/editor/EditorConfigPreviewMarkerProvider";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createActions";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPattern";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "choosePreviewFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "matchesPattern";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRootDir";
                break;
            }
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "openPreview";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ChooseFileAction
    extends DumbAwareAction {
        @NotNull
        private final EditorConfigHeader myHeader;

        private ChooseFileAction(@NotNull EditorConfigHeader header) {
            if (header == null) {
                ChooseFileAction.$$$reportNull$$$0(0);
            }
            super(EditorConfigBundle.message("editor.preview.open"));
            this.myHeader = header;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            VirtualFile previewFile;
            if (e == null) {
                ChooseFileAction.$$$reportNull$$$0(1);
            }
            if (this.myHeader.isValid() && (previewFile = EditorConfigPreviewMarkerProvider.choosePreviewFile(this.myHeader.getProject(), EditorConfigPreviewMarkerProvider.getRootDir(this.myHeader), EditorConfigPreviewMarkerProvider.getPattern(this.myHeader.getText()))) != null) {
                VirtualFile editorConfigFile = this.myHeader.getContainingFile().getVirtualFile();
                EditorConfigPreviewMarkerProvider.openPreview(this.myHeader.getProject(), editorConfigFile, previewFile);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "header";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "org/editorconfig/configmanagement/editor/EditorConfigPreviewMarkerProvider$ChooseFileAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SectionLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        private final ActionGroup myActionGroup;

        private SectionLineMarkerInfo(@NotNull ActionGroup actionGroup, @NotNull PsiElement element, @NotNull TextRange range, @Nullable Function<? super PsiElement, String> tooltipProvider) {
            if (actionGroup == null) {
                SectionLineMarkerInfo.$$$reportNull$$$0(0);
            }
            if (element == null) {
                SectionLineMarkerInfo.$$$reportNull$$$0(1);
            }
            if (range == null) {
                SectionLineMarkerInfo.$$$reportNull$$$0(2);
            }
            super(element, range, AllIcons.General.InspectionsEye, tooltipProvider, null, GutterIconRenderer.Alignment.LEFT);
            this.myActionGroup = actionGroup;
        }

        @Nullable
        public GutterIconRenderer createGutterRenderer() {
            return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

                public AnAction getClickAction() {
                    return null;
                }

                public boolean isNavigateAction() {
                    return true;
                }

                public ActionGroup getPopupMenuActions() {
                    return myActionGroup;
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "actionGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
            }
            objectArray[1] = "org/editorconfig/configmanagement/editor/EditorConfigPreviewMarkerProvider$SectionLineMarkerInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

