/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.diagnostic.Logger;
import gnu.trove.THashMap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.ByteRange;
import org.jetbrains.io.FileResponses;
import org.jetbrains.io.FileResponsesKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\u001a\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"'\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"RANGE_HEADER", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "fileExtToMimeType", "Lgnu/trove/THashMap;", "", "getFileExtToMimeType", "()Lgnu/trove/THashMap;", "fileExtToMimeType$delegate", "Lkotlin/Lazy;", "flushChunkedResponse", "", "channel", "Lio/netty/channel/Channel;", "isKeepAlive", "", "parseRange", "Lorg/jetbrains/io/ByteRange;", "header", "size", "", "intellij.platform.ide.util.io"})
public final class FileResponsesKt {
    private static final Lazy fileExtToMimeType$delegate = LazyKt.lazy((Function0)fileExtToMimeType.2.INSTANCE);
    private static final Pattern RANGE_HEADER = Pattern.compile("bytes=(\\d+)?-(\\d+)?");

    public static final void flushChunkedResponse(@NotNull Channel channel, boolean isKeepAlive) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        ChannelFuture future = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (!isKeepAlive) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private static final THashMap<String, String> getFileExtToMimeType() {
        Lazy lazy = fileExtToMimeType$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (THashMap)lazy.getValue();
    }

    private static final ByteRange parseRange(String header, long size) {
        ByteRange byteRange;
        CharSequence charSequence = header;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        Matcher m = RANGE_HEADER.matcher(header);
        if (!m.matches()) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(FileResponses.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.error("Range header is invalid: " + header);
            return null;
        }
        CharSequence $i$f$logger = m.group(1);
        bl2 = false;
        boolean bl3 = false;
        if ($i$f$logger == null || $i$f$logger.length() == 0) {
            String string = m.group(2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"m.group(2)");
            $i$f$logger = string;
            long l = size;
            bl2 = false;
            long l2 = Long.parseLong((String)$i$f$logger);
            long l3 = size;
            long l4 = l - l2;
            return new ByteRange(l4, l3);
        }
        String string = m.group(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"m.group(1)");
        String string2 = string;
        boolean bl4 = false;
        long start = Long.parseLong(string2);
        long end = 0L;
        CharSequence charSequence2 = m.group(2);
        boolean bl5 = false;
        boolean bl6 = false;
        if (charSequence2 == null || charSequence2.length() == 0) {
            end = size - 1L;
        } else {
            String string3 = m.group(2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"m.group(2)");
            charSequence2 = string3;
            bl5 = false;
            end = Long.parseLong((String)charSequence2);
        }
        if (end < start) {
            boolean $i$f$logger2 = false;
            Logger logger = Logger.getInstance(FileResponses.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.error("start (" + start + ") must be greater than end (" + end + ')');
            byteRange = null;
        } else if (end >= size) {
            boolean $i$f$logger3 = false;
            Logger logger = Logger.getInstance(FileResponses.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.error("end (" + end + ") must be lesser than size (" + size + ')');
            byteRange = null;
        } else {
            byteRange = new ByteRange(start, end + 1L);
        }
        return byteRange;
    }

    public static final /* synthetic */ THashMap access$getFileExtToMimeType$p() {
        return FileResponsesKt.getFileExtToMimeType();
    }

    public static final /* synthetic */ ByteRange access$parseRange(String header, long size) {
        return FileResponsesKt.parseRange(header, size);
    }
}

