/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ParametersList
implements Cloneable {
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("-D(\\S+?)(?:=(.+))?");
    private static final Pattern MACRO_PATTERN = Pattern.compile("\\$\\{([^}]+)}");
    private final List<String> myParameters = new ArrayList<String>();
    private final List<ParamsGroup> myGroups = new SmartList();
    private final NotNullLazyValue<Map<String, String>> myMacroMap = NotNullLazyValue.createValue(ParametersList::computeMacroMap);
    private static Map<String, String> ourTestMacros;

    public boolean hasParameter(@NotNull @NonNls String parameter) {
        if (parameter == null) {
            ParametersList.$$$reportNull$$$0(0);
        }
        return this.myParameters.contains(parameter);
    }

    public boolean hasProperty(@NotNull @NonNls String propertyName) {
        if (propertyName == null) {
            ParametersList.$$$reportNull$$$0(1);
        }
        return this.getPropertyValue(propertyName) != null;
    }

    @Nullable
    public String getPropertyValue(@NotNull @NonNls String propertyName) {
        String prefix;
        String exact;
        int index;
        if (propertyName == null) {
            ParametersList.$$$reportNull$$$0(2);
        }
        if ((index = this.indexOfParameter((Condition<? super String>)((Condition)arg_0 -> ParametersList.lambda$getPropertyValue$0(exact = "-D" + propertyName, prefix = "-D" + propertyName + "=", arg_0)))) < 0) {
            return null;
        }
        String str = this.myParameters.get(index);
        return str.length() == exact.length() ? "" : str.substring(prefix.length());
    }

    @NotNull
    public Map<String, String> getProperties() {
        Map<String, String> map = this.getProperties("");
        if (map == null) {
            ParametersList.$$$reportNull$$$0(3);
        }
        return map;
    }

    @NotNull
    public Map<String, String> getProperties(@NonNls String valueIfMissing) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        JBIterable matchers = JBIterable.from(this.myParameters).map(PROPERTY_PATTERN::matcher).filter(Matcher::matches);
        for (Matcher matcher : matchers) {
            result.put(matcher.group(1), StringUtil.notNullize((String)matcher.group(2), (String)valueIfMissing));
        }
        LinkedHashMap<String, String> linkedHashMap = result;
        if (linkedHashMap == null) {
            ParametersList.$$$reportNull$$$0(4);
        }
        return linkedHashMap;
    }

    @NotNull
    public String getParametersString() {
        return ParametersList.join(this.getList());
    }

    public String @NotNull [] getArray() {
        String[] stringArray = ArrayUtilRt.toStringArray(this.getList());
        if (stringArray == null) {
            ParametersList.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    @NotNull
    public List<String> getList() {
        if (this.myGroups.isEmpty()) {
            List<String> list = Collections.unmodifiableList(this.myParameters);
            if (list == null) {
                ParametersList.$$$reportNull$$$0(6);
            }
            return list;
        }
        ArrayList<String> params = new ArrayList<String>(this.myParameters);
        for (ParamsGroup group : this.myGroups) {
            params.addAll(group.getParameters());
        }
        List<String> list = Collections.unmodifiableList(params);
        if (list == null) {
            ParametersList.$$$reportNull$$$0(7);
        }
        return list;
    }

    public void clearAll() {
        this.myParameters.clear();
        this.myGroups.clear();
    }

    public void prepend(@NotNull @NonNls String parameter) {
        if (parameter == null) {
            ParametersList.$$$reportNull$$$0(8);
        }
        this.addAt(0, parameter);
    }

    public void prependAll(String ... parameter) {
        if (parameter == null) {
            ParametersList.$$$reportNull$$$0(9);
        }
        this.addAll(parameter);
        Collections.rotate(this.myParameters, parameter.length);
    }

    public void addParametersString(@Nullable @NonNls String parameters) {
        if (StringUtil.isEmptyOrSpaces((String)parameters)) {
            return;
        }
        for (String param : ParametersList.parse(parameters)) {
            this.add(param);
        }
    }

    public void add(@Nullable @NonNls String parameter) {
        if (parameter == null) {
            return;
        }
        this.myParameters.add(this.expandMacros(parameter));
    }

    @NotNull
    public ParamsGroup addParamsGroup(@NotNull @NonNls String groupId) {
        if (groupId == null) {
            ParametersList.$$$reportNull$$$0(10);
        }
        ParamsGroup paramsGroup = this.addParamsGroup(new ParamsGroup(groupId));
        if (paramsGroup == null) {
            ParametersList.$$$reportNull$$$0(11);
        }
        return paramsGroup;
    }

    @NotNull
    public ParamsGroup addParamsGroup(@NotNull ParamsGroup group) {
        if (group == null) {
            ParametersList.$$$reportNull$$$0(12);
        }
        this.myGroups.add(group);
        ParamsGroup paramsGroup = group;
        if (paramsGroup == null) {
            ParametersList.$$$reportNull$$$0(13);
        }
        return paramsGroup;
    }

    @NotNull
    public ParamsGroup addParamsGroupAt(int index, @NotNull ParamsGroup group) {
        if (group == null) {
            ParametersList.$$$reportNull$$$0(14);
        }
        this.myGroups.add(index, group);
        ParamsGroup paramsGroup = group;
        if (paramsGroup == null) {
            ParametersList.$$$reportNull$$$0(15);
        }
        return paramsGroup;
    }

    @NotNull
    public ParamsGroup addParamsGroupAt(int index, @NotNull @NonNls String groupId) {
        if (groupId == null) {
            ParametersList.$$$reportNull$$$0(16);
        }
        ParamsGroup group = new ParamsGroup(groupId);
        this.myGroups.add(index, group);
        ParamsGroup paramsGroup = group;
        if (paramsGroup == null) {
            ParametersList.$$$reportNull$$$0(17);
        }
        return paramsGroup;
    }

    public int getParamsGroupsCount() {
        return this.myGroups.size();
    }

    @NotNull
    public List<String> getParameters() {
        List<String> list = Collections.unmodifiableList(this.myParameters);
        if (list == null) {
            ParametersList.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    public List<ParamsGroup> getParamsGroups() {
        List<ParamsGroup> list = Collections.unmodifiableList(this.myGroups);
        if (list == null) {
            ParametersList.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    public ParamsGroup getParamsGroupAt(int index) {
        ParamsGroup paramsGroup = this.myGroups.get(index);
        if (paramsGroup == null) {
            ParametersList.$$$reportNull$$$0(20);
        }
        return paramsGroup;
    }

    @Nullable
    public ParamsGroup getParamsGroup(@NotNull @NonNls String name) {
        if (name == null) {
            ParametersList.$$$reportNull$$$0(21);
        }
        for (ParamsGroup group : this.myGroups) {
            if (!name.equals(group.getId())) continue;
            return group;
        }
        return null;
    }

    @Nullable
    public ParamsGroup removeParamsGroup(int index) {
        return this.myGroups.remove(index);
    }

    public void addAt(int index, @NotNull @NonNls String parameter) {
        if (parameter == null) {
            ParametersList.$$$reportNull$$$0(22);
        }
        this.myParameters.add(index, this.expandMacros(parameter));
    }

    public void defineSystemProperty(@NotNull @NonNls String propertyName) {
        if (propertyName == null) {
            ParametersList.$$$reportNull$$$0(23);
        }
        this.defineProperty(propertyName, System.getProperty(propertyName));
    }

    public void defineProperty(@NotNull @NonNls String propertyName, @Nullable @NonNls String propertyValue) {
        String prefix;
        if (propertyName == null) {
            ParametersList.$$$reportNull$$$0(24);
        }
        if (propertyValue == null) {
            return;
        }
        String exact = "-D" + propertyName;
        int index = this.indexOfParameter((Condition<? super String>)((Condition)arg_0 -> ParametersList.lambda$defineProperty$1(exact, prefix = "-D" + propertyName + "=", arg_0)));
        if (index > -1) {
            return;
        }
        String value = propertyValue.isEmpty() ? exact : prefix + this.expandMacros(propertyValue);
        this.myParameters.add(value);
    }

    public void addProperty(@NotNull @NonNls String propertyName) {
        if (propertyName == null) {
            ParametersList.$$$reportNull$$$0(25);
        }
        String exact = "-D" + propertyName;
        String prefix = "-D" + propertyName + "=";
        this.replaceOrAddAt(exact, this.myParameters.size(), (Condition<? super String>)((Condition)o -> o.equals(exact) || o.startsWith(prefix)));
    }

    public void addProperty(@NotNull @NonNls String propertyName, @Nullable @NonNls String propertyValue) {
        if (propertyName == null) {
            ParametersList.$$$reportNull$$$0(26);
        }
        if (propertyValue == null) {
            return;
        }
        String exact = "-D" + propertyName;
        String prefix = "-D" + propertyName + "=";
        String value = propertyValue.isEmpty() ? exact : prefix + this.expandMacros(propertyValue);
        this.replaceOrAddAt(value, this.myParameters.size(), (Condition<? super String>)((Condition)o -> o.equals(exact) || o.startsWith(prefix)));
    }

    public void addNotEmptyProperty(@NotNull @NonNls String propertyName, @Nullable @NonNls String propertyValue) {
        if (propertyName == null) {
            ParametersList.$$$reportNull$$$0(27);
        }
        if (StringUtil.isEmptyOrSpaces((String)propertyValue)) {
            return;
        }
        this.addProperty(propertyName, propertyValue);
    }

    public void replaceOrAppend(@NotNull @NonNls String parameterPrefix, @NotNull @NonNls String replacement) {
        if (parameterPrefix == null) {
            ParametersList.$$$reportNull$$$0(28);
        }
        if (replacement == null) {
            ParametersList.$$$reportNull$$$0(29);
        }
        this.replaceOrAddAt(this.expandMacros(replacement), this.myParameters.size(), (Condition<? super String>)((Condition)o -> o.startsWith(parameterPrefix)));
    }

    public void replaceOrPrepend(@NotNull @NonNls String parameterPrefix, @NotNull @NonNls String replacement) {
        if (parameterPrefix == null) {
            ParametersList.$$$reportNull$$$0(30);
        }
        if (replacement == null) {
            ParametersList.$$$reportNull$$$0(31);
        }
        this.replaceOrAddAt(this.expandMacros(replacement), 0, (Condition<? super String>)((Condition)o -> o.startsWith(parameterPrefix)));
    }

    private void replaceOrAddAt(@NotNull String replacement, int position, @NotNull Condition<? super String> existingCondition) {
        if (replacement == null) {
            ParametersList.$$$reportNull$$$0(32);
        }
        if (existingCondition == null) {
            ParametersList.$$$reportNull$$$0(33);
        }
        int index = this.indexOfParameter(existingCondition);
        boolean setNewValue = StringUtil.isNotEmpty((String)replacement);
        if (index > -1 && setNewValue) {
            this.myParameters.set(index, replacement);
        } else if (index > -1) {
            this.myParameters.remove(index);
        } else if (setNewValue) {
            this.myParameters.add(position, replacement);
        }
    }

    private int indexOfParameter(@NotNull @NonNls Condition<? super String> condition) {
        if (condition == null) {
            ParametersList.$$$reportNull$$$0(34);
        }
        return ContainerUtil.lastIndexOf(this.myParameters, condition);
    }

    public void set(int ind, @NotNull @NonNls String value) {
        if (value == null) {
            ParametersList.$$$reportNull$$$0(35);
        }
        this.myParameters.set(ind, value);
    }

    public String get(int ind) {
        return this.myParameters.get(ind);
    }

    @Nullable
    public String getLast() {
        return this.myParameters.size() > 0 ? this.myParameters.get(this.myParameters.size() - 1) : null;
    }

    public void add(@NotNull @NonNls String name, @NotNull @NonNls String value) {
        if (name == null) {
            ParametersList.$$$reportNull$$$0(36);
        }
        if (value == null) {
            ParametersList.$$$reportNull$$$0(37);
        }
        this.myParameters.add(name);
        this.add(value);
    }

    public void addAll(String ... parameters) {
        if (parameters == null) {
            ParametersList.$$$reportNull$$$0(38);
        }
        this.addAll(Arrays.asList(parameters));
    }

    public void addAll(@NotNull @NonNls List<String> parameters) {
        if (parameters == null) {
            ParametersList.$$$reportNull$$$0(39);
        }
        for (String parameter : parameters) {
            this.add(parameter);
        }
    }

    public ParametersList clone() {
        return this.copyTo(new ParametersList());
    }

    @NotNull
    ParametersList copyTo(@NotNull ParametersList target) {
        if (target == null) {
            ParametersList.$$$reportNull$$$0(40);
        }
        target.myParameters.addAll(this.myParameters);
        for (ParamsGroup group : this.myGroups) {
            target.myGroups.add(group.clone());
        }
        ParametersList parametersList = target;
        if (parametersList == null) {
            ParametersList.$$$reportNull$$$0(41);
        }
        return parametersList;
    }

    @NotNull
    public static String join(@NotNull @NonNls List<String> parameters) {
        if (parameters == null) {
            ParametersList.$$$reportNull$$$0(42);
        }
        String string = ParametersListUtil.join(parameters);
        if (string == null) {
            ParametersList.$$$reportNull$$$0(43);
        }
        return string;
    }

    @NotNull
    public static String join(String ... parameters) {
        if (parameters == null) {
            ParametersList.$$$reportNull$$$0(44);
        }
        String string = ParametersListUtil.join((String[])parameters);
        if (string == null) {
            ParametersList.$$$reportNull$$$0(45);
        }
        return string;
    }

    public static String @NotNull [] parse(@NotNull @NonNls String string) {
        if (string == null) {
            ParametersList.$$$reportNull$$$0(46);
        }
        String[] stringArray = ParametersListUtil.parseToArray((String)string);
        if (stringArray == null) {
            ParametersList.$$$reportNull$$$0(47);
        }
        return stringArray;
    }

    @NotNull
    public String expandMacros(@NotNull @NonNls String text) {
        int start;
        if (text == null) {
            ParametersList.$$$reportNull$$$0(48);
        }
        if ((start = text.indexOf("${")) < 0) {
            String string = text;
            if (string == null) {
                ParametersList.$$$reportNull$$$0(49);
            }
            return string;
        }
        Map macroMap = (Map)this.myMacroMap.getValue();
        Matcher matcher = MACRO_PATTERN.matcher(text);
        StringBuilder sb = null;
        while (matcher.find(start)) {
            String value = (String)macroMap.get(matcher.group(1));
            if (value != null) {
                if (sb == null) {
                    sb = new StringBuilder(2 * text.length()).append(text, 0, matcher.start());
                } else {
                    sb.append(text, start, matcher.start());
                }
                sb.append(value);
                start = matcher.end();
                continue;
            }
            if (sb != null) {
                sb.append(text, start, matcher.start() + 2);
            }
            start = matcher.start() + 2;
        }
        String string = sb == null ? text : sb.append(text, start, text.length()).toString();
        if (string == null) {
            ParametersList.$$$reportNull$$$0(50);
        }
        return string;
    }

    public static void setTestMacros(@Nullable @NonNls Map<String, String> testMacros) {
        ourTestMacros = testMacros;
    }

    @NotNull
    private static Map<String, String> computeMacroMap() {
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isUnitTestMode() && ourTestMacros != null) {
            Map map = (Map)ObjectUtils.notNull(ourTestMacros, Collections.emptyMap());
            if (map == null) {
                ParametersList.$$$reportNull$$$0(51);
            }
            return map;
        }
        THashMap map = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        Map pathMacros = PathMacros.getInstance().getUserMacros();
        if (!pathMacros.isEmpty()) {
            for (String name : pathMacros.keySet()) {
                ContainerUtil.putIfNotNull((Object)name, pathMacros.get(name), (Map)map);
            }
        }
        Map env = EnvironmentUtil.getEnvironmentMap();
        for (String name : env.keySet()) {
            ContainerUtil.putIfAbsent((Object)name, env.get(name), (Map)map);
        }
        THashMap tHashMap = map;
        if (tHashMap == null) {
            ParametersList.$$$reportNull$$$0(52);
        }
        return tHashMap;
    }

    public String toString() {
        return this.myParameters + (this.myGroups.isEmpty() ? "" : " and " + this.myGroups);
    }

    private static /* synthetic */ boolean lambda$defineProperty$1(String exact, String prefix, String o) {
        return o.equals(exact) || o.startsWith(prefix);
    }

    private static /* synthetic */ boolean lambda$getPropertyValue$0(String exact, String prefix, String o) {
        return o.equals(exact) || o.startsWith(prefix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 1: 
            case 2: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/ParametersList";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 21: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterPrefix";
                break;
            }
            case 29: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingCondition";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 38: 
            case 39: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/ParametersList";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getArray";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getList";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "addParamsGroup";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "addParamsGroupAt";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamsGroups";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamsGroupAt";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTo";
                break;
            }
            case 43: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "expandMacros";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "computeMacroMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasParameter";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasProperty";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyValue";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepend";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "prependAll";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addParamsGroup";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addParamsGroupAt";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getParamsGroup";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addAt";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "defineSystemProperty";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "defineProperty";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addProperty";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addNotEmptyProperty";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "replaceOrAppend";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "replaceOrPrepend";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "replaceOrAddAt";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "indexOfParameter";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "copyTo";
                break;
            }
            case 42: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "expandMacros";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

