/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.impl.LocalChangesUnderRoots;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import git4idea.branch.GitBranchPair;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.rebase.GitRebaser;
import git4idea.repo.GitRepository;
import git4idea.update.GitUpdateResult;
import git4idea.update.GitUpdater;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitRebaseUpdater
extends GitUpdater {
    private static final Logger LOG = Logger.getInstance((String)GitRebaseUpdater.class.getName());
    private final GitRebaser myRebaser;
    private final ChangeListManager myChangeListManager;
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final GitBranchPair myBranchPair;

    public GitRebaseUpdater(@NotNull Project project, @NotNull Git git, @NotNull GitRepository repository, @NotNull GitBranchPair branchPair, @NotNull ProgressIndicator progressIndicator, @NotNull UpdatedFiles updatedFiles) {
        if (project == null) {
            GitRebaseUpdater.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitRebaseUpdater.$$$reportNull$$$0(1);
        }
        if (repository == null) {
            GitRebaseUpdater.$$$reportNull$$$0(2);
        }
        if (branchPair == null) {
            GitRebaseUpdater.$$$reportNull$$$0(3);
        }
        if (progressIndicator == null) {
            GitRebaseUpdater.$$$reportNull$$$0(4);
        }
        if (updatedFiles == null) {
            GitRebaseUpdater.$$$reportNull$$$0(5);
        }
        super(project, git, repository, progressIndicator, updatedFiles);
        this.myRebaser = new GitRebaser(this.myProject, git, this.myProgressIndicator);
        this.myChangeListManager = ChangeListManager.getInstance((Project)project);
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myBranchPair = branchPair;
    }

    @Override
    public boolean isSaveNeeded() {
        Collection localChanges = (Collection)new LocalChangesUnderRoots(this.myChangeListManager, this.myVcsManager).getChangesUnderRoots(Collections.singletonList(this.myRoot)).get(this.myRoot);
        try {
            return !ContainerUtil.isEmpty((Collection)localChanges) || GitUtil.hasLocalChanges(true, this.myProject, this.myRoot);
        }
        catch (VcsException e) {
            LOG.info("isSaveNeeded failed to check local changes", (Throwable)e);
            return true;
        }
    }

    @Override
    @NotNull
    protected GitUpdateResult doUpdate() {
        LOG.info("doUpdate ");
        String remoteBranch = this.getRemoteBranchToMerge();
        List<String> params = Collections.singletonList(remoteBranch);
        GitUpdateResult gitUpdateResult = this.myRebaser.rebase(this.myRoot, params, () -> this.cancel(), null);
        if (gitUpdateResult == null) {
            GitRebaseUpdater.$$$reportNull$$$0(6);
        }
        return gitUpdateResult;
    }

    @NotNull
    private String getRemoteBranchToMerge() {
        String string = this.myBranchPair.getTarget().getName();
        if (string == null) {
            GitRebaseUpdater.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void cancel() {
        this.myRebaser.abortRebase(this.myRoot);
        this.myProgressIndicator.setText2("Refreshing files for the root " + this.myRoot.getPath());
        this.myRoot.refresh(false, true);
    }

    @NotNull
    GitBranchPair getSourceAndTarget() {
        GitBranchPair gitBranchPair = this.myBranchPair;
        if (gitBranchPair == null) {
            GitRebaseUpdater.$$$reportNull$$$0(8);
        }
        return gitBranchPair;
    }

    public String toString() {
        return "Rebase updater";
    }

    public boolean fastForwardMerge() {
        LOG.info("Trying fast-forward merge for " + this.myRoot);
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(this.myProject).getRepositoryForRoot(this.myRoot);
        if (repository == null) {
            LOG.error("Repository is null for " + this.myRoot);
            return false;
        }
        try {
            this.markStart(this.myRoot);
        }
        catch (VcsException e) {
            LOG.info("Couldn't mark start for repository " + this.myRoot, (Throwable)e);
            return false;
        }
        GitCommandResult result2 = this.myGit.merge(repository, this.getRemoteBranchToMerge(), Collections.singletonList("--ff-only"), new GitLineHandlerListener[0]);
        try {
            this.markEnd(this.myRoot);
        }
        catch (VcsException e) {
            LOG.info("Couldn't mark end for repository " + this.myRoot, (Throwable)e);
            VcsNotifier.getInstance((Project)this.myProject).notifyMinorWarning("Couldn't collect the updated files info", String.format("Update of %s was successful, but we couldn't collect the updated changes because of an error", this.myRoot));
        }
        return result2.success();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchPair";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedFiles";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/update/GitRebaseUpdater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/update/GitRebaseUpdater";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doUpdate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteBranchToMerge";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceAndTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

