/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitDefaultMergeDialogCustomizer;
import git4idea.merge.GitMergeProvider;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GitConflictResolver {
    private static final Logger LOG = Logger.getInstance(GitConflictResolver.class);
    @NotNull
    private final Collection<? extends VirtualFile> myRoots;
    @NotNull
    private final Params myParams;
    @NotNull
    protected final Project myProject;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final AbstractVcsHelper myVcsHelper;

    @Deprecated
    public GitConflictResolver(@NotNull Project project, @NotNull Git git, @NotNull Collection<? extends VirtualFile> roots, @NotNull Params params) {
        if (project == null) {
            GitConflictResolver.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitConflictResolver.$$$reportNull$$$0(1);
        }
        if (roots == null) {
            GitConflictResolver.$$$reportNull$$$0(2);
        }
        if (params == null) {
            GitConflictResolver.$$$reportNull$$$0(3);
        }
        this(project, roots, params);
    }

    public GitConflictResolver(@NotNull Project project, @NotNull Collection<? extends VirtualFile> roots, @NotNull Params params) {
        if (project == null) {
            GitConflictResolver.$$$reportNull$$$0(4);
        }
        if (roots == null) {
            GitConflictResolver.$$$reportNull$$$0(5);
        }
        if (params == null) {
            GitConflictResolver.$$$reportNull$$$0(6);
        }
        this.myProject = project;
        this.myRoots = roots;
        this.myParams = params;
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        this.myVcsHelper = AbstractVcsHelper.getInstance((Project)project);
    }

    public final boolean merge() {
        return this.merge(false);
    }

    protected boolean proceedIfNothingToMerge() throws VcsException {
        return true;
    }

    protected boolean proceedAfterAllMerged() throws VcsException {
        return true;
    }

    public final boolean mergeNoProceed() {
        return this.merge(true);
    }

    protected void notifyUnresolvedRemain() {
        this.notifyWarning(this.myParams.myErrorNotificationTitle, "Unresolved conflicts remaining in the project." + this.myParams.myErrorNotificationAdditionalDescription);
    }

    private void notifyUnresolvedRemainAfterNotification() {
        this.notifyWarning("Unresolved Conflicts Remaining", this.myParams.myErrorNotificationAdditionalDescription);
    }

    protected void notifyWarning(@NotNull String title, @NotNull String content) {
        if (title == null) {
            GitConflictResolver.$$$reportNull$$$0(7);
        }
        if (content == null) {
            GitConflictResolver.$$$reportNull$$$0(8);
        }
        Notification notification = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification(title, content, NotificationType.WARNING, null);
        notification.addAction((AnAction)NotificationAction.createSimple(GitBundle.messagePointer("action.NotificationAction.text.resolve", new Object[0]), () -> {
            notification.expire();
            BackgroundTaskUtil.executeOnPooledThread((Disposable)this.myProject, () -> this.mergeNoProceed());
        }));
        VcsNotifier.getInstance((Project)this.myProject).notify(notification);
    }

    private boolean merge(boolean mergeDialogInvokedFromNotification) {
        try {
            Collection<VirtualFile> initiallyUnmergedFiles = this.getUnmergedFiles(this.myRoots);
            if (initiallyUnmergedFiles.isEmpty()) {
                LOG.info("merge: no unmerged files");
                return mergeDialogInvokedFromNotification ? true : this.proceedIfNothingToMerge();
            }
            this.showMergeDialog(initiallyUnmergedFiles);
            Collection<VirtualFile> unmergedFilesAfterResolve = this.getUnmergedFiles(this.myRoots);
            if (unmergedFilesAfterResolve.isEmpty()) {
                LOG.info("merge no more unmerged files");
                return mergeDialogInvokedFromNotification ? true : this.proceedAfterAllMerged();
            }
            LOG.info("mergeFiles unmerged files remain: " + unmergedFilesAfterResolve);
            if (mergeDialogInvokedFromNotification) {
                this.notifyUnresolvedRemainAfterNotification();
            } else {
                this.notifyUnresolvedRemain();
            }
        }
        catch (VcsException e) {
            this.notifyException(e);
        }
        return false;
    }

    private void showMergeDialog(@NotNull Collection<? extends VirtualFile> initiallyUnmergedFiles) {
        if (initiallyUnmergedFiles == null) {
            GitConflictResolver.$$$reportNull$$$0(9);
        }
        TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
        ApplicationManager.getApplication().invokeAndWait(() -> {
            GitMergeProvider mergeProvider = new GitMergeProvider(this.myProject, this.myParams.reverse);
            this.myVcsHelper.showMergeDialog(new ArrayList(initiallyUnmergedFiles), (MergeProvider)mergeProvider, this.myParams.myMergeDialogCustomizer);
        });
    }

    private void notifyException(@NotNull VcsException e) {
        if (e == null) {
            GitConflictResolver.$$$reportNull$$$0(10);
        }
        LOG.info("mergeFiles ", (Throwable)e);
        String description = "Couldn't check the working tree for unmerged files because of an error.";
        VcsNotifier.getInstance((Project)this.myProject).notifyError(this.myParams.myErrorNotificationTitle, "Couldn't check the working tree for unmerged files because of an error." + this.myParams.myErrorNotificationAdditionalDescription + "<br/>" + e.getLocalizedMessage());
    }

    @NotNull
    private Collection<VirtualFile> getUnmergedFiles(@NotNull Collection<? extends VirtualFile> roots) throws VcsException {
        if (roots == null) {
            GitConflictResolver.$$$reportNull$$$0(11);
        }
        HashSet<VirtualFile> unmergedFiles = new HashSet<VirtualFile>();
        for (VirtualFile virtualFile : roots) {
            unmergedFiles.addAll(this.getUnmergedFiles(virtualFile));
        }
        HashSet<VirtualFile> hashSet = unmergedFiles;
        if (hashSet == null) {
            GitConflictResolver.$$$reportNull$$$0(12);
        }
        return hashSet;
    }

    @NotNull
    private Collection<VirtualFile> getUnmergedFiles(@NotNull VirtualFile root) throws VcsException {
        GitRepository repository;
        if (root == null) {
            GitConflictResolver.$$$reportNull$$$0(13);
        }
        if ((repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root)) == null) {
            LOG.error("Repository not found for root " + root);
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                GitConflictResolver.$$$reportNull$$$0(14);
            }
            return list;
        }
        List<FilePath> files = GitChangeUtils.getUnmergedFiles(repository);
        List list = ContainerUtil.mapNotNull(files, it -> LocalFileSystem.getInstance().refreshAndFindFileByPath(it.getPath()));
        if (list == null) {
            GitConflictResolver.$$$reportNull$$$0(15);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initiallyUnmergedFiles";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/merge/GitConflictResolver";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/merge/GitConflictResolver";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnmergedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "notifyWarning";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showMergeDialog";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "notifyException";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getUnmergedFiles";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Params {
        private boolean reverse;
        private String myErrorNotificationTitle = "";
        private String myErrorNotificationAdditionalDescription = "";
        private String myMergeDescription = "";
        private MergeDialogCustomizer myMergeDialogCustomizer;

        public Params() {
            this.myMergeDialogCustomizer = new MergeDialogCustomizer(){

                @NotNull
                public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
                    if (files == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String string = myMergeDescription;
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "files";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "git4idea/merge/GitConflictResolver$Params$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "git4idea/merge/GitConflictResolver$Params$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getMultipleFileMergeDescription";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getMultipleFileMergeDescription";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }

        public Params(Project project) {
            this.myMergeDialogCustomizer = new GitDefaultMergeDialogCustomizer(project){

                @Override
                @NotNull
                public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
                    if (files == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (!StringUtil.isEmpty((String)myMergeDescription)) {
                        String string = myMergeDescription;
                        if (string == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        return string;
                    }
                    String string = super.getMultipleFileMergeDescription(files);
                    if (string == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: 
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "files";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "git4idea/merge/GitConflictResolver$Params$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "git4idea/merge/GitConflictResolver$Params$2";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getMultipleFileMergeDescription";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getMultipleFileMergeDescription";
                            break;
                        }
                        case 1: 
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }

        public Params setReverse(boolean reverseMerge) {
            this.reverse = reverseMerge;
            return this;
        }

        public Params setErrorNotificationTitle(@Nls String errorNotificationTitle) {
            this.myErrorNotificationTitle = errorNotificationTitle;
            return this;
        }

        public Params setErrorNotificationAdditionalDescription(@Nls String errorNotificationAdditionalDescription) {
            this.myErrorNotificationAdditionalDescription = errorNotificationAdditionalDescription;
            return this;
        }

        public Params setMergeDescription(@Nls String mergeDescription) {
            this.myMergeDescription = mergeDescription;
            return this;
        }

        public Params setMergeDialogCustomizer(MergeDialogCustomizer mergeDialogCustomizer) {
            this.myMergeDialogCustomizer = mergeDialogCustomizer;
            return this;
        }
    }
}

