/*
 * Decompiled with CFR 0.152.
 */
package git4idea.conflicts;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import git4idea.conflicts.GitConflictsView;
import git4idea.merge.GitDefaultMergeDialogCustomizer;
import git4idea.repo.GitConflictsHolder;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitConflictsToolWindowManager {
    public static final String TAB_NAME = "Conflicts";
    @NotNull
    private final Project myProject;
    private final MergingUpdateQueue myQueue;
    @Nullable
    private Content myContent;

    public GitConflictsToolWindowManager(@NotNull Project project) {
        if (project == null) {
            GitConflictsToolWindowManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myQueue = new MergingUpdateQueue("GitConflictsToolWindowManager", 300, true, null, (Disposable)this.myProject);
    }

    private void init() {
        this.myProject.getMessageBus().connect().subscribe(GitConflictsHolder.CONFLICTS_CHANGE, (Object)new GitConflictsHolder.ConflictsListener(){

            @Override
            public void conflictsChanged(@NotNull GitRepository repository) {
                if (repository == null) {
                    1.$$$reportNull$$$0(0);
                }
                GitConflictsToolWindowManager.this.myQueue.queue(Update.create((Object)"update", () -> GitConflictsToolWindowManager.this.updateToolWindow()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/conflicts/GitConflictsToolWindowManager$1", "conflictsChanged"));
            }
        });
        ApplicationManager.getApplication().invokeLater(() -> this.updateToolWindow());
    }

    private void updateToolWindow() {
        if (!Registry.is((String)"git.merge.conflicts.toolwindow")) {
            return;
        }
        boolean hasConflicts = ContainerUtil.exists(GitRepositoryManager.getInstance(this.myProject).getRepositories(), repo -> !repo.getConflictsHolder().getConflicts().isEmpty());
        if (hasConflicts && this.myContent == null) {
            GitDefaultMergeDialogCustomizer mergeDialogCustomizer = new GitDefaultMergeDialogCustomizer(this.myProject);
            GitConflictsView panel2 = new GitConflictsView(this.myProject, mergeDialogCustomizer);
            this.myContent = ContentFactory.SERVICE.getInstance().createContent(panel2.getComponent(), TAB_NAME, false);
            this.myContent.putUserData(ChangesViewContentManager.ORDER_WEIGHT_KEY, (Object)(ChangesViewContentManager.TabOrderWeight.REPOSITORY.getWeight() + 1));
            this.myContent.setCloseable(false);
            this.myContent.setPreferredFocusedComponent(() -> panel2.getPreferredFocusableComponent());
            Disposer.register((Disposable)this.myContent, (Disposable)panel2);
            ChangesViewContentManager.getInstance((Project)this.myProject).addContent(this.myContent);
        }
        if (!hasConflicts && this.myContent != null) {
            ChangesViewContentManager.getInstance((Project)this.myProject).removeContent(this.myContent);
            this.myContent = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/conflicts/GitConflictsToolWindowManager", "<init>"));
    }

    public static class Starter
    implements StartupActivity.DumbAware {
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                Starter.$$$reportNull$$$0(0);
            }
            new GitConflictsToolWindowManager(project).init();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/conflicts/GitConflictsToolWindowManager$Starter", "runActivity"));
        }
    }
}

