/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.util.GitUIUtil;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\r\u0010\u0012\u001a\u00070\t\u00a2\u0006\u0002\b\u0013H\u0014J\b\u0010\u0014\u001a\u00020\tH\u0014J\b\u0010\u0015\u001a\u00020\tH\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lgit4idea/branch/GitCreateBranchOperation;", "Lgit4idea/branch/GitBranchOperation;", "project", "Lcom/intellij/openapi/project/Project;", "git", "Lgit4idea/commands/Git;", "uiHandler", "Lgit4idea/branch/GitBranchUiHandler;", "branchName", "", "startPoints", "", "Lgit4idea/repo/GitRepository;", "force", "", "(Lcom/intellij/openapi/project/Project;Lgit4idea/commands/Git;Lgit4idea/branch/GitBranchUiHandler;Ljava/lang/String;Ljava/util/Map;Z)V", "execute", "", "getOperationName", "Lorg/jetbrains/annotations/Nls;", "getRollbackProposal", "getSuccessMessage", "rollback", "intellij.vcs.git"})
public final class GitCreateBranchOperation
extends GitBranchOperation {
    private final String branchName;
    private final Map<GitRepository, String> startPoints;
    private final boolean force;

    @Override
    public void execute() {
        boolean fatalErrorHappened = false;
        while (this.hasMoreRepositories() && !fatalErrorHappened) {
            GitCommandResult result2;
            GitRepository repository;
            Intrinsics.checkExpressionValueIsNotNull((Object)this.next(), (String)"next()");
            String string = this.startPoints.get(repository);
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)this.myGit.branchCreate(repository, this.branchName, string, this.force), (String)"myGit.branchCreate(repos\u2026nts[repository]!!, force)");
            if (result2.success()) {
                repository.update();
                this.markSuccessful(repository);
                continue;
            }
            this.fatalError(GitBundle.message("create.branch.operation.could.not.create.new.branch", this.branchName), result2.getErrorOutputAsJoinedString());
            fatalErrorHappened = true;
        }
        if (!fatalErrorHappened) {
            this.notifySuccess();
            this.updateRecentBranch();
        }
    }

    @Override
    protected void rollback() {
        Collection<GitRepository> collection = this.getSuccessfulRepositories();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"successfulRepositories");
        Collection<GitRepository> repositories = collection;
        GitCompoundResult deleteResult = new GitCompoundResult(this.myProject);
        for (GitRepository repository : repositories) {
            deleteResult.append(repository, this.myGit.branchDelete(repository, this.branchName, false, new GitLineHandlerListener[0]));
            repository.update();
        }
        VcsNotifier vcsNotifier = VcsNotifier.getInstance((Project)this.myProject);
        if (deleteResult.totalSuccess()) {
            vcsNotifier.notifySuccess(GitBundle.message("create.branch.operation.rollback.successful", new Object[0]), GitBundle.message("create.branch.operation.deleted.branch", this.branchName));
        } else {
            vcsNotifier.notifyError(GitBundle.message("create.branch.operation.error.during.rollback", new Object[0]), deleteResult.getErrorOutputWithReposIndication());
        }
    }

    @Override
    @NotNull
    public String getSuccessMessage() {
        String string = GitBundle.message("create.branch.operation.branch.created", GitUIUtil.bold(GitUIUtil.code(this.branchName)));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GitBundle.message(\"creat\u2026  bold(code(branchName)))");
        return string;
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        return GitBundle.message("create.branch.operation.however.the.branch.was.created.in.the.following.repositories", this.getSuccessfulRepositories().size()) + "<br/>" + this.successfulRepositoriesJoined() + "<br/>" + GitBundle.message("create.branch.operation.you.may.rollback.not.to.let.branches.diverge", this.branchName);
    }

    @Override
    @NotNull
    protected String getOperationName() {
        String string = GitBundle.message("create.branch.operation.name", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GitBundle.message(\"create.branch.operation.name\")");
        return string;
    }

    public GitCreateBranchOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull String branchName, @NotNull Map<GitRepository, String> startPoints, boolean force) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)git, (String)"git");
        Intrinsics.checkParameterIsNotNull((Object)uiHandler, (String)"uiHandler");
        Intrinsics.checkParameterIsNotNull((Object)branchName, (String)"branchName");
        Intrinsics.checkParameterIsNotNull(startPoints, (String)"startPoints");
        super(project, git, uiHandler, (Collection<? extends GitRepository>)startPoints.keySet());
        this.branchName = branchName;
        this.startPoints = startPoints;
        this.force = force;
    }
}

