/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDirectoryIndexExcludePolicy
implements DirectoryIndexExcludePolicy {
    private static final String[] SITE_PACKAGES = new String[]{"site-packages", "dist-packages"};
    private final Project myProject;

    public PyDirectoryIndexExcludePolicy(@NotNull Project project) {
        if (project == null) {
            PyDirectoryIndexExcludePolicy.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public String @NotNull [] getExcludeUrlsForProject() {
        ArrayList<String> result = new ArrayList<String>();
        for (VirtualFile root : ProjectRootManager.getInstance((Project)this.myProject).getContentRoots()) {
            VirtualFile file = root.findChild(".tox");
            if (file == null) continue;
            result.add(file.getUrl());
        }
        String[] stringArray = ArrayUtilRt.toStringArray(result);
        if (stringArray == null) {
            PyDirectoryIndexExcludePolicy.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    @Nullable
    public Function<Sdk, List<VirtualFile>> getExcludeSdkRootsStrategy() {
        return sdk -> {
            LinkedList result = Lists.newLinkedList();
            if (sdk != null) {
                Set roots = ContainerUtil.set((Object[])sdk.getRootProvider().getFiles(OrderRootType.CLASSES));
                for (VirtualFile dir : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                    for (String name : SITE_PACKAGES) {
                        VirtualFile sitePackages = dir.findChild(name);
                        if (sitePackages == null || roots.contains(sitePackages)) continue;
                        result.add(sitePackages);
                    }
                }
            }
            return result;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/PyDirectoryIndexExcludePolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/PyDirectoryIndexExcludePolicy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeUrlsForProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

