/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.storage.factors;

import com.intellij.codeInsight.completion.ml.ContextFeatures;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.completion.ml.ContextFeaturesStorage;
import com.intellij.completion.sorting.RankingModelWrapper;
import com.intellij.completion.sorting.RankingSupport;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.reporting.PermissionsKt;
import com.intellij.stats.PerformanceTracker;
import com.intellij.stats.completion.LookupElementExtensionsKt;
import com.intellij.stats.personalization.UserFactor;
import com.intellij.stats.personalization.UserFactorStorage;
import com.intellij.stats.personalization.UserFactorsManager;
import com.intellij.stats.personalization.session.LookupSessionFactorsStorage;
import com.intellij.stats.storage.factors.LookupStorage;
import com.intellij.stats.storage.factors.MutableElementStorage;
import com.intellij.stats.storage.factors.MutableLookupStorage;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 >2\u00020\u0001:\u0001>B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010'\u001a\u00020\u0012H\u0016J1\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020-0\u00142\b\u0010.\u001a\u0004\u0018\u00010/\u00a2\u0006\u0002\u00100J\u0006\u00101\u001a\u00020)J\u0010\u00102\u001a\u00020\u00152\u0006\u00103\u001a\u00020\rH\u0016J\"\u00104\u001a\u00020)2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002050\u00142\u0006\u00106\u001a\u000207J\u000e\u00108\u001a\u00020)2\u0006\u00109\u001a\u00020:J\u0006\u0010;\u001a\u00020\nJ\u0006\u0010<\u001a\u00020)J\b\u0010\u0018\u001a\u00020\nH\u0016J\b\u0010=\u001a\u00020\nH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R \u0010%\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0010\u00a8\u0006?"}, d2={"Lcom/intellij/stats/storage/factors/MutableLookupStorage;", "Lcom/intellij/stats/storage/factors/LookupStorage;", "startedTimestamp", "", "language", "Lcom/intellij/lang/Language;", "model", "Lcom/intellij/completion/sorting/RankingModelWrapper;", "(JLcom/intellij/lang/Language;Lcom/intellij/completion/sorting/RankingModelWrapper;)V", "_loggingEnabled", "", "_userFactors", "", "", "contextFactors", "getContextFactors", "()Ljava/util/Map;", "contextFeaturesStorage", "Lcom/intellij/codeInsight/completion/ml/ContextFeatures;", "item2storage", "", "Lcom/intellij/stats/storage/factors/MutableElementStorage;", "getLanguage", "()Lcom/intellij/lang/Language;", "mlUsed", "getModel", "()Lcom/intellij/completion/sorting/RankingModelWrapper;", "performanceTracker", "Lcom/intellij/stats/PerformanceTracker;", "getPerformanceTracker", "()Lcom/intellij/stats/PerformanceTracker;", "sessionFactors", "Lcom/intellij/stats/personalization/session/LookupSessionFactorsStorage;", "getSessionFactors", "()Lcom/intellij/stats/personalization/session/LookupSessionFactorsStorage;", "getStartedTimestamp", "()J", "userFactors", "getUserFactors", "contextProvidersResult", "fireElementScored", "", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "factors", "", "mlScore", "", "(Lcom/intellij/codeInsight/lookup/LookupElement;Ljava/util/Map;Ljava/lang/Double;)V", "fireReorderedUsingMLScores", "getItemStorage", "id", "initContextFactors", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "environment", "Lcom/intellij/openapi/util/UserDataHolderBase;", "initUserFactors", "project", "Lcom/intellij/openapi/project/Project;", "isContextFactorsInitialized", "markLoggingEnabled", "shouldComputeFeatures", "Companion", "intellij.statsCollector"})
public final class MutableLookupStorage
implements LookupStorage {
    private Map<String, String> _userFactors;
    private ContextFeatures contextFeaturesStorage;
    private boolean mlUsed;
    private boolean _loggingEnabled;
    @NotNull
    private final PerformanceTracker performanceTracker;
    @NotNull
    private final LookupSessionFactorsStorage sessionFactors;
    private final Map<String, MutableElementStorage> item2storage;
    private final long startedTimestamp;
    @NotNull
    private final Language language;
    @Nullable
    private final RankingModelWrapper model;
    private static final Logger LOG;
    private static final Key<MutableLookupStorage> LOOKUP_STORAGE;
    private static volatile boolean alwaysComputeFeaturesInTests;
    public static final Companion Companion;

    @Override
    @NotNull
    public Map<String, String> getUserFactors() {
        Map map = this._userFactors;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @Override
    @NotNull
    public Map<String, String> getContextFactors() {
        Object object = this.contextFeaturesStorage;
        if (object == null || (object = object.asMap()) == null) {
            object = MapsKt.emptyMap();
        }
        return object;
    }

    @Override
    @NotNull
    public PerformanceTracker getPerformanceTracker() {
        return this.performanceTracker;
    }

    @Override
    @NotNull
    public LookupSessionFactorsStorage getSessionFactors() {
        return this.sessionFactors;
    }

    @Override
    @NotNull
    public MutableElementStorage getItemStorage(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        MutableElementStorage mutableElementStorage = this.item2storage.computeIfAbsent(id, getItemStorage.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)mutableElementStorage, (String)"item2storage.computeIfAb\u2026tableElementStorage()\n  }");
        return mutableElementStorage;
    }

    @Override
    public boolean mlUsed() {
        return this.mlUsed;
    }

    public final void fireReorderedUsingMLScores() {
        this.mlUsed = true;
        this.getPerformanceTracker().reorderedByML();
    }

    @Override
    public boolean shouldComputeFeatures() {
        return this.getModel() != null || this._loggingEnabled || PermissionsKt.isUnitTestMode() && alwaysComputeFeaturesInTests;
    }

    public final boolean isContextFactorsInitialized() {
        return this.contextFeaturesStorage != null;
    }

    public final void fireElementScored(@NotNull LookupElement element, @NotNull Map<String, Object> factors, @Nullable Double mlScore) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull(factors, (String)"factors");
        this.getItemStorage(LookupElementExtensionsKt.idString(element)).fireElementScored(factors, mlScore);
    }

    public final void initUserFactors(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this._userFactors != null) {
            LOG.error("User factors should be initialized only once");
        } else {
            boolean bl = false;
            Map userFactorValues = new LinkedHashMap();
            List<UserFactor> userFactors = UserFactorsManager.Companion.getInstance().getAllFactors();
            UserFactorStorage applicationStorage = UserFactorStorage.Companion.getInstance();
            UserFactorStorage projectStorage = UserFactorStorage.Companion.getInstance(project);
            for (UserFactor factor : userFactors) {
                String it;
                String string;
                boolean bl2;
                boolean bl3;
                if (factor.compute(applicationStorage) != null) {
                    bl3 = false;
                    bl2 = false;
                    it = string;
                    boolean bl4 = false;
                    userFactorValues.put(factor.getId() + ":App", it);
                }
                if (factor.compute(projectStorage) == null) continue;
                bl3 = false;
                bl2 = false;
                it = string;
                boolean bl5 = false;
                userFactorValues.put(factor.getId() + ":Project", it);
            }
            this._userFactors = userFactorValues;
        }
    }

    @Override
    @NotNull
    public ContextFeatures contextProvidersResult() {
        ContextFeatures contextFeatures = this.contextFeaturesStorage;
        if (contextFeatures == null) {
            contextFeatures = ContextFeaturesStorage.Companion.getEMPTY();
        }
        return contextFeatures;
    }

    public final void initContextFactors(@NotNull Map<String, MLFeatureValue> contextFactors, @NotNull UserDataHolderBase environment) {
        Intrinsics.checkParameterIsNotNull(contextFactors, (String)"contextFactors");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        if (this.isContextFactorsInitialized()) {
            LOG.error("Context factors should be initialized only once");
        } else {
            ContextFeaturesStorage features2 = new ContextFeaturesStorage(contextFactors);
            environment.copyUserDataTo((UserDataHolderBase)features2);
            this.contextFeaturesStorage = features2;
        }
    }

    public final void markLoggingEnabled() {
        this._loggingEnabled = true;
    }

    @Override
    public long getStartedTimestamp() {
        return this.startedTimestamp;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        return this.language;
    }

    @Override
    @Nullable
    public RankingModelWrapper getModel() {
        return this.model;
    }

    public MutableLookupStorage(long startedTimestamp, @NotNull Language language, @Nullable RankingModelWrapper model) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        this.startedTimestamp = startedTimestamp;
        this.language = language;
        this.model = model;
        this.performanceTracker = new PerformanceTracker();
        this.sessionFactors = new LookupSessionFactorsStorage(this.getStartedTimestamp());
        MutableLookupStorage mutableLookupStorage = this;
        boolean bl = false;
        mutableLookupStorage.item2storage = map = (Map)new LinkedHashMap();
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MutableLookupStorage.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        Key key = Key.create((String)"completion.ml.lookup.storage");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<MutableLookup\u2026etion.ml.lookup.storage\")");
        LOOKUP_STORAGE = key;
        alwaysComputeFeaturesInTests = true;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/stats/storage/factors/MutableLookupStorage$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "LOOKUP_STORAGE", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/stats/storage/factors/MutableLookupStorage;", "kotlin.jvm.PlatformType", "alwaysComputeFeaturesInTests", "", "get", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "initOrGetLookupStorage", "language", "Lcom/intellij/lang/Language;", "setComputeFeaturesAlways", "", "value", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "intellij.statsCollector"})
    public static final class Companion {
        public final void setComputeFeaturesAlways(boolean value, @NotNull Disposable parentDisposable) {
            Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
            boolean valueBefore2 = alwaysComputeFeaturesInTests;
            alwaysComputeFeaturesInTests = value;
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(valueBefore2){
                final /* synthetic */ boolean $valueBefore;

                public final void dispose() {
                    MutableLookupStorage.access$setAlwaysComputeFeaturesInTests$cp(this.$valueBefore);
                }
                {
                    this.$valueBefore = bl;
                }
            });
        }

        @Nullable
        public final MutableLookupStorage get(@NotNull LookupImpl lookup) {
            Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
            return (MutableLookupStorage)lookup.getUserData(LOOKUP_STORAGE);
        }

        @NotNull
        public final MutableLookupStorage initOrGetLookupStorage(@NotNull LookupImpl lookup, @NotNull Language language) {
            Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
            Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
            MutableLookupStorage existed = this.get(lookup);
            if (existed != null) {
                return existed;
            }
            MutableLookupStorage storage = new MutableLookupStorage(System.currentTimeMillis(), language, RankingSupport.INSTANCE.getRankingModel(language));
            lookup.putUserData(LOOKUP_STORAGE, (Object)storage);
            return storage;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

