/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.AbstractBundle;
import com.intellij.DynamicBundle;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ExportSettingsActionKt;
import com.intellij.configurationStore.ExportableItem;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StateStorageManagerImplKt;
import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.configurationStore.UnknownMacroException;
import com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase;
import com.intellij.configurationStore.schemeManager.SchemeManagerImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceBean;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.serviceContainer.ContainerUtilKt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.Compressor;
import com.intellij.util.io.PathKt;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.BiPredicate;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a$\u0010\u0004\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a>\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00160\u0012H\u0082\b\u001a&\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000e2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002\u001aD\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e2\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u00162\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u0010\b\u0002\u0010#\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0006\u001a\b\u0010$\u001a\u00020\u0016H\u0000\u001a\u0018\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0016H\u0002\u001a \u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u000bH\u0002\u00a8\u0006."}, d2={"exportInstalledPlugins", "", "zip", "Lcom/intellij/util/io/Compressor;", "exportSettings", "exportFiles", "", "Ljava/nio/file/Path;", "out", "Ljava/io/OutputStream;", "configPath", "", "getAdditionalExportFile", "stateAnnotation", "Lcom/intellij/openapi/components/State;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManager;", "isSkipFile", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "file", "", "getComponentPresentableName", "state", "aClass", "Ljava/lang/Class;", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "getExportableComponentsMap", "", "", "Lcom/intellij/configurationStore/ExportableItem;", "isOnlyExisting", "isComputePresentableNames", "onlyPaths", "isImportExportActionApplicable", "isStorageExportable", "storage", "Lcom/intellij/openapi/components/Storage;", "isRoamable", "messageOrDefault", "classLoader", "Ljava/lang/ClassLoader;", "bundleName", "defaultName", "intellij.platform.configurationStore.impl"})
public final class ExportSettingsActionKt {
    public static final boolean isImportExportActionApplicable() {
        Application app;
        Application application = app = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
        StateStorageManager stateStorageManager = ServiceKt.getStateStore((ComponentManager)((ComponentManager)application)).getStorageManager();
        if (!(stateStorageManager instanceof StateStorageManagerImpl)) {
            stateStorageManager = null;
        }
        StateStorageManagerImpl stateStorageManagerImpl = (StateStorageManagerImpl)stateStorageManager;
        if (stateStorageManagerImpl == null) {
            return true;
        }
        StateStorageManagerImpl storageManager2 = stateStorageManagerImpl;
        return !storageManager2.isStreamProviderPreventExportAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void exportSettings(@NotNull Set<? extends Path> exportFiles, @NotNull OutputStream out, @NotNull String configPath) {
        Intrinsics.checkParameterIsNotNull(exportFiles, (String)"exportFiles");
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        Intrinsics.checkParameterIsNotNull((Object)configPath, (String)"configPath");
        THashSet filter = new THashSet();
        Closeable closeable = (Closeable)new Compressor.Zip(out).filter((BiPredicate)new BiPredicate<String, File>(filter){
            final /* synthetic */ THashSet $filter;

            public final boolean test(String entryName, File $noName_1) {
                return this.$filter.add((Object)entryName);
            }
            {
                this.$filter = tHashSet;
            }
        });
        boolean bl = false;
        Throwable throwable = null;
        try {
            Compressor zip = (Compressor)closeable;
            boolean bl2 = false;
            for (Path path : exportFiles) {
                BasicFileAttributes fileInfo;
                String relativePath;
                if (PathKt.basicAttributesIfExists((Path)path) == null) {
                    continue;
                }
                Path path2 = path.toAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"file.toAbsolutePath()");
                if (FileUtil.getRelativePath((String)configPath, (String)PathKt.getSystemIndependentPath((Path)path2), (char)'/') == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)relativePath, (String)"FileUtil.getRelativePath\u2026emIndependentPath, '/')!!");
                if (fileInfo.isDirectory()) {
                    zip.addDirectory(relativePath, path.toFile());
                    continue;
                }
                zip.addFile(relativePath, PathKt.inputStream((Path)path));
            }
            Compressor compressor = zip;
            Intrinsics.checkExpressionValueIsNotNull((Object)compressor, (String)"zip");
            ExportSettingsActionKt.exportInstalledPlugins(compressor);
            zip.addFile("IntelliJ IDEA Global Settings", ArrayUtil.EMPTY_BYTE_ARRAY);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final void exportInstalledPlugins(@NotNull Compressor zip) {
        Intrinsics.checkParameterIsNotNull((Object)zip, (String)"zip");
        Object[] objectArray = PluginManagerCore.getPlugins();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"PluginManagerCore.getPlugins()");
        List plugins2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)exportInstalledPlugins.plugins.1.INSTANCE), (Function1)exportInstalledPlugins.plugins.2.INSTANCE));
        Collection collection = plugins2;
        boolean bl = false;
        if (!collection.isEmpty()) {
            StringWriter buffer = new StringWriter();
            PluginManagerCore.writePluginsList((Collection)plugins2, (Writer)buffer);
            String string = buffer.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buffer.toString()");
            String string2 = string;
            String string3 = "installed.txt";
            Compressor compressor = zip;
            Charset charset = Charsets.UTF_8;
            boolean bl2 = false;
            String string4 = string2;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string4.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            compressor.addFile(string3, byArray2);
        }
    }

    @NotNull
    public static final Map<Path, List<ExportableItem>> getExportableComponentsMap(boolean isOnlyExisting, boolean isComputePresentableNames, @NotNull StateStorageManager storageManager2, @Nullable Set<String> onlyPaths) {
        Intrinsics.checkParameterIsNotNull((Object)storageManager2, (String)"storageManager");
        LinkedHashMap result = new LinkedHashMap();
        Function1 processor2 = (Function1)new Function1<ExportableComponent, Unit>(result){
            final /* synthetic */ LinkedHashMap $result;

            public final void invoke(@NotNull ExportableComponent component) {
                Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
                for (File file : component.getExportFiles()) {
                    Path path = file.toPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file.toPath()");
                    String string = component.getPresentableName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"component.presentableName");
                    ExportableItem item = new ExportableItem(path, string, RoamingType.DEFAULT);
                    UtilKt.putValue((Map)this.$result, (Object)item.getFile(), (Object)item);
                }
            }
            {
                this.$result = linkedHashMap;
                super(1);
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.serviceContainer.ComponentManagerImpl");
        }
        ComponentManagerImpl app = (ComponentManagerImpl)application;
        List list = app.getComponentInstancesOfType(ExportableApplicationComponent.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"app.getComponentInstance\u2026ionComponent::class.java)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            processor2.invoke(element$iv);
        }
        List list2 = ServiceBean.loadServicesFromBeans((ExtensionPointName)ExportableComponent.EXTENSION_POINT, ExportableComponent.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"ServiceBean.loadServices\u2026bleComponent::class.java)");
        $this$forEach$iv = list2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            processor2.invoke(element$iv);
        }
        String configPath = storageManager2.expandMacros("$ROOT_CONFIG$");
        Function1<Path, Boolean> $fun$isSkipFile$1 = new Function1<Path, Boolean>(onlyPaths, configPath, isOnlyExisting){
            final /* synthetic */ Set $onlyPaths;
            final /* synthetic */ String $configPath;
            final /* synthetic */ boolean $isOnlyExisting;

            public final boolean invoke(@NotNull Path file) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                if (this.$onlyPaths != null) {
                    String string = FileUtil.getRelativePath((String)this.$configPath, (String)PathKt.getSystemIndependentPath((Path)file), (char)'/');
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.getRelativePath\u2026emIndependentPath, '/')!!");
                    String relativePath = string;
                    if (!StringsKt.contains$default((CharSequence)((Object)file.getFileName()).toString(), (char)'.', (boolean)false, (int)2, null) && !PathKt.isFile((Path)file)) {
                        relativePath = relativePath + '/';
                    }
                    if (!this.$onlyPaths.contains(relativePath)) {
                        return true;
                    }
                }
                return this.$isOnlyExisting && !PathKt.exists((Path)file);
            }
            {
                this.$onlyPaths = set;
                this.$configPath = string;
                this.$isOnlyExisting = bl;
                super(1);
            }
        };
        if (isOnlyExisting || onlyPaths != null) {
            Set set = result.keySet();
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"result.keys");
            CollectionsKt.removeAll((Iterable)set, (Function1)((Function1)new Function1<Path, Boolean>($fun$isSkipFile$1){
                final /* synthetic */ getExportableComponentsMap.1 $isSkipFile$1;

                public final boolean invoke(@NotNull Path p1) {
                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                    return this.$isSkipFile$1.invoke(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return null;
                }

                public final String getName() {
                    return "isSkipFile";
                }

                public final String getSignature() {
                    return "invoke(Ljava/nio/file/Path;)Z";
                }
                {
                    this.$isSkipFile$1 = var1_1;
                    super(1);
                }
            }));
        }
        THashMap fileToContent = new THashMap();
        ContainerUtilKt.processAllImplementationClasses((PicoContainer)app.getPicoContainer(), (Function2)new Function2<Class<?>, PluginDescriptor, Boolean>(storageManager2, $fun$isSkipFile$1, isComputePresentableNames, isOnlyExisting, fileToContent, result){
            final /* synthetic */ StateStorageManager $storageManager;
            final /* synthetic */ getExportableComponentsMap.1 $isSkipFile$1;
            final /* synthetic */ boolean $isComputePresentableNames;
            final /* synthetic */ boolean $isOnlyExisting;
            final /* synthetic */ THashMap $fileToContent;
            final /* synthetic */ LinkedHashMap $result;

            public final boolean invoke(@NotNull Class<?> aClass, @Nullable PluginDescriptor pluginDescriptor) {
                boolean isFileIncluded;
                boolean isRoamable;
                State stateAnnotation;
                block17: {
                    block16: {
                        Intrinsics.checkParameterIsNotNull(aClass, (String)"aClass");
                        stateAnnotation = StoreUtilKt.getStateSpec(aClass);
                        if (stateAnnotation == null) break block16;
                        CharSequence charSequence = stateAnnotation.name();
                        boolean bl = false;
                        if (!(charSequence.length() == 0) && !ExportableComponent.class.isAssignableFrom(aClass)) break block17;
                    }
                    return true;
                }
                Storage storage2 = (Storage)CollectionsKt.firstOrNull(ComponentStoreImplKt.sortByDeprecated(stateAnnotation.storages()));
                if (storage2 == null) {
                    return true;
                }
                Storage storage3 = storage2;
                boolean bl = isRoamable = StateStorageManagerImplKt.getEffectiveRoamingType(storage3.roamingType(), StateStorageManagerImplKt.getPath(storage3)) != RoamingType.DISABLED;
                if (!ExportSettingsActionKt.access$isStorageExportable(storage3, isRoamable)) {
                    return true;
                }
                Path additionalExportFile = null;
                Path file = null;
                try {
                    Path path;
                    StateStorageManager storageManager$iv = this.$storageManager;
                    boolean $i$f$getAdditionalExportFile = false;
                    String additionalExportPath$iv = stateAnnotation.additionalExportFile();
                    CharSequence charSequence = additionalExportPath$iv;
                    boolean bl2 = false;
                    if (charSequence.length() == 0) {
                        path = null;
                    } else {
                        Path additionalExportFile$iv = null;
                        additionalExportFile$iv = additionalExportPath$iv.charAt(0) == '$' ? Paths.get(storageManager$iv.expandMacros(additionalExportPath$iv), new String[0]) : Paths.get(storageManager$iv.expandMacros("$ROOT_CONFIG$"), additionalExportPath$iv);
                        Path path2 = additionalExportFile$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"additionalExportFile");
                        Path p1 = path2;
                        boolean bl3 = false;
                        path = this.$isSkipFile$1.invoke(p1) ? null : additionalExportFile$iv;
                    }
                    additionalExportFile = path;
                    Path path3 = Paths.get(this.$storageManager.expandMacros(StateStorageManagerImplKt.getPath(storage3)), new String[0]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"Paths.get(storageManager\u2026pandMacros(storage.path))");
                    file = path3;
                }
                catch (UnknownMacroException e) {
                    ComponentStoreImplKt.getLOG().error("Cannot expand macro for component \"" + stateAnnotation.name() + '\"', (Throwable)e);
                    return true;
                }
                boolean bl4 = isFileIncluded = !this.$isSkipFile$1.invoke(file);
                if (isFileIncluded || additionalExportFile != null) {
                    String presentableName;
                    if (this.$isComputePresentableNames && this.$isOnlyExisting && additionalExportFile == null && StringsKt.endsWith$default((String)((Object)file.getFileName()).toString(), (String)".xml", (boolean)false, (int)2, null)) {
                        String content;
                        Object object;
                        Map $this$getOrPut$iv = (Map)this.$fileToContent;
                        boolean $i$f$getOrPut = false;
                        V value$iv = $this$getOrPut$iv.get(file);
                        if (value$iv == null) {
                            boolean bl5 = false;
                            String answer$iv = PathKt.readText((Path)file);
                            $this$getOrPut$iv.put(file, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        String string = content = (String)object;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"content");
                        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)("<component name=\"" + stateAnnotation.name() + '\"'), (boolean)false, (int)2, null)) {
                            return true;
                        }
                    }
                    String string = presentableName = this.$isComputePresentableNames ? ExportSettingsActionKt.access$getComponentPresentableName(stateAnnotation, aClass, pluginDescriptor) : "";
                    if (isFileIncluded) {
                        UtilKt.putValue((Map)this.$result, (Object)file, (Object)new ExportableItem(file, presentableName, storage3.roamingType()));
                    }
                    if (additionalExportFile != null) {
                        UtilKt.putValue((Map)this.$result, (Object)additionalExportFile, (Object)new ExportableItem(additionalExportFile, presentableName + " (schemes)", RoamingType.DEFAULT));
                    }
                }
                return true;
            }
            {
                this.$storageManager = stateStorageManager;
                this.$isSkipFile$1 = var2_2;
                this.$isComputePresentableNames = bl;
                this.$isOnlyExisting = bl2;
                this.$fileToContent = tHashMap;
                this.$result = linkedHashMap;
                super(2);
            }
        });
        SchemeManagerFactory schemeManagerFactory = SchemeManagerFactory.Companion.getInstance();
        if (schemeManagerFactory == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase");
        }
        ((SchemeManagerFactoryBase)schemeManagerFactory).process((Function1<? super SchemeManagerImpl<Scheme, Scheme>, Unit>)((Function1)new Function1<SchemeManagerImpl<Scheme, Scheme>, Unit>(storageManager2, result, $fun$isSkipFile$1){
            final /* synthetic */ StateStorageManager $storageManager;
            final /* synthetic */ LinkedHashMap $result;
            final /* synthetic */ getExportableComponentsMap.1 $isSkipFile$1;

            public final void invoke(@NotNull SchemeManagerImpl<Scheme, Scheme> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                if (it.getRoamingType() != RoamingType.DISABLED) {
                    Path file;
                    Character c = StringsKt.getOrNull((CharSequence)it.getFileSpec(), (int)0);
                    if (!(c != null && c.charValue() == '$' || this.$result.containsKey(file = Paths.get(this.$storageManager.expandMacros("$ROOT_CONFIG$"), it.getFileSpec())))) {
                        Path path = file;
                        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file");
                        if (!this.$isSkipFile$1.invoke(path)) {
                            Map map = this.$result;
                            String string = it.getPresentableName();
                            if (string == null) {
                                string = "";
                            }
                            UtilKt.putValue((Map)map, (Object)file, (Object)new ExportableItem(file, string, it.getRoamingType()));
                        }
                    }
                }
            }
            {
                this.$storageManager = stateStorageManager;
                this.$result = linkedHashMap;
                this.$isSkipFile$1 = var3_3;
                super(1);
            }
        }));
        return result;
    }

    public static /* synthetic */ Map getExportableComponentsMap$default(boolean bl, boolean bl2, StateStorageManager stateStorageManager, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            stateStorageManager = ServiceKt.getStateStore((ComponentManager)((ComponentManager)application)).getStorageManager();
        }
        if ((n & 8) != 0) {
            set = null;
        }
        return ExportSettingsActionKt.getExportableComponentsMap(bl, bl2, stateStorageManager, set);
    }

    private static final Path getAdditionalExportFile(State stateAnnotation, StateStorageManager storageManager2, Function1<? super Path, Boolean> isSkipFile) {
        int $i$f$getAdditionalExportFile = 0;
        String additionalExportPath = stateAnnotation.additionalExportFile();
        CharSequence charSequence = additionalExportPath;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return null;
        }
        Path additionalExportFile = null;
        additionalExportFile = additionalExportPath.charAt(0) == '$' ? Paths.get(storageManager2.expandMacros(additionalExportPath), new String[0]) : Paths.get(storageManager2.expandMacros("$ROOT_CONFIG$"), additionalExportPath);
        Path path = additionalExportFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"additionalExportFile");
        return (Boolean)isSkipFile.invoke((Object)path) != false ? null : additionalExportFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isStorageExportable(Storage storage2, boolean isRoamable) {
        if (storage2.exportable()) return true;
        if (!isRoamable) return false;
        if (!Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass((Class)storage2.storageClass()), (Object)Reflection.getOrCreateKotlinClass(StateStorage.class))) return false;
        CharSequence charSequence = StateStorageManagerImplKt.getPath(storage2);
        boolean bl = false;
        if (charSequence.length() <= 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String getComponentPresentableName(State state, Class<?> aClass, PluginDescriptor pluginDescriptor) {
        String message;
        Object classLoader;
        Object object;
        Class presentableName = state.presentableName();
        if (Intrinsics.areEqual((Object)presentableName, State.NameGetter.class) ^ true) {
            try {
                Object object2 = ((State.NameGetter)ReflectionUtil.newInstance((Class)presentableName)).get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"ReflectionUtil.newInstance(presentableName).get()");
                return (String)object2;
            }
            catch (Exception e) {
                ComponentStoreImplKt.getLOG().error((Throwable)e);
            }
        }
        String defaultName = state.name();
        Function0<String> $fun$trimDefaultName$1 = new Function0<String>(defaultName){
            final /* synthetic */ String $defaultName;

            @NotNull
            public final String invoke() {
                return StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)this.$defaultName, (CharSequence)".Settings"), (CharSequence)".Settings");
            }
            {
                this.$defaultName = string;
                super(0);
            }
        };
        String resourceBundleName = null;
        if (pluginDescriptor != null && Intrinsics.areEqual((Object)PluginManagerCore.CORE_ID, (Object)pluginDescriptor.getPluginId()) ^ true) {
            resourceBundleName = pluginDescriptor.getResourceBundleBaseName();
            if (resourceBundleName == null) {
                if (!Intrinsics.areEqual((Object)pluginDescriptor.getVendor(), (Object)"JetBrains")) return $fun$trimDefaultName$1.invoke();
                resourceBundleName = "messages.OptionsBundle";
            }
        } else {
            resourceBundleName = "messages.OptionsBundle";
        }
        if ((object = pluginDescriptor) == null || (object = object.getPluginClassLoader()) == null) {
            object = classLoader = aClass.getClassLoader();
        }
        if (classLoader == null || (message = ExportSettingsActionKt.messageOrDefault((ClassLoader)classLoader, resourceBundleName, defaultName)) == defaultName) return $fun$trimDefaultName$1.invoke();
        return message;
    }

    private static final String messageOrDefault(ClassLoader classLoader, String bundleName, String defaultName) {
        try {
            String string = AbstractBundle.messageOrDefault((ResourceBundle)DynamicBundle.INSTANCE.getResourceBundle(bundleName, classLoader), (String)("exportable." + defaultName + ".presentable.name"), (String)defaultName, (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"AbstractBundle.messageOr\u2026table.name\", defaultName)");
            return string;
        }
        catch (MissingResourceException e) {
            ComponentStoreImplKt.getLOG().warn("Missing bundle " + bundleName + " at " + classLoader + ": " + e.getMessage());
            return defaultName;
        }
    }

    public static final /* synthetic */ boolean access$isStorageExportable(Storage storage2, boolean isRoamable) {
        return ExportSettingsActionKt.isStorageExportable(storage2, isRoamable);
    }

    public static final /* synthetic */ Path access$getAdditionalExportFile(State stateAnnotation, StateStorageManager storageManager2, Function1 isSkipFile) {
        return ExportSettingsActionKt.getAdditionalExportFile(stateAnnotation, storageManager2, (Function1<? super Path, Boolean>)isSkipFile);
    }

    public static final /* synthetic */ String access$getComponentPresentableName(State state, Class aClass, PluginDescriptor pluginDescriptor) {
        return ExportSettingsActionKt.getComponentPresentableName(state, aClass, pluginDescriptor);
    }
}

