/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.util.ArrayFormatter;
import org.fest.util.Preconditions;

public class Arrays {
    private static final ArrayFormatter FORMATTER = new ArrayFormatter();

    private Arrays() {
    }

    public static boolean isArray(@Nullable Object o) {
        return o != null && o.getClass().isArray();
    }

    public static <T> boolean isNullOrEmpty(@Nullable T[] array) {
        return array == null || !Arrays.hasElements(array);
    }

    @Nonnull
    public static <T> T[] array(T ... values) {
        return Preconditions.checkNotNull(values);
    }

    @Nullable
    public static String format(@Nullable Object array) {
        return FORMATTER.format(array);
    }

    public static <T> List<T> nonNullElementsIn(@Nonnull T[] array) {
        Preconditions.checkNotNull(array);
        ArrayList<T> nonNullElements = new ArrayList<T>();
        for (T o : array) {
            if (o == null) continue;
            nonNullElements.add(o);
        }
        return nonNullElements;
    }

    public static <T> boolean hasOnlyNullElements(@Nonnull T[] array) {
        Preconditions.checkNotNull(array);
        if (!Arrays.hasElements(array)) {
            return false;
        }
        for (T o : array) {
            if (o == null) continue;
            return false;
        }
        return true;
    }

    private static <T> boolean hasElements(@Nonnull T[] array) {
        return array.length > 0;
    }
}

