/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.CredentialStoreBundle;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.EncryptionSpec;
import com.intellij.credentialStore.EncryptionSupportKt;
import com.intellij.credentialStore.EncryptionType;
import com.intellij.credentialStore.MacOsKeychainLibraryKt;
import com.intellij.credentialStore.PasswordSafeConfigurableKt;
import com.intellij.credentialStore.PasswordSafeConfigurableUi;
import com.intellij.credentialStore.PasswordSafeConfigurableUi$WhenMappings;
import com.intellij.credentialStore.PasswordSafeConfigurableUi$getComponent$;
import com.intellij.credentialStore.PasswordSafeConfigurableUi$getComponent$1$2;
import com.intellij.credentialStore.PasswordSafeSettings;
import com.intellij.credentialStore.ProviderType;
import com.intellij.credentialStore.gpg.Pgp;
import com.intellij.credentialStore.gpg.PgpKey;
import com.intellij.credentialStore.kdbx.IncorrectMasterPasswordException;
import com.intellij.credentialStore.keePass.KeePassCredentialStoreKt;
import com.intellij.credentialStore.keePass.KeePassFileManager;
import com.intellij.credentialStore.keePass.MasterKeyFileStorage;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImpl;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImplKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.CellBuilder;
import com.intellij.ui.layout.CellKt;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.ui.layout.GrowPolicy;
import com.intellij.ui.layout.InnerCell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutBuilderKt;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.PropertyBinding;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import com.intellij.ui.layout.RowBuilderWithButtonGroupProperty;
import com.intellij.util.io.PathKt;
import com.intellij.util.text.StringKt;
import java.awt.Container;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003/01B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0003\u001a\u00020\u0002H\u0002J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0002J\n\u0010$\u001a\u0004\u0018\u00010%H\u0002J\n\u0010&\u001a\u0004\u0018\u00010'H\u0002J\n\u0010(\u001a\u0004\u0018\u00010\u0013H\u0002J\n\u0010)\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u0003\u001a\u00020\u0002H\u0002J\u0010\u0010,\u001a\u00020+2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016J\u0010\u0010-\u001a\u00020\u001c2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016J\b\u0010.\u001a\u00020'H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/credentialStore/PasswordSafeConfigurableUi;", "Lcom/intellij/openapi/options/ConfigurableUi;", "Lcom/intellij/credentialStore/PasswordSafeSettings;", "settings", "(Lcom/intellij/credentialStore/PasswordSafeSettings;)V", "keePassDbFile", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "keepassRadioButton", "Ljavax/swing/JRadioButton;", "myPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "pgp", "Lcom/intellij/credentialStore/gpg/Pgp;", "getPgp", "()Lcom/intellij/credentialStore/gpg/Pgp;", "pgp$delegate", "Lkotlin/Lazy;", "pgpKeyCombo", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/credentialStore/gpg/PgpKey;", "pgpListModel", "Lcom/intellij/ui/CollectionComboBoxModel;", "secureRandom", "Lkotlin/Lazy;", "Ljava/security/SecureRandom;", "usePgpKey", "Ljavax/swing/JCheckBox;", "apply", "", "createAndSaveKeePassDatabaseWithNewOptions", "createKeePassFileManager", "Lcom/intellij/credentialStore/keePass/KeePassFileManager;", "getComponent", "Ljavax/swing/JPanel;", "getEncryptionSpec", "Lcom/intellij/credentialStore/EncryptionSpec;", "getNewDbFile", "Ljava/nio/file/Path;", "getNewDbFileAsString", "", "getNewPgpKey", "getSelectedPgpKey", "isKeepassFileLocationChanged", "", "isModified", "reset", "usePgpKeyText", "ChangeKeePassDatabaseMasterPasswordAction", "ClearKeePassDatabaseAction", "ImportKeePassDatabaseAction", "intellij.platform.credentialStore"})
public final class PasswordSafeConfigurableUi
implements ConfigurableUi<PasswordSafeSettings> {
    private DialogPanel myPanel;
    private JCheckBox usePgpKey;
    private ComboBox<PgpKey> pgpKeyCombo;
    private JRadioButton keepassRadioButton;
    private TextFieldWithBrowseButton keePassDbFile;
    private final CollectionComboBoxModel<PgpKey> pgpListModel;
    private final Lazy pgp$delegate;
    private final Lazy<SecureRandom> secureRandom;
    private final PasswordSafeSettings settings;

    private final Pgp getPgp() {
        Lazy lazy = this.pgp$delegate;
        PasswordSafeConfigurableUi passwordSafeConfigurableUi = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Pgp)lazy.getValue();
    }

    public void reset(@NotNull PasswordSafeSettings settings) {
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
            List<PgpKey> secretKeys = this.getPgp().listKeys();
            this.pgpListModel.replaceAll(secretKeys);
            JCheckBox jCheckBox = this.usePgpKey;
            if (jCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"usePgpKey");
            }
            jCheckBox.setText(this.usePgpKeyText());
            DialogPanel dialogPanel = this.myPanel;
            if (dialogPanel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myPanel");
            }
            dialogPanel.reset();
            TextFieldWithBrowseButton textFieldWithBrowseButton = this.keePassDbFile;
            if (textFieldWithBrowseButton == null) break block3;
            String string = settings.getKeepassDb();
            if (string == null) {
                string = ((Object)PasswordSafeImplKt.getDefaultKeePassDbFile()).toString();
            }
            textFieldWithBrowseButton.setText(string);
        }
    }

    public boolean isModified(@NotNull PasswordSafeSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        DialogPanel dialogPanel = this.myPanel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myPanel");
        }
        if (dialogPanel.isModified()) {
            return true;
        }
        if (this.keePassDbFile == null) {
            return false;
        }
        return this.isKeepassFileLocationChanged(settings);
    }

    private final boolean isKeepassFileLocationChanged(PasswordSafeSettings settings) {
        JRadioButton jRadioButton = this.keepassRadioButton;
        if (jRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"keepassRadioButton");
        }
        return jRadioButton.isSelected() && Intrinsics.areEqual((Object)this.getNewDbFileAsString(), (Object)settings.getKeepassDb()) ^ true;
    }

    public void apply(@NotNull PasswordSafeSettings settings) {
        ProviderType providerType;
        block23: {
            boolean pgpKeyChanged;
            block24: {
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                PgpKey pgpKey = this.getNewPgpKey();
                pgpKeyChanged = Intrinsics.areEqual((Object)(pgpKey != null ? pgpKey.getKeyId() : null), (Object)this.settings.getState().getPgpKeyId()) ^ true;
                ProviderType oldProviderType = this.settings.getProviderType();
                DialogPanel dialogPanel = this.myPanel;
                if (dialogPanel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myPanel");
                }
                dialogPanel.apply();
                providerType = this.settings.getProviderType();
                PasswordSafe passwordSafe = PasswordSafe.Companion.getInstance();
                if (passwordSafe == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.ide.passwordSafe.impl.PasswordSafeImpl");
                }
                ((PasswordSafeImpl)passwordSafe).closeCurrentStore$intellij_platform_credentialStore(false, providerType != ProviderType.MEMORY_ONLY);
                PasswordSafe passwordSafe2 = PasswordSafe.Companion.getInstance();
                if (passwordSafe2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.ide.passwordSafe.impl.PasswordSafeImpl");
                }
                PasswordSafeImpl passwordSafe3 = (PasswordSafeImpl)passwordSafe2;
                if (oldProviderType == providerType) break block24;
                switch (PasswordSafeConfigurableUi$WhenMappings.$EnumSwitchMapping$0[providerType.ordinal()]) {
                    case 1: {
                        break block23;
                    }
                    case 2: {
                        try {
                            CredentialStore store = PasswordSafeImplKt.createPersistentCredentialStore();
                            if (store == null) {
                                throw (Throwable)new ConfigurationException(IdeBundle.message((String)"settings.password.internal.error.no.available.credential.store.implementation", (Object[])new Object[0]));
                            }
                            passwordSafe3.setCurrentProvider$intellij_platform_credentialStore(store);
                            Unit unit = Unit.INSTANCE;
                            break block23;
                        }
                        catch (UnsatisfiedLinkError e) {
                            CredentialStoreKt.getLOG().warn((Throwable)e);
                            if (SystemInfo.isLinux) {
                                throw (Throwable)new ConfigurationException(IdeBundle.message((String)"settings.password.package.libsecret.1.0.is.not.installed", (Object[])new Object[0]));
                            }
                            throw (Throwable)new ConfigurationException(e.getMessage());
                        }
                    }
                    case 3: {
                        this.createAndSaveKeePassDatabaseWithNewOptions(settings);
                        break block23;
                    }
                    default: {
                        throw (Throwable)new ConfigurationException(IdeBundle.message((String)"settings.password.unknown.provider.type", (Object[])new Object[]{providerType}));
                    }
                }
            }
            if (this.isKeepassFileLocationChanged(settings)) {
                this.createAndSaveKeePassDatabaseWithNewOptions(settings);
            } else if (providerType == ProviderType.KEEPASS && pgpKeyChanged) {
                try {
                    Unit unit;
                    KeePassFileManager keePassFileManager = this.createKeePassFileManager();
                    if (keePassFileManager != null) {
                        keePassFileManager.saveMasterKeyToApplyNewEncryptionSpec();
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    Unit unit2 = unit;
                }
                catch (ConfigurationException e) {
                    throw (Throwable)e;
                }
                catch (Exception e) {
                    CredentialStoreKt.getLOG().error((Throwable)e);
                    Object[] objectArray = new Object[1];
                    String string = e.getMessage();
                    if (string == null) {
                        string = e.toString();
                    }
                    objectArray[0] = string;
                    throw (Throwable)new ConfigurationException(CredentialStoreBundle.INSTANCE.message("settings.password.internal.error", objectArray));
                }
            }
        }
        if (providerType == ProviderType.KEEPASS) {
            KeePassFileManager keePassFileManager = this.createKeePassFileManager();
            if (keePassFileManager != null) {
                Path path = PasswordSafeImplKt.getDefaultKeePassDbFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"getDefaultKeePassDbFile()");
                keePassFileManager.setCustomMasterPasswordIfNeeded(path);
            }
        }
        settings.setProviderType(providerType);
    }

    private final void createAndSaveKeePassDatabaseWithNewOptions(PasswordSafeSettings settings) {
        Path path = this.getNewDbFile();
        if (path == null) {
            throw (Throwable)new ConfigurationException(CredentialStoreBundle.INSTANCE.message("settings.password.keepass.database.path.is.empty", new Object[0]));
        }
        Path newDbFile = path;
        if (PathKt.isDirectory((Path)newDbFile)) {
            throw (Throwable)new ConfigurationException(CredentialStoreBundle.INSTANCE.message("settings.password.keepass.database.file.is.directory.", new Object[0]));
        }
        if (!StringsKt.endsWith$default((String)((Object)newDbFile.getFileName()).toString(), (String)".kdbx", (boolean)false, (int)2, null)) {
            throw (Throwable)new ConfigurationException(CredentialStoreBundle.INSTANCE.message("settings.password.keepass.database.file.should.ends.with.kdbx", new Object[0]));
        }
        settings.setKeepassDb(((Object)newDbFile).toString());
        try {
            Path path2 = KeePassCredentialStoreKt.getDefaultMasterPasswordFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"getDefaultMasterPasswordFile()");
            new KeePassFileManager(newDbFile, path2, this.getEncryptionSpec(), this.secureRandom).useExisting();
        }
        catch (IncorrectMasterPasswordException e) {
            throw (Throwable)new ConfigurationException(CredentialStoreBundle.INSTANCE.message("settings.password.master.password.for.keepass.database.is.not.correct", new Object[0]));
        }
        catch (Exception e) {
            CredentialStoreKt.getLOG().error((Throwable)e);
            Object[] objectArray = new Object[1];
            String string = e.getMessage();
            if (string == null) {
                string = e.toString();
            }
            objectArray[0] = string;
            throw (Throwable)new ConfigurationException(CredentialStoreBundle.INSTANCE.message("settings.password.internal.error", objectArray));
        }
    }

    private final Path getNewDbFile() {
        Path path;
        String string = this.getNewDbFileAsString();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            path = Paths.get(it, new String[0]);
        } else {
            path = null;
        }
        return path;
    }

    private final String getNewDbFileAsString() {
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.keePassDbFile;
        if (textFieldWithBrowseButton == null) {
            Intrinsics.throwNpe();
        }
        String string = textFieldWithBrowseButton.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"keePassDbFile!!.text");
        String string2 = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return StringKt.nullize$default((String)((Object)StringsKt.trim((CharSequence)string3)).toString(), (boolean)false, (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public JPanel getComponent() {
        DialogPanel dialogPanel;
        void constraints$iv;
        void $this$buttonGroup$iv$iv;
        void $this$buttonGroup$iv;
        LayoutBuilder builder$iv;
        LCFlags[] lCFlagsArray = new LCFlags[]{};
        PasswordSafeConfigurableUi passwordSafeConfigurableUi = this;
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder $this$panel = builder$iv = LayoutImplKt.createLayoutBuilder();
        boolean bl = false;
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, null, (boolean)false, (Function1)getComponent.1.1.INSTANCE, (int)3, null);
        RowBuilder rowBuilder = (RowBuilder)$this$panel;
        PasswordSafeConfigurableUi$getComponent$1$2 prop$iv = new PasswordSafeConfigurableUi$getComponent$1$2(this.settings);
        boolean $i$f$buttonGroup = false;
        void var10_11 = $this$buttonGroup$iv;
        PasswordSafeConfigurableUi$getComponent$1$2 $this$toBinding$iv$iv = prop$iv;
        boolean $i$f$toBinding = false;
        Class<ProviderType> clazz = JvmClassMappingKt.getJavaPrimitiveType((KClass)Reflection.getOrCreateKotlinClass(ProviderType.class));
        if (clazz == null) {
            clazz = ProviderType.class;
        }
        PropertyBinding binding$iv$iv = CellKt.createPropertyBinding((KMutableProperty0)$this$toBinding$iv$iv, (Class)clazz);
        boolean $i$f$buttonGroup2 = false;
        $this$buttonGroup$iv$iv.withButtonGroup(new ButtonGroup(), (Function0)new Function0<Unit>((RowBuilder)$this$buttonGroup$iv$iv, binding$iv$iv, this){
            final /* synthetic */ RowBuilder $this_buttonGroup;
            final /* synthetic */ PropertyBinding $binding;
            final /* synthetic */ PasswordSafeConfigurableUi this$0;
            {
                this.$this_buttonGroup = rowBuilder;
                this.$binding = propertyBinding;
                this.this$0 = passwordSafeConfigurableUi;
                super(0);
            }

            public final void invoke() {
                RowBuilderWithButtonGroupProperty $this$buttonGroup = new RowBuilderWithButtonGroupProperty(this.$this_buttonGroup, this.$binding);
                boolean bl = false;
                if (SystemInfo.isLinux || MacOsKeychainLibraryKt.isMacOsCredentialStoreSupported()) {
                    RowBuilder.DefaultImpls.row$default((RowBuilder)$this$buttonGroup, null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>($this$buttonGroup){
                        final /* synthetic */ RowBuilderWithButtonGroupProperty $this_buttonGroup;
                        {
                            this.$this_buttonGroup = rowBuilderWithButtonGroupProperty;
                            super(1);
                        }

                        public final void invoke(@NotNull Row $this$row) {
                            Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                            RowBuilderWithButtonGroupProperty.radioButton$default((RowBuilderWithButtonGroupProperty)this.$this_buttonGroup, (Row)$this$row, (String)CredentialStoreBundle.INSTANCE.message("passwordSafeConfigurable.in.native.keychain", new Object[0]), (Object)((Object)ProviderType.KEYCHAIN), null, (int)4, null);
                        }
                    }), (int)3, null);
                }
                RowBuilder.DefaultImpls.row$default((RowBuilder)$this$buttonGroup, null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>($this$buttonGroup, this){
                    final /* synthetic */ RowBuilderWithButtonGroupProperty $this_buttonGroup;
                    final /* synthetic */ getComponent$$inlined$panel$lambda$1 this$0;
                    {
                        this.$this_buttonGroup = rowBuilderWithButtonGroupProperty;
                        this.this$0 = var2_2;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                        PasswordSafeConfigurableUi.access$setKeepassRadioButton$p(this.this$0.this$0, (JRadioButton)RowBuilderWithButtonGroupProperty.radioButton$default((RowBuilderWithButtonGroupProperty)this.$this_buttonGroup, (Row)$this$row, (String)CredentialStoreBundle.INSTANCE.message("passwordSafeConfigurable.in.keepass", new Object[0]), (Object)((Object)ProviderType.KEEPASS), null, (int)4, null).getComponent());
                        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$row, (String)CredentialStoreBundle.INSTANCE.message("settings.password.database", new Object[0]), (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
                            final /* synthetic */ getComponent$$inlined$panel$lambda$1$2 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                                FileChooserDescriptor fileChooserDescriptor2 = FileChooserDescriptorFactory.createSingleLocalFileDescriptor().withFileFilter((Condition)getComponent.1.3.fileChooserDescriptor.1.INSTANCE);
                                PasswordSafeConfigurableUi passwordSafeConfigurableUi = this.this$0.this$0.this$0;
                                String string = CredentialStoreBundle.INSTANCE.message("passwordSafeConfigurable.keepass.database.file", new Object[0]);
                                FileChooserDescriptor fileChooserDescriptor3 = fileChooserDescriptor2;
                                Intrinsics.checkExpressionValueIsNotNull((Object)fileChooserDescriptor3, (String)"fileChooserDescriptor");
                                CellBuilder cellBuilder = Cell.textFieldWithBrowseButton$default((Cell)$this$row, (String)string, null, null, (FileChooserDescriptor)fileChooserDescriptor3, (Function1)getComponent.1.3.1.INSTANCE, (int)6, null);
                                PasswordSafeConfigurableUi passwordSafeConfigurableUi2 = passwordSafeConfigurableUi;
                                boolean bl = false;
                                boolean bl2 = false;
                                CellBuilder $this$apply = cellBuilder;
                                boolean bl3 = false;
                                if (!SystemInfo.isWindows) {
                                    CellBuilder.DefaultImpls.comment$default((CellBuilder)$this$apply, (String)CredentialStoreBundle.INSTANCE.message("passwordSafeConfigurable.weak.encryption", new Object[0]), (int)0, (int)2, null);
                                }
                                CellBuilder cellBuilder2 = cellBuilder;
                                PasswordSafeConfigurableUi.access$setKeePassDbFile$p(passwordSafeConfigurableUi2, (TextFieldWithBrowseButton)cellBuilder2.getComponent());
                                $this$row.gearButton(new AnAction[]{(AnAction)this.this$0.this$0.this$0.new ClearKeePassDatabaseAction(), (AnAction)this.this$0.this$0.this$0.new ImportKeePassDatabaseAction(), (AnAction)this.this$0.this$0.this$0.new ChangeKeePassDatabaseMasterPasswordAction()});
                            }
                        }), (int)2, null);
                        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$row, null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
                            final /* synthetic */ getComponent$$inlined$panel$lambda$1$2 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                                Row this_$iv = $this$row;
                                boolean isVerticalFlow$iv = false;
                                boolean isFullWidth$iv = false;
                                boolean $i$f$cell = false;
                                this_$iv.setCellMode(true, isVerticalFlow$iv, isFullWidth$iv);
                                InnerCell $this$cell = new InnerCell((Cell)this_$iv);
                                boolean bl = false;
                                PasswordSafeConfigurableUi.access$setUsePgpKey$p(this.this$0.this$0.this$0, (JCheckBox)Cell.checkBox$default((Cell)$this$cell, (String)PasswordSafeConfigurableUi.access$usePgpKeyText(this.this$0.this$0.this$0), (Function0)((Function0)new Function0<Boolean>(this){
                                    final /* synthetic */ getComponent$$inlined$panel$lambda$1$2$2 this$0;
                                    {
                                        this.this$0 = var1_1;
                                        super(0);
                                    }

                                    public final boolean invoke() {
                                        return !PasswordSafeConfigurableUi.access$getPgpListModel$p(this.this$0.this$0.this$0.this$0).isEmpty() && PasswordSafeConfigurableUi.access$getSettings$p(this.this$0.this$0.this$0.this$0).getState().getPgpKeyId() != null;
                                    }
                                }), (Function1)((Function1)new Function1<Boolean, Unit>(this){
                                    final /* synthetic */ getComponent$$inlined$panel$lambda$1$2$2 this$0;
                                    {
                                        this.this$0 = var1_1;
                                        super(1);
                                    }

                                    public final void invoke(boolean it) {
                                        if (!it) {
                                            PasswordSafeConfigurableUi.access$getSettings$p(this.this$0.this$0.this$0.this$0).getState().setPgpKeyId(null);
                                        }
                                    }
                                }), null, (int)8, null).getComponent());
                                PasswordSafeConfigurableUi.access$setPgpKeyCombo$p(this.this$0.this$0.this$0, (ComboBox)$this$cell.comboBox((ComboBoxModel)PasswordSafeConfigurableUi.access$getPgpListModel$p(this.this$0.this$0.this$0), (Function0)new Function0<PgpKey>(this){
                                    final /* synthetic */ getComponent$$inlined$panel$lambda$1$2$2 this$0;
                                    {
                                        this.this$0 = var1_1;
                                        super(0);
                                    }

                                    @Nullable
                                    public final PgpKey invoke() {
                                        PgpKey pgpKey = PasswordSafeConfigurableUi.access$getSelectedPgpKey(this.this$0.this$0.this$0.this$0);
                                        if (pgpKey == null) {
                                            List list = PasswordSafeConfigurableUi.access$getPgpListModel$p(this.this$0.this$0.this$0.this$0).getItems();
                                            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"pgpListModel.items");
                                            pgpKey = (PgpKey)CollectionsKt.firstOrNull((List)list);
                                        }
                                        return pgpKey;
                                    }
                                }, (Function1)new Function1<PgpKey, Unit>(this){
                                    final /* synthetic */ getComponent$$inlined$panel$lambda$1$2$2 this$0;
                                    {
                                        this.this$0 = var1_1;
                                        super(1);
                                    }

                                    public final void invoke(@Nullable PgpKey it) {
                                        String string;
                                        PasswordSafeSettings.PasswordSafeOptions passwordSafeOptions = PasswordSafeConfigurableUi.access$getSettings$p(this.this$0.this$0.this$0.this$0).getState();
                                        if (PasswordSafeConfigurableUi.access$getUsePgpKey$p(this.this$0.this$0.this$0.this$0).isSelected()) {
                                            PgpKey pgpKey = it;
                                            string = pgpKey != null ? pgpKey.getKeyId() : null;
                                        } else {
                                            string = null;
                                        }
                                        passwordSafeOptions.setPgpKeyId(string);
                                    }
                                }, (ListCellRenderer)CellKt.listCellRenderer((Function4)getComponent.1.3.2.1.5.INSTANCE)).growPolicy(GrowPolicy.MEDIUM_TEXT).enableIf(ComponentPredicateKt.getSelected((AbstractButton)PasswordSafeConfigurableUi.access$getUsePgpKey$p(this.this$0.this$0.this$0))).getComponent());
                                this_$iv.setCellMode(false, isVerticalFlow$iv, isFullWidth$iv);
                            }
                        }), (int)3, null);
                    }
                }), (int)3, null);
                RowBuilder.DefaultImpls.row$default((RowBuilder)$this$buttonGroup, null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>($this$buttonGroup){
                    final /* synthetic */ RowBuilderWithButtonGroupProperty $this_buttonGroup;
                    {
                        this.$this_buttonGroup = rowBuilderWithButtonGroupProperty;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                        RowBuilderWithButtonGroupProperty.radioButton$default((RowBuilderWithButtonGroupProperty)this.$this_buttonGroup, (Row)$this$row, (String)CredentialStoreBundle.INSTANCE.message("passwordSafeConfigurable.do.not.save", new Object[0]), (Object)((Object)ProviderType.MEMORY_ONLY), null, (int)4, null);
                    }
                }), (int)3, null);
            }
        });
        DialogPanel panel$iv = ComponentsKt.DialogPanel((String)title$iv, null);
        builder$iv.getBuilder().build((Container)panel$iv, (LCFlags[])constraints$iv);
        LayoutKt.initPanel((LayoutBuilder)builder$iv, (DialogPanel)panel$iv);
        passwordSafeConfigurableUi.myPanel = dialogPanel = panel$iv;
        DialogPanel dialogPanel2 = this.myPanel;
        if (dialogPanel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myPanel");
        }
        return (JPanel)dialogPanel2;
    }

    private final String usePgpKeyText() {
        String prefix = CredentialStoreBundle.INSTANCE.message("passwordSafeConfigurable.protect.master.password.using.pgp.key", new Object[0]);
        return this.pgpListModel.isEmpty() ? prefix + ' ' + CredentialStoreBundle.INSTANCE.message("passwordSafeConfigurable.no.keys.configured", new Object[0]) : prefix + ':';
    }

    private final PgpKey getSelectedPgpKey() {
        PgpKey pgpKey;
        Object v2;
        block3: {
            String string = this.settings.getState().getPgpKeyId();
            if (string == null) {
                return null;
            }
            String currentKeyId = string;
            List list = this.pgpListModel.getItems();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"pgpListModel.items");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PgpKey it = (PgpKey)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getKeyId(), (Object)currentKeyId)) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        if ((pgpKey = (PgpKey)v2) == null) {
            List list = this.pgpListModel.getItems();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"pgpListModel.items");
            pgpKey = (PgpKey)CollectionsKt.firstOrNull((List)list);
        }
        return pgpKey;
    }

    private final KeePassFileManager createKeePassFileManager() {
        Path path = this.getNewDbFile();
        if (path == null) {
            return null;
        }
        Path path2 = KeePassCredentialStoreKt.getDefaultMasterPasswordFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"getDefaultMasterPasswordFile()");
        return new KeePassFileManager(path, path2, this.getEncryptionSpec(), this.secureRandom);
    }

    private final EncryptionSpec getEncryptionSpec() {
        PgpKey pgpKey = this.getNewPgpKey();
        return pgpKey == null ? new EncryptionSpec(EncryptionSupportKt.getDefaultEncryptionType(), null) : new EncryptionSpec(EncryptionType.PGP_KEY, pgpKey.getKeyId());
    }

    private final PgpKey getNewPgpKey() {
        Object object;
        ComboBox<PgpKey> comboBox = this.pgpKeyCombo;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pgpKeyCombo");
        }
        if (!((object = comboBox.getSelectedItem()) instanceof PgpKey)) {
            object = null;
        }
        return (PgpKey)object;
    }

    public PasswordSafeConfigurableUi(@NotNull PasswordSafeSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        this.settings = settings;
        this.pgpListModel = new CollectionComboBoxModel();
        this.pgp$delegate = LazyKt.lazy((Function0)pgp.2.INSTANCE);
        this.secureRandom = LazyKt.lazy((Function0)secureRandom.1.INSTANCE);
    }

    public static final /* synthetic */ JRadioButton access$getKeepassRadioButton$p(PasswordSafeConfigurableUi $this) {
        JRadioButton jRadioButton = $this.keepassRadioButton;
        if (jRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"keepassRadioButton");
        }
        return jRadioButton;
    }

    public static final /* synthetic */ void access$setKeepassRadioButton$p(PasswordSafeConfigurableUi $this, JRadioButton jRadioButton) {
        $this.keepassRadioButton = jRadioButton;
    }

    public static final /* synthetic */ TextFieldWithBrowseButton access$getKeePassDbFile$p(PasswordSafeConfigurableUi $this) {
        return $this.keePassDbFile;
    }

    public static final /* synthetic */ void access$setKeePassDbFile$p(PasswordSafeConfigurableUi $this, TextFieldWithBrowseButton textFieldWithBrowseButton) {
        $this.keePassDbFile = textFieldWithBrowseButton;
    }

    public static final /* synthetic */ JCheckBox access$getUsePgpKey$p(PasswordSafeConfigurableUi $this) {
        JCheckBox jCheckBox = $this.usePgpKey;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"usePgpKey");
        }
        return jCheckBox;
    }

    public static final /* synthetic */ void access$setUsePgpKey$p(PasswordSafeConfigurableUi $this, JCheckBox jCheckBox) {
        $this.usePgpKey = jCheckBox;
    }

    public static final /* synthetic */ String access$usePgpKeyText(PasswordSafeConfigurableUi $this) {
        return $this.usePgpKeyText();
    }

    public static final /* synthetic */ CollectionComboBoxModel access$getPgpListModel$p(PasswordSafeConfigurableUi $this) {
        return $this.pgpListModel;
    }

    public static final /* synthetic */ PasswordSafeSettings access$getSettings$p(PasswordSafeConfigurableUi $this) {
        return $this.settings;
    }

    public static final /* synthetic */ ComboBox access$getPgpKeyCombo$p(PasswordSafeConfigurableUi $this) {
        ComboBox<PgpKey> comboBox = $this.pgpKeyCombo;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pgpKeyCombo");
        }
        return comboBox;
    }

    public static final /* synthetic */ void access$setPgpKeyCombo$p(PasswordSafeConfigurableUi $this, ComboBox comboBox) {
        $this.pgpKeyCombo = comboBox;
    }

    public static final /* synthetic */ PgpKey access$getSelectedPgpKey(PasswordSafeConfigurableUi $this) {
        return $this.getSelectedPgpKey();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/credentialStore/PasswordSafeConfigurableUi$ClearKeePassDatabaseAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "(Lcom/intellij/credentialStore/PasswordSafeConfigurableUi;)V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "e", "intellij.platform.credentialStore"})
    private final class ClearKeePassDatabaseAction
    extends DumbAwareAction {
        public void actionPerformed(@NotNull AnActionEvent event) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                MessageDialogBuilder messageDialogBuilder = MessageDialogBuilder.yesNo((String)CredentialStoreBundle.INSTANCE.message("passwordSafeConfigurable.clear.passwords", new Object[0]), (String)CredentialStoreBundle.INSTANCE.message("passwordSafeConfigurable.are.you.sure", new Object[0])).yesText(CredentialStoreBundle.INSTANCE.message("passwordSafeConfigurable.remove.passwords", new Object[0]));
                Intrinsics.checkExpressionValueIsNotNull((Object)messageDialogBuilder, (String)"MessageDialogBuilder.yes\u2026rable.remove.passwords\"))");
                if (!((MessageDialogBuilder.YesNo)messageDialogBuilder).isYes()) {
                    return;
                }
                PasswordSafeConfigurableKt.access$closeCurrentStore();
                CredentialStoreKt.getLOG().info("Passwords cleared", (Throwable)new Error());
                KeePassFileManager keePassFileManager = PasswordSafeConfigurableUi.this.createKeePassFileManager();
                if (keePassFileManager == null) break block1;
                keePassFileManager.clear();
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            Path path = PasswordSafeConfigurableUi.this.getNewDbFile();
            presentation.setEnabled(path != null ? PathKt.exists((Path)path) : false);
        }

        public ClearKeePassDatabaseAction() {
            super(CredentialStoreBundle.INSTANCE.message("action.text.password.safe.clear", new Object[0]));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/credentialStore/PasswordSafeConfigurableUi$ImportKeePassDatabaseAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "(Lcom/intellij/credentialStore/PasswordSafeConfigurableUi;)V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.credentialStore"})
    private final class ImportKeePassDatabaseAction
    extends DumbAwareAction {
        public void actionPerformed(@NotNull AnActionEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            PasswordSafeConfigurableKt.access$closeCurrentStore();
            FileChooserDescriptor fileChooserDescriptor2 = FileChooserDescriptorFactory.createSingleLocalFileDescriptor().withFileFilter((Condition)actionPerformed.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileChooserDescriptor2, (String)"FileChooserDescriptorFac\u2026dsWith(\".kdbx\")\n        }");
            LayoutBuilderKt.chooseFile((FileChooserDescriptor)fileChooserDescriptor2, (AnActionEvent)event, (Function1)((Function1)new Function1<VirtualFile, Unit>(this, event){
                final /* synthetic */ ImportKeePassDatabaseAction this$0;
                final /* synthetic */ AnActionEvent $event;

                public final void invoke(@NotNull VirtualFile it) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        KeePassFileManager keePassFileManager = PasswordSafeConfigurableUi.access$createKeePassFileManager(this.this$0.PasswordSafeConfigurableUi.this);
                        if (keePassFileManager == null) break block0;
                        Path path = Paths.get(it.getPath(), new String[0]);
                        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(it.path)");
                        keePassFileManager.import(path, this.$event);
                    }
                }
                {
                    this.this$0 = importKeePassDatabaseAction;
                    this.$event = anActionEvent;
                    super(1);
                }
            }));
        }

        public ImportKeePassDatabaseAction() {
            super(CredentialStoreBundle.INSTANCE.message("action.text.password.safe.import", new Object[0]));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/credentialStore/PasswordSafeConfigurableUi$ChangeKeePassDatabaseMasterPasswordAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "(Lcom/intellij/credentialStore/PasswordSafeConfigurableUi;)V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "e", "intellij.platform.credentialStore"})
    private final class ChangeKeePassDatabaseMasterPasswordAction
    extends DumbAwareAction {
        public void actionPerformed(@NotNull AnActionEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            PasswordSafeConfigurableKt.access$closeCurrentStore();
            KeePassFileManager keePassFileManager = PasswordSafeConfigurableUi.this.createKeePassFileManager();
            if (keePassFileManager != null) {
                if (KeePassFileManager.askAndSetMasterKey$default(keePassFileManager, event, null, 2, null)) {
                    Presentation presentation = this.getTemplatePresentation();
                    Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"templatePresentation");
                    presentation.setText(CredentialStoreBundle.INSTANCE.message("settings.password.change.master.password", new Object[0]));
                }
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setEnabled(PasswordSafeConfigurableUi.this.getNewDbFileAsString() != null);
        }

        public ChangeKeePassDatabaseMasterPasswordAction() {
            StringBuilder stringBuilder = new StringBuilder();
            Path path = KeePassCredentialStoreKt.getDefaultMasterPasswordFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"getDefaultMasterPasswordFile()");
            super(stringBuilder.append(new MasterKeyFileStorage(path).isAutoGenerated() ? "Set" : "Change").append(" Master Password").toString());
        }
    }
}

