/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.io.URLUtil;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

public abstract class Html5SchemaProvider {
    private static final Logger LOG = Logger.getInstance(Html5SchemaProvider.class);
    private static final NotNullLazyValue<String> HTML5_SCHEMA_LOCATION = AtomicNotNullLazyValue.createValue(() -> Html5SchemaProvider.loadLocation(Html5SchemaProvider.getInstance().getHtmlSchemaLocation(), "HTML5_SCHEMA"));
    private static final NotNullLazyValue<String> XHTML5_SCHEMA_LOCATION = AtomicNotNullLazyValue.createValue(() -> Html5SchemaProvider.loadLocation(Html5SchemaProvider.getInstance().getXhtmlSchemaLocation(), "XHTML5_SCHEMA"));
    private static final NotNullLazyValue<String> CHARS_DTD_LOCATION = AtomicNotNullLazyValue.createValue(() -> Html5SchemaProvider.loadLocation(Html5SchemaProvider.getInstance().getCharsLocation(), "CHARS_DTD"));

    private static String loadLocation(URL url, String id) {
        String location = VfsUtilCore.urlToPath((String)VfsUtilCore.fixURLforIDEA((String)URLUtil.unescapePercentSequences((String)url.toExternalForm())));
        LOG.info(id + "_LOCATION = " + HTML5_SCHEMA_LOCATION);
        return location;
    }

    public static String getHtml5SchemaLocation() {
        return (String)HTML5_SCHEMA_LOCATION.getValue();
    }

    public static String getXhtml5SchemaLocation() {
        return (String)XHTML5_SCHEMA_LOCATION.getValue();
    }

    public static String getCharsDtdLocation() {
        return (String)CHARS_DTD_LOCATION.getValue();
    }

    private static Html5SchemaProvider getInstance() {
        return (Html5SchemaProvider)ServiceManager.getService(Html5SchemaProvider.class);
    }

    @NotNull
    public abstract URL getHtmlSchemaLocation();

    @NotNull
    public abstract URL getXhtmlSchemaLocation();

    @NotNull
    public abstract URL getCharsLocation();
}

