/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.Queue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameXmlAttributeProcessor
extends RenamePsiElementProcessor {
    private static final Logger LOG = Logger.getInstance(RenameXmlAttributeProcessor.class);

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            RenameXmlAttributeProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof XmlAttribute || element instanceof XmlAttributeValue;
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, UsageInfo @NotNull [] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        if (element == null) {
            RenameXmlAttributeProcessor.$$$reportNull$$$0(1);
        }
        if (newName == null) {
            RenameXmlAttributeProcessor.$$$reportNull$$$0(2);
        }
        if (usages == null) {
            RenameXmlAttributeProcessor.$$$reportNull$$$0(3);
        }
        if (element instanceof XmlAttribute) {
            RenameXmlAttributeProcessor.doRenameXmlAttribute((XmlAttribute)element, newName, listener);
        } else if (element instanceof XmlAttributeValue) {
            RenameXmlAttributeProcessor.doRenameXmlAttributeValue((XmlAttributeValue)element, newName, usages, listener);
        }
    }

    private static void doRenameXmlAttribute(XmlAttribute attribute, String newName, @Nullable RefactoringElementListener listener) {
        try {
            PsiElement element = attribute.setName(newName);
            if (listener != null) {
                listener.elementRenamed(element);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void doRenameXmlAttributeValue(@NotNull XmlAttributeValue value, String newName, UsageInfo[] infos, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        if (value == null) {
            RenameXmlAttributeProcessor.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(value.isValid());
        RenameXmlAttributeProcessor.renameAll((PsiElement)value, infos, newName, value.getValue());
        PsiManager psiManager = value.getManager();
        LOG.assertTrue(psiManager != null);
        XmlFile file = (XmlFile)PsiFileFactory.getInstance((Project)psiManager.getProject()).createFileFromText("dummy.xml", (Language)XMLLanguage.INSTANCE, (CharSequence)("<a attr=\"" + newName + "\"/>"));
        PsiElement element = value.replace((PsiElement)file.getRootTag().getAttributes()[0].getValueElement());
        if (listener != null) {
            listener.elementRenamed(element);
        }
    }

    private static void renameAll(PsiElement originalElement, UsageInfo[] infos, String newName, String originalName) throws IncorrectOperationException {
        if (newName.equals(originalName)) {
            return;
        }
        Queue queue = new Queue(infos.length);
        for (UsageInfo info : infos) {
            PsiReference ref;
            if (info.getElement() == null || (ref = info.getReference()) == null) continue;
            queue.addLast((Object)ref);
        }
        while (!queue.isEmpty()) {
            PsiReference reference = (PsiReference)queue.pullFirst();
            PsiElement oldElement = reference.getElement();
            if (!oldElement.isValid() || oldElement == originalElement) continue;
            PsiElement newElement = reference.handleElementRename(newName);
            if (oldElement.isValid()) continue;
            for (PsiReference psiReference : ReferencesSearch.search((PsiElement)originalElement, (SearchScope)new LocalSearchScope(newElement), (boolean)false)) {
                queue.addLast((Object)psiReference);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/rename/RenameXmlAttributeProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "renameElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doRenameXmlAttributeValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

