/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.impl;

import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.OpenInBrowserRequestKt;
import com.intellij.ide.browsers.WebBrowserService;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.ide.browsers.impl.WebBrowserServiceImpl;
import com.intellij.ide.browsers.impl.WebBrowserServiceImplKt;
import com.intellij.ide.browsers.impl.WebBrowserServiceImplKt$sam$java_util_function_Predicate$0;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/browsers/impl/WebBrowserServiceImpl;", "Lcom/intellij/ide/browsers/WebBrowserService;", "()V", "getUrlsToOpen", "", "Lcom/intellij/util/Url;", "request", "Lcom/intellij/ide/browsers/OpenInBrowserRequest;", "preferLocalUrl", "", "Companion", "intellij.xml.impl"})
public final class WebBrowserServiceImpl
extends WebBrowserService {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Collection<Url> getUrlsToOpen(@NotNull OpenInBrowserRequest request, boolean preferLocalUrl) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        boolean isHtmlOrXml = WebBrowserService.isHtmlOrXmlFile((PsiFile)request.getFile());
        if (!preferLocalUrl || !isHtmlOrXml) {
            DumbService dumbService = DumbService.getInstance((Project)request.getProject());
            for (WebBrowserUrlProvider urlProvider : WebBrowserServiceImplKt.access$getURL_PROVIDER_EP$p().getExtensionList()) {
                Collection urls;
                DumbService dumbService2 = dumbService;
                Intrinsics.checkExpressionValueIsNotNull((Object)dumbService2, (String)"dumbService");
                if (dumbService2.isDumb() && !DumbService.isDumbAware((Object)urlProvider) || !urlProvider.canHandleElement(request) || (urls = WebBrowserServiceImplKt.access$getUrls(urlProvider, request)).isEmpty()) continue;
                return urls;
            }
            if (!isHtmlOrXml && !request.isForceFileUrlIfNoUrlProvider()) {
                return CollectionsKt.emptyList();
            }
        }
        FileViewProvider fileViewProvider = request.getFile().getViewProvider();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"request.file.viewProvider");
        VirtualFile file = !fileViewProvider.isPhysical() ? null : request.getVirtualFile();
        return file instanceof LightVirtualFile || file == null ? (Collection)CollectionsKt.emptyList() : (Collection)CollectionsKt.listOf((Object)Urls.newFromVirtualFile((VirtualFile)file));
    }

    @JvmStatic
    @Nullable
    public static final Url getDebuggableUrl(@Nullable PsiElement context) {
        return Companion.getDebuggableUrl(context);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/browsers/impl/WebBrowserServiceImpl$Companion;", "", "()V", "getDebuggableUrl", "Lcom/intellij/util/Url;", "context", "Lcom/intellij/psi/PsiElement;", "getDebuggableUrls", "", "getProviders", "Ljava/util/stream/Stream;", "Lcom/intellij/ide/browsers/WebBrowserUrlProvider;", "request", "Lcom/intellij/ide/browsers/OpenInBrowserRequest;", "intellij.xml.impl"})
    public static final class Companion {
        @NotNull
        public final Stream<WebBrowserUrlProvider> getProviders(@NotNull OpenInBrowserRequest request) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            DumbService dumbService = DumbService.getInstance((Project)request.getProject());
            Stream<WebBrowserUrlProvider> stream = WebBrowserServiceImplKt.access$getURL_PROVIDER_EP$p().extensions().filter((Predicate)new Predicate<WebBrowserUrlProvider>(dumbService, request){
                final /* synthetic */ DumbService $dumbService;
                final /* synthetic */ OpenInBrowserRequest $request;

                public final boolean test(WebBrowserUrlProvider it) {
                    DumbService dumbService = this.$dumbService;
                    Intrinsics.checkExpressionValueIsNotNull((Object)dumbService, (String)"dumbService");
                    return (!dumbService.isDumb() || DumbService.isDumbAware((Object)it)) && it.canHandleElement(this.$request);
                }
                {
                    this.$dumbService = dumbService;
                    this.$request = openInBrowserRequest;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull(stream, (String)"URL_PROVIDER_EP.extensio\u2026eElement(request)\n      }");
            return stream;
        }

        @NotNull
        public final Collection<Url> getDebuggableUrls(@Nullable PsiElement context) {
            try {
                OpenInBrowserRequest request;
                block7: {
                    block6: {
                        OpenInBrowserRequest openInBrowserRequest = request = context == null ? null : OpenInBrowserRequestKt.createOpenInBrowserRequest$default((PsiElement)context, (boolean)false, (int)2, null);
                        if (request == null) break block6;
                        FileViewProvider fileViewProvider = request.getFile().getViewProvider();
                        Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"request.file.viewProvider");
                        if (fileViewProvider.getBaseLanguage() != XMLLanguage.INSTANCE) break block7;
                    }
                    return CollectionsKt.emptyList();
                }
                request.setAppendAccessToken(false);
                Stream stream = this.getProviders(request).map(new Function<T, R>(request){
                    final /* synthetic */ OpenInBrowserRequest $request;

                    @NotNull
                    public final Collection<Url> apply(WebBrowserUrlProvider it) {
                        return WebBrowserServiceImplKt.access$getUrls(it, this.$request);
                    }
                    {
                        this.$request = openInBrowserRequest;
                    }
                });
                Object object = getDebuggableUrls.2.INSTANCE;
                if (object != null) {
                    Function1 function1 = object;
                    object = new WebBrowserServiceImplKt$sam$java_util_function_Predicate$0(function1);
                }
                List list = stream.filter((Predicate)object).findFirst().orElse(Collections.emptyList());
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"getProviders(request)\n  \u2026(Collections.emptyList())");
                return list;
            }
            catch (WebBrowserUrlProvider.BrowserException ignored) {
                return CollectionsKt.emptyList();
            }
        }

        @JvmStatic
        @Nullable
        public final Url getDebuggableUrl(@Nullable PsiElement context) {
            return (Url)ContainerUtil.getFirstItem(this.getDebuggableUrls(context));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

