/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.google.common.base.CharMatcher;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserReferenceConverter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="browser")
public class StartBrowserSettings {
    private boolean mySelected;
    private WebBrowser myBrowser;
    private String myUrl;
    private boolean myStartJavaScriptDebugger;

    @Attribute(value="start")
    public boolean isSelected() {
        return this.mySelected;
    }

    public void setSelected(boolean selected) {
        this.mySelected = selected;
    }

    @Attribute(value="name", converter=WebBrowserReferenceConverter.class)
    @Nullable
    public WebBrowser getBrowser() {
        return this.myBrowser;
    }

    public void setBrowser(@Nullable WebBrowser value) {
        this.myBrowser = value;
    }

    @Attribute
    @Nullable
    public String getUrl() {
        return this.myUrl;
    }

    public void setUrl(@Nullable String value) {
        String normalized = StringUtil.nullize((String)value, (boolean)true);
        if (normalized != null) {
            normalized = CharMatcher.whitespace().trimFrom((CharSequence)normalized);
        }
        this.myUrl = normalized;
    }

    @Attribute(value="with-js-debugger")
    public boolean isStartJavaScriptDebugger() {
        return this.myStartJavaScriptDebugger;
    }

    public void setStartJavaScriptDebugger(boolean value) {
        this.myStartJavaScriptDebugger = value;
    }

    @NotNull
    public static StartBrowserSettings readExternal(@NotNull Element parent) {
        if (parent == null) {
            StartBrowserSettings.$$$reportNull$$$0(0);
        }
        Element state = parent.getChild("browser");
        StartBrowserSettings settings = new StartBrowserSettings();
        if (state != null) {
            XmlSerializer.deserializeInto((Element)state, (Object)settings);
        }
        StartBrowserSettings startBrowserSettings = settings;
        if (startBrowserSettings == null) {
            StartBrowserSettings.$$$reportNull$$$0(1);
        }
        return startBrowserSettings;
    }

    public void writeExternal(@NotNull Element parent) {
        Element state;
        if (parent == null) {
            StartBrowserSettings.$$$reportNull$$$0(2);
        }
        if ((state = XmlSerializer.serialize((Object)this)) != null) {
            parent.addContent(state);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/browsers/StartBrowserSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/browsers/StartBrowserSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "readExternal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

