/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.settings;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.util.SPFileUtil;
import com.intellij.util.Consumer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="SpellCheckerSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class SpellCheckerSettings
implements PersistentStateComponent<Element> {
    private static final String SPELLCHECKER_MANAGER_SETTINGS_TAG = "SpellCheckerSettings";
    private static final String FOLDERS_ATTR_NAME = "Folders";
    private static final String FOLDER_ATTR_NAME = "Folder";
    private static final String CUSTOM_DICTIONARIES_ATTR_NAME = "CustomDictionaries";
    private static final String CUSTOM_DICTIONARY_ATTR_NAME = "CustomDictionary";
    private static final String DICTIONARIES_ATTR_NAME = "Dictionaries";
    private static final String DICTIONARY_ATTR_NAME = "Dictionary";
    private static final String RUNTIME_DICTIONARIES_ATTR_NAME = "RuntimeDictionaries";
    private static final String RUNTIME_DICTIONARY_ATTR_NAME = "RuntimeDictionary";
    private static final String BUNDLED_DICTIONARIES_ATTR_NAME = "BundledDictionaries";
    private static final String BUNDLED_DICTIONARY_ATTR_NAME = "BundledDictionary";
    private static final String CORRECTIONS_MAX_LIMIT = "CorrectionsLimit";
    private static final int DEFAULT_MAX_VALUE = 5;
    private static final String DICTIONARY_TO_SAVE_ATTR_NAME = "DefaultDictionary";
    private static final String DEFAULT_DICTIONARY_TO_SAVE = SpellCheckerManager.DictionaryLevel.PROJECT.getName();
    private static final String USE_SINGLE_DICT_ATTR_NAME = "UseSingleDictionary";
    private static final boolean DEFAULT_USE_SINGLE_DICT = true;
    private final List<String> myOldDictionaryFoldersPaths = new ArrayList<String>();
    private List<String> myCustomDictionariesPaths = new ArrayList<String>();
    private Set<String> myDisabledDictionariesPaths = new HashSet<String>();
    private Set<String> myBundledDisabledDictionariesPaths = new HashSet<String>();
    private Set<String> myRuntimeDisabledDictionariesNames = new HashSet<String>();
    private int myCorrectionsLimit = 5;
    private String myDictionaryToSave = DEFAULT_DICTIONARY_TO_SAVE;
    private boolean myUseSingleDictionaryToSave = true;

    public int getCorrectionsLimit() {
        return this.myCorrectionsLimit;
    }

    public void setCorrectionsLimit(int correctionsLimit) {
        this.myCorrectionsLimit = correctionsLimit;
    }

    public String getDictionaryToSave() {
        return this.myDictionaryToSave;
    }

    public void setDictionaryToSave(String dictionaryToSave) {
        this.myDictionaryToSave = dictionaryToSave;
    }

    public boolean isUseSingleDictionaryToSave() {
        return this.myUseSingleDictionaryToSave;
    }

    public void setUseSingleDictionaryToSave(boolean useSingleDictionaryToSave) {
        this.myUseSingleDictionaryToSave = useSingleDictionaryToSave;
    }

    public static SpellCheckerSettings getInstance(Project project) {
        return (SpellCheckerSettings)ServiceManager.getService((Project)project, SpellCheckerSettings.class);
    }

    public List<String> getCustomDictionariesPaths() {
        return this.myCustomDictionariesPaths;
    }

    public void setCustomDictionariesPaths(List<String> customDictionariesPaths) {
        this.myCustomDictionariesPaths = customDictionariesPaths;
    }

    public Set<String> getDisabledDictionariesPaths() {
        return this.myDisabledDictionariesPaths;
    }

    public void setDisabledDictionariesPaths(Set<String> disabledDictionariesPaths) {
        this.myDisabledDictionariesPaths = disabledDictionariesPaths;
    }

    public Set<String> getBundledDisabledDictionariesPaths() {
        return this.myBundledDisabledDictionariesPaths;
    }

    public void setBundledDisabledDictionariesPaths(Set<String> bundledDisabledDictionariesPaths) {
        this.myBundledDisabledDictionariesPaths = bundledDisabledDictionariesPaths;
    }

    public Set<String> getRuntimeDisabledDictionariesNames() {
        return this.myRuntimeDisabledDictionariesNames;
    }

    public void setRuntimeDisabledDictionariesNames(Set<String> runtimeDisabledDictionariesNames) {
        this.myRuntimeDisabledDictionariesNames = runtimeDisabledDictionariesNames;
    }

    public boolean isDefaultAdvancedSettings() {
        return this.myCorrectionsLimit == 5 && this.myUseSingleDictionaryToSave && this.myDictionaryToSave == DEFAULT_DICTIONARY_TO_SAVE;
    }

    public Element getState() {
        int j;
        if (this.myBundledDisabledDictionariesPaths.isEmpty() && this.myRuntimeDisabledDictionariesNames.isEmpty() && this.myOldDictionaryFoldersPaths.isEmpty() && this.myCustomDictionariesPaths.isEmpty() && this.myDisabledDictionariesPaths.isEmpty() && this.myCorrectionsLimit == 5 && this.myUseSingleDictionaryToSave && this.myDictionaryToSave.equals(DEFAULT_DICTIONARY_TO_SAVE)) {
            return null;
        }
        Element element = new Element(SPELLCHECKER_MANAGER_SETTINGS_TAG);
        element.setAttribute(BUNDLED_DICTIONARIES_ATTR_NAME, String.valueOf(this.myBundledDisabledDictionariesPaths.size()));
        Iterator<String> iterator = this.myBundledDisabledDictionariesPaths.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            element.setAttribute(BUNDLED_DICTIONARY_ATTR_NAME + i, iterator.next());
            ++i;
        }
        element.setAttribute(RUNTIME_DICTIONARIES_ATTR_NAME, String.valueOf(this.myRuntimeDisabledDictionariesNames.size()));
        iterator = this.myRuntimeDisabledDictionariesNames.iterator();
        i = 0;
        while (iterator.hasNext()) {
            element.setAttribute(RUNTIME_DICTIONARY_ATTR_NAME + i, iterator.next());
            ++i;
        }
        element.setAttribute(FOLDERS_ATTR_NAME, String.valueOf(this.myCustomDictionariesPaths.size()));
        for (j = 0; j < this.myCustomDictionariesPaths.size(); ++j) {
            element.setAttribute(FOLDER_ATTR_NAME + j, Paths.get(this.myCustomDictionariesPaths.get(j), new String[0]).getParent().toString());
        }
        element.setAttribute(CUSTOM_DICTIONARIES_ATTR_NAME, String.valueOf(this.myCustomDictionariesPaths.size()));
        for (j = 0; j < this.myCustomDictionariesPaths.size(); ++j) {
            element.setAttribute(CUSTOM_DICTIONARY_ATTR_NAME + j, this.myCustomDictionariesPaths.get(j));
        }
        element.setAttribute(DICTIONARIES_ATTR_NAME, String.valueOf(this.myDisabledDictionariesPaths.size()));
        iterator = this.myDisabledDictionariesPaths.iterator();
        i = 0;
        while (iterator.hasNext()) {
            element.setAttribute(DICTIONARY_ATTR_NAME + i, iterator.next());
            ++i;
        }
        element.setAttribute(CORRECTIONS_MAX_LIMIT, String.valueOf(this.myCorrectionsLimit));
        element.setAttribute(DICTIONARY_TO_SAVE_ATTR_NAME, this.myDictionaryToSave);
        element.setAttribute(USE_SINGLE_DICT_ATTR_NAME, String.valueOf(this.myUseSingleDictionaryToSave));
        return element;
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            SpellCheckerSettings.$$$reportNull$$$0(0);
        }
        this.myBundledDisabledDictionariesPaths.clear();
        this.myRuntimeDisabledDictionariesNames.clear();
        this.myCustomDictionariesPaths.clear();
        this.myOldDictionaryFoldersPaths.clear();
        this.myDisabledDictionariesPaths.clear();
        try {
            int i;
            int bundledDictionariesSize = StringUtil.parseInt((String)element.getAttributeValue(BUNDLED_DICTIONARIES_ATTR_NAME), (int)0);
            for (int i2 = 0; i2 < bundledDictionariesSize; ++i2) {
                this.myBundledDisabledDictionariesPaths.add(element.getAttributeValue(BUNDLED_DICTIONARY_ATTR_NAME + i2));
            }
            int runtimeDictionariesSize = StringUtil.parseInt((String)element.getAttributeValue(RUNTIME_DICTIONARIES_ATTR_NAME), (int)0);
            for (int i3 = 0; i3 < runtimeDictionariesSize; ++i3) {
                this.myRuntimeDisabledDictionariesNames.add(element.getAttributeValue(RUNTIME_DICTIONARY_ATTR_NAME + i3));
            }
            if (element.getAttributeValue(CUSTOM_DICTIONARIES_ATTR_NAME) == null) {
                int foldersSize = StringUtil.parseInt((String)element.getAttributeValue(FOLDERS_ATTR_NAME), (int)0);
                for (i = 0; i < foldersSize; ++i) {
                    this.myOldDictionaryFoldersPaths.add(element.getAttributeValue(FOLDER_ATTR_NAME + i));
                }
                this.myOldDictionaryFoldersPaths.forEach(folder -> SPFileUtil.processFilesRecursively(folder, (Consumer<? super String>)((Consumer)file -> {
                    if (FileUtilRt.extensionEquals((String)file, (String)"dic")) {
                        this.myCustomDictionariesPaths.add((String)file);
                    }
                })));
            }
            int customDictSize = StringUtil.parseInt((String)element.getAttributeValue(CUSTOM_DICTIONARIES_ATTR_NAME), (int)0);
            for (i = 0; i < customDictSize; ++i) {
                this.myCustomDictionariesPaths.add(element.getAttributeValue(CUSTOM_DICTIONARY_ATTR_NAME + i));
            }
            int scriptsSize = StringUtil.parseInt((String)element.getAttributeValue(DICTIONARIES_ATTR_NAME), (int)0);
            for (int i4 = 0; i4 < scriptsSize; ++i4) {
                this.myDisabledDictionariesPaths.add(element.getAttributeValue(DICTIONARY_ATTR_NAME + i4));
            }
            this.myCorrectionsLimit = StringUtil.parseInt((String)element.getAttributeValue(CORRECTIONS_MAX_LIMIT), (int)5);
            this.myDictionaryToSave = StringUtil.notNullize((String)element.getAttributeValue(DICTIONARY_TO_SAVE_ATTR_NAME), (String)DEFAULT_DICTIONARY_TO_SAVE);
            this.myUseSingleDictionaryToSave = Boolean.parseBoolean(StringUtil.notNullize((String)element.getAttributeValue(USE_SINGLE_DICT_ATTR_NAME), (String)String.valueOf(true)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spellchecker/settings/SpellCheckerSettings", "loadState"));
    }
}

