/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.spellchecker.StreamLoader;
import com.intellij.spellchecker.compress.CompressedDictionary;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.engine.Transformation;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public class SpellcheckerCorrectionsFilter {
    private static final Logger LOG = Logger.getInstance(SpellcheckerCorrectionsFilter.class);
    private static final String DICT = "excluded.dic";
    private Dictionary excludedCorrections;

    public static SpellcheckerCorrectionsFilter getInstance() {
        return (SpellcheckerCorrectionsFilter)ServiceManager.getService(SpellcheckerCorrectionsFilter.class);
    }

    public SpellcheckerCorrectionsFilter() {
        try (InputStream stream = this.getClass().getResourceAsStream(DICT);){
            this.excludedCorrections = CompressedDictionary.create(new StreamLoader(stream, DICT), new Transformation());
        }
        catch (IOException e) {
            LOG.warn("Couldn't load a dictionary for exclusion");
        }
    }

    public boolean isFiltered(@NotNull String string) {
        if (string == null) {
            SpellcheckerCorrectionsFilter.$$$reportNull$$$0(0);
        }
        return this.excludedCorrections != null && this.excludedCorrections.contains(string) == Boolean.TRUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/spellchecker/SpellcheckerCorrectionsFilter", "isFiltered"));
    }
}

