/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.i18n.GitBundle;
import java.awt.Component;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.exceptions.GithubOperationCanceledException;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubNotifications {
    private static final Logger LOG = GithubUtil.LOG;

    private static boolean isOperationCanceled(@NotNull Throwable e) {
        if (e == null) {
            GithubNotifications.$$$reportNull$$$0(0);
        }
        return e instanceof GithubOperationCanceledException || e instanceof ProcessCanceledException;
    }

    public static void showInfo(@NotNull Project project, @NotNull String title, @NotNull String message) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(1);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(2);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(3);
        }
        LOG.info(title + "; " + message);
        VcsNotifier.getInstance((Project)project).notifyImportantInfo(title, message);
    }

    public static void showWarning(@NotNull Project project, @NotNull String title, @NotNull String message) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(4);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(5);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(6);
        }
        LOG.info(title + "; " + message);
        VcsNotifier.getInstance((Project)project).notifyImportantWarning(title, message);
    }

    public static void showWarning(@NotNull Project project, @NotNull String title, @NotNull Exception e) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(7);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(8);
        }
        if (e == null) {
            GithubNotifications.$$$reportNull$$$0(9);
        }
        LOG.info(title + "; ", (Throwable)e);
        if (GithubNotifications.isOperationCanceled(e)) {
            return;
        }
        VcsNotifier.getInstance((Project)project).notifyImportantWarning(title, GithubUtil.getErrorTextFromException(e));
    }

    public static void showWarning(@NotNull Project project, @NotNull String title, @NotNull String message, AnAction ... actions) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(10);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(11);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(12);
        }
        LOG.info(title + "; " + message);
        Notification notification = new Notification(VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.getDisplayId(), title, message, NotificationType.WARNING);
        if (actions != null) {
            for (AnAction action2 : actions) {
                notification.addAction(action2);
            }
        }
        notification.notify(project);
    }

    public static void showError(@NotNull Project project, @NotNull String title, @NotNull String message) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(13);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(14);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(15);
        }
        LOG.info(title + "; " + message);
        VcsNotifier.getInstance((Project)project).notifyError(title, message);
    }

    public static void showError(@NotNull Project project, @NotNull String title, @NotNull String message, @NotNull String logDetails) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(16);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(17);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(18);
        }
        if (logDetails == null) {
            GithubNotifications.$$$reportNull$$$0(19);
        }
        LOG.warn(title + "; " + message + "; " + logDetails);
        VcsNotifier.getInstance((Project)project).notifyError(title, message);
    }

    public static void showError(@NotNull Project project, @NotNull String title, @NotNull Throwable e) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(20);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(21);
        }
        if (e == null) {
            GithubNotifications.$$$reportNull$$$0(22);
        }
        LOG.warn(title + "; ", e);
        if (GithubNotifications.isOperationCanceled(e)) {
            return;
        }
        VcsNotifier.getInstance((Project)project).notifyError(title, GithubUtil.getErrorTextFromException(e));
    }

    public static void showInfoURL(@NotNull Project project, @NotNull String title, @NotNull String message, @NotNull String url) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(23);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(24);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(25);
        }
        if (url == null) {
            GithubNotifications.$$$reportNull$$$0(26);
        }
        LOG.info(title + "; " + message + "; " + url);
        VcsNotifier.getInstance((Project)project).notifyImportantInfo(title, "<a href='" + url + "'>" + message + "</a>", NotificationListener.URL_OPENING_LISTENER);
    }

    public static void showWarningURL(@NotNull Project project, @NotNull String title, @NotNull String prefix, @NotNull String highlight, @NotNull String postfix, @NotNull String url) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(27);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(28);
        }
        if (prefix == null) {
            GithubNotifications.$$$reportNull$$$0(29);
        }
        if (highlight == null) {
            GithubNotifications.$$$reportNull$$$0(30);
        }
        if (postfix == null) {
            GithubNotifications.$$$reportNull$$$0(31);
        }
        if (url == null) {
            GithubNotifications.$$$reportNull$$$0(32);
        }
        LOG.info(title + "; " + prefix + highlight + postfix + "; " + url);
        VcsNotifier.getInstance((Project)project).notifyImportantWarning(title, prefix + "<a href='" + url + "'>" + highlight + "</a>" + postfix, NotificationListener.URL_OPENING_LISTENER);
    }

    public static void showErrorURL(@NotNull Project project, @NotNull String title, @NotNull String prefix, @NotNull String highlight, @NotNull String postfix, @NotNull String url) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(33);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(34);
        }
        if (prefix == null) {
            GithubNotifications.$$$reportNull$$$0(35);
        }
        if (highlight == null) {
            GithubNotifications.$$$reportNull$$$0(36);
        }
        if (postfix == null) {
            GithubNotifications.$$$reportNull$$$0(37);
        }
        if (url == null) {
            GithubNotifications.$$$reportNull$$$0(38);
        }
        LOG.info(title + "; " + prefix + highlight + postfix + "; " + url);
        VcsNotifier.getInstance((Project)project).notifyError(title, prefix + "<a href='" + url + "'>" + highlight + "</a>" + postfix, NotificationListener.URL_OPENING_LISTENER);
    }

    public static void showInfoDialog(@Nullable Project project, @NotNull String title, @NotNull String message) {
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(39);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(40);
        }
        LOG.info(title + "; " + message);
        Messages.showInfoMessage((Project)project, (String)message, (String)title);
    }

    public static void showInfoDialog(@NotNull Component component2, @NotNull String title, @NotNull String message) {
        if (component2 == null) {
            GithubNotifications.$$$reportNull$$$0(41);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(42);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(43);
        }
        LOG.info(title + "; " + message);
        Messages.showInfoMessage((Component)component2, (String)message, (String)title);
    }

    public static void showWarningDialog(@Nullable Project project, @NotNull String title, @NotNull String message) {
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(44);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(45);
        }
        LOG.info(title + "; " + message);
        Messages.showWarningDialog((Project)project, (String)message, (String)title);
    }

    public static void showWarningDialog(@NotNull Component component2, @NotNull String title, @NotNull String message) {
        if (component2 == null) {
            GithubNotifications.$$$reportNull$$$0(46);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(47);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(48);
        }
        LOG.info(title + "; " + message);
        Messages.showWarningDialog((Component)component2, (String)message, (String)title);
    }

    public static void showErrorDialog(@Nullable Project project, @NotNull String title, @NotNull String message) {
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(49);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(50);
        }
        LOG.info(title + "; " + message);
        Messages.showErrorDialog((Project)project, (String)message, (String)title);
    }

    public static void showErrorDialog(@Nullable Project project, @NotNull String title, @NotNull Throwable e) {
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(51);
        }
        if (e == null) {
            GithubNotifications.$$$reportNull$$$0(52);
        }
        LOG.warn(title, e);
        if (GithubNotifications.isOperationCanceled(e)) {
            return;
        }
        Messages.showErrorDialog((Project)project, (String)GithubUtil.getErrorTextFromException(e), (String)title);
    }

    public static void showErrorDialog(@NotNull Component component2, @NotNull String title, @NotNull Throwable e) {
        if (component2 == null) {
            GithubNotifications.$$$reportNull$$$0(53);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(54);
        }
        if (e == null) {
            GithubNotifications.$$$reportNull$$$0(55);
        }
        LOG.info(title, e);
        if (GithubNotifications.isOperationCanceled(e)) {
            return;
        }
        Messages.showErrorDialog((Component)component2, (String)GithubUtil.getErrorTextFromException(e), (String)title);
    }

    public static void showErrorDialog(@NotNull Component component2, @NotNull String title, @NotNull String prefix, @NotNull Exception e) {
        if (component2 == null) {
            GithubNotifications.$$$reportNull$$$0(56);
        }
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(57);
        }
        if (prefix == null) {
            GithubNotifications.$$$reportNull$$$0(58);
        }
        if (e == null) {
            GithubNotifications.$$$reportNull$$$0(59);
        }
        LOG.info(title, (Throwable)e);
        if (GithubNotifications.isOperationCanceled(e)) {
            return;
        }
        Messages.showErrorDialog((Component)component2, (String)(prefix + GithubUtil.getErrorTextFromException(e)), (String)title);
    }

    @Messages.YesNoResult
    public static boolean showYesNoDialog(@Nullable Project project, @NotNull String title, @NotNull String message) {
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(60);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(61);
        }
        return 0 == Messages.showYesNoDialog((Project)project, (String)message, (String)title, (Icon)Messages.getQuestionIcon());
    }

    @Messages.YesNoResult
    public static boolean showYesNoDialog(@Nullable Project project, @NotNull String title, @NotNull String message, @NotNull DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            GithubNotifications.$$$reportNull$$$0(62);
        }
        if (message == null) {
            GithubNotifications.$$$reportNull$$$0(63);
        }
        if (doNotAskOption == null) {
            GithubNotifications.$$$reportNull$$$0(64);
        }
        return 0 == Messages.showYesNoDialog((Project)project, (String)message, (String)title, (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)doNotAskOption);
    }

    @NotNull
    public static AnAction getConfigureAction(@NotNull Project project) {
        if (project == null) {
            GithubNotifications.$$$reportNull$$$0(65);
        }
        NotificationAction notificationAction = NotificationAction.createSimple((Supplier)GitBundle.messagePointer((String)"action.NotificationAction.GithubNotifications.text.configure", (Object[])new Object[0]), () -> ShowSettingsUtil.getInstance().showSettingsDialog(project, "GitHub"));
        if (notificationAction == null) {
            GithubNotifications.$$$reportNull$$$0(66);
        }
        return notificationAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 66: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 66: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 23: 
            case 27: 
            case 33: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 21: 
            case 24: 
            case 28: 
            case 34: 
            case 39: 
            case 42: 
            case 44: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 57: 
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: 
            case 6: 
            case 12: 
            case 15: 
            case 18: 
            case 25: 
            case 40: 
            case 43: 
            case 45: 
            case 48: 
            case 50: 
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logDetails";
                break;
            }
            case 26: 
            case 32: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 29: 
            case 35: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 30: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlight";
                break;
            }
            case 31: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postfix";
                break;
            }
            case 41: 
            case 46: 
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doNotAskOption";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/util/GithubNotifications";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/util/GithubNotifications";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigureAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isOperationCanceled";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showInfo";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showWarning";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "showInfoURL";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "showWarningURL";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "showErrorURL";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "showInfoDialog";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "showWarningDialog";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "showErrorDialog";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "showYesNoDialog";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getConfigureAction";
                break;
            }
            case 66: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 66: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

