/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.details.action;

import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.pullrequest.action.ui.GithubMergeCommitMessageDialog;
import org.jetbrains.plugins.github.pullrequest.data.GHPRMergeabilityState;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRStateService;
import org.jetbrains.plugins.github.pullrequest.ui.details.action.GHPRMergeAction;
import org.jetbrains.plugins.github.ui.util.SingleValueModel;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001BU\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u0012\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/action/GHPRCommitMergeAction;", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/action/GHPRMergeAction;", "busyStateModel", "Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;", "", "errorHandler", "Lkotlin/Function1;", "", "", "detailsModel", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "mergeabilityModel", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRMergeabilityState;", "project", "Lcom/intellij/openapi/project/Project;", "stateService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRStateService;", "(Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRStateService;)V", "submitMergeTask", "Ljava/util/concurrent/CompletableFuture;", "mergeability", "intellij.vcs.github"})
public final class GHPRCommitMergeAction
extends GHPRMergeAction {
    private final SingleValueModel<GHPullRequestShort> detailsModel;
    private final Project project;
    private final GHPRStateService stateService;

    @Override
    @Nullable
    public CompletableFuture<Unit> submitMergeTask(@NotNull GHPRMergeabilityState mergeability) {
        Intrinsics.checkParameterIsNotNull((Object)mergeability, (String)"mergeability");
        GithubMergeCommitMessageDialog dialog2 = new GithubMergeCommitMessageDialog(this.project, "Merge Pull Request", "Merge pull request #" + mergeability.getNumber(), this.detailsModel.getValue().getTitle());
        if (!dialog2.showAndGet()) {
            return null;
        }
        return this.stateService.merge((ProgressIndicator)new EmptyProgressIndicator(), mergeability.getNumber(), dialog2.getMessage(), mergeability.getHeadRefOid());
    }

    public GHPRCommitMergeAction(@NotNull SingleValueModel<Boolean> busyStateModel, @NotNull Function1<? super String, Unit> errorHandler, @NotNull SingleValueModel<GHPullRequestShort> detailsModel, @NotNull SingleValueModel<GHPRMergeabilityState> mergeabilityModel, @NotNull Project project, @NotNull GHPRStateService stateService) {
        Intrinsics.checkParameterIsNotNull(busyStateModel, (String)"busyStateModel");
        Intrinsics.checkParameterIsNotNull(errorHandler, (String)"errorHandler");
        Intrinsics.checkParameterIsNotNull(detailsModel, (String)"detailsModel");
        Intrinsics.checkParameterIsNotNull(mergeabilityModel, (String)"mergeabilityModel");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)stateService, (String)"stateService");
        super("Merge...", busyStateModel, errorHandler, mergeabilityModel);
        this.detailsModel = detailsModel;
        this.project = project;
        this.stateService = stateService;
        this.update();
    }
}

